/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.ESIndexSyncService;
import com.tydic.se.manage.api.ESIndexTemplateService;
import com.tydic.se.manage.bo.CreateEsIndexReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateReqBO;
import com.tydic.se.manage.bo.ESIndexTemplateRspBO;
import com.tydic.se.manage.bo.FlushEsIndexRsqBO;
import com.tydic.se.manage.bo.ModelDataToEsReqBO;
import com.tydic.se.manage.bo.SyncTaskReTryReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/indexTemplate"})
@ResponseResultBody
public class ESIndexTemplateController {
    private static final Logger log = LoggerFactory.getLogger(ESIndexTemplateController.class);
    @Autowired
    private ESIndexTemplateService esIndexTemplateService;
    @Autowired
    private ESIndexSyncService esIndexSyncService;

    @RequestMapping(value={"/selectESIndexTemplate"}, method={RequestMethod.POST})
    public Object selectESIndexTemplate(@Valid ESIndexTemplateReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ESIndexTemplateRspBO rspBO = this.esIndexTemplateService.selectESIndexTemplate(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/createEsIndex"}, method={RequestMethod.POST})
    public Object createEsIndex(@Valid CreateEsIndexReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.esIndexTemplateService.createEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/syncTaskReTry"}, method={RequestMethod.POST})
    public Object syncTaskReTry(@Valid SyncTaskReTryReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.esIndexTemplateService.syncTaskReTry(reqBO);
        return null;
    }

    @RequestMapping(value={"/modelDataToEsSynchronizer"}, method={RequestMethod.POST})
    public Object modelDataToEsSynchronizer(@Valid ModelDataToEsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        return this.esIndexSyncService.modelDataToEsSynchronizer(reqBO);
    }

    @RequestMapping(value={"/pauseSyncTask"}, method={RequestMethod.POST})
    public Object pauseSyncTask(@Valid ModelDataToEsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.esIndexSyncService.pauseSyncTask(reqBO);
        return null;
    }

    @RequestMapping(value={"/flushEsIndex"}, method={RequestMethod.POST})
    public Object flushEsIndex(@Valid ModelDataToEsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.esIndexSyncService.flushEsIndex(reqBO);
        return null;
    }

    @RequestMapping(value={"/getFlushEsIndexProgress"}, method={RequestMethod.POST})
    public FlushEsIndexRsqBO getFlushEsIndexProgress(@Valid ModelDataToEsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        return this.esIndexSyncService.getFlushEsIndexProgress(reqBO);
    }
}

