/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.EffectEvaluationService;
import com.tydic.se.manage.bo.EffectEvaluationRecordProgressRspBO;
import com.tydic.se.manage.bo.EffectEvaluationRecordReqBO;
import com.tydic.se.manage.bo.EffectEvaluationRecordRspBO;
import com.tydic.se.manage.bo.EffectEvaluationWordRecordReqBO;
import com.tydic.se.manage.bo.EffectEvaluationWordRecordRspBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/evaluation"})
@ResponseResultBody
public class EffectEvaluationController {
    private static final Logger log = LoggerFactory.getLogger(EffectEvaluationController.class);
    @Autowired
    private EffectEvaluationService effectEvaluationService;

    @RequestMapping(value={"/queryEffectEvaluationRecordList"}, method={RequestMethod.POST})
    public Object queryEffectEvaluationRecordList(@Valid EffectEvaluationRecordReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EffectEvaluationRecordRspBO rspBO = this.effectEvaluationService.queryEffectEvaluationRecordList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryEvaluationProgress"}, method={RequestMethod.POST})
    public Object queryEvaluationProgress(@Valid EffectEvaluationRecordReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EffectEvaluationRecordProgressRspBO rspBO = this.effectEvaluationService.queryEvaluationProgress(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryEvaluationWordInfoList"}, method={RequestMethod.POST})
    public Object queryEvaluationWordInfoList(@Valid EffectEvaluationWordRecordReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EffectEvaluationWordRecordRspBO rspBO = this.effectEvaluationService.queryEvaluationWordInfoList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryWResponseJsonStr"}, method={RequestMethod.POST})
    public EffectEvaluationWordRecordRspBO queryWResponseJsonStr(@Valid EffectEvaluationWordRecordReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EffectEvaluationWordRecordRspBO rspBO = this.effectEvaluationService.queryWResponseJsonStr(reqBO);
        return rspBO;
    }
}

