/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.MaterialService;
import com.tydic.se.manage.bo.MaterialBatchReqBO;
import com.tydic.se.manage.bo.MaterialBatchSearchRecordBO;
import com.tydic.se.manage.bo.MaterialSearchInfoBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/material"})
@ResponseResultBody
public class MaterialController {
    private static final Logger log = LoggerFactory.getLogger(MaterialController.class);
    @Autowired
    private MaterialService materialService;

    @RequestMapping(value={"/queryMaterialBatchRecordList"}, method={RequestMethod.POST})
    public Object queryMaterialBatchRecordList(@Valid MaterialBatchReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        RspPage rspBO = this.materialService.queryBatchRecordList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryBatchProgress"}, method={RequestMethod.POST})
    public Object queryEvaluationProgress(@Valid MaterialBatchReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        MaterialBatchSearchRecordBO rspBO = this.materialService.queryBatchProgress(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryBatchInfoList"}, method={RequestMethod.POST})
    public RspPage<MaterialSearchInfoBO> queryBatchInfoList(@Valid MaterialBatchReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        RspPage rspBO = this.materialService.queryBatchInfo(reqBO);
        return rspBO;
    }
}

