/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.tydic.se.manage.api.OptimizeDataService;
import com.tydic.se.manage.api.ReportStatisticsService;
import com.tydic.se.manage.api.SearchConfigService;
import com.tydic.se.manage.bo.CommonPageRspBO;
import com.tydic.se.manage.bo.DealOptimizeRecordReqBO;
import com.tydic.se.manage.bo.DynamicReportDataReqBO;
import com.tydic.se.manage.bo.QryOptimizeRecordReqBO;
import com.tydic.se.manage.bo.SeConfigureRecordRspBO;
import com.tydic.se.manage.bo.SeOptimizeRecordRspBO;
import com.tydic.se.manage.bo.SeReportStatisticsBO;
import com.tydic.se.manage.bo.SeReportStatisticsRspBO;
import com.tydic.se.manage.bo.SeWordCloudRspBO;
import com.tydic.se.manage.bo.SearchCommonReq;
import com.tydic.se.manage.bo.SearchConfigRsp;
import com.tydic.se.manage.bo.SearchSortConfigReq;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/Statistics"})
@ResponseResultBody
public class ReportStatisticsController {
    @Autowired
    private ReportStatisticsService reportStatisticsService;
    @Autowired
    private SearchConfigService searchConfigService;
    @Autowired
    private OptimizeDataService optimizeDataService;

    @RequestMapping(value={"/selectReportStatistics"})
    public Object selectReportStatistics(@Valid SeReportStatisticsBO reqBO) {
        SeReportStatisticsRspBO rspBO = this.reportStatisticsService.selectReportStatistics(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/selectWordCloudData"})
    public Object selectWordCloudData(@Valid SeReportStatisticsBO reqBO) {
        SeWordCloudRspBO rspBO = this.reportStatisticsService.selectWordCloudData(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/selectConfigureReportTabName"})
    public Object selectConfigureReportTabName() {
        SeConfigureRecordRspBO rspBO = this.reportStatisticsService.selectConfigureReportTabName();
        return rspBO;
    }

    @RequestMapping(value={"/getDynamicReportData"})
    public Object getDynamicReportData(@Valid DynamicReportDataReqBO reqBO) {
        CommonPageRspBO rspBO = this.reportStatisticsService.getDynamicReportData(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/queryOptimizeConfigList"})
    public Object queryOptimizeConfigList(@Valid SearchCommonReq reqBO) {
        SearchConfigRsp rspBO = this.searchConfigService.queryOptimizeConfigList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/updateOptimizeConfig"}, method={RequestMethod.POST})
    public Object updateOptimizeConfig(@Valid SearchSortConfigReq reqBO) {
        this.searchConfigService.updateOptimizeConfig(reqBO);
        return null;
    }

    @RequestMapping(value={"/getUnauditedOptimizeRecord"}, method={RequestMethod.POST})
    public Object getUnauditedOptimizeRecord(@Valid QryOptimizeRecordReqBO reqBO) {
        SeOptimizeRecordRspBO rspBO = this.optimizeDataService.getUnauditedOptimizeRecord(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/getAuditedOptimizeRecord"}, method={RequestMethod.POST})
    public Object getAuditedOptimizeRecord(@Valid QryOptimizeRecordReqBO reqBO) {
        SeOptimizeRecordRspBO rspBO = this.optimizeDataService.getAuditedOptimizeRecord(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/getAutoOptimizeRecordList"}, method={RequestMethod.POST})
    public Object getAutoOptimizeRecordList(@Valid QryOptimizeRecordReqBO reqBO) {
        SeOptimizeRecordRspBO rspBO = this.optimizeDataService.getAutoOptimizeRecordList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/dealOptimizeRecord"}, method={RequestMethod.POST})
    public Object dealOptimizeRecord(@Valid DealOptimizeRecordReqBO reqBO) {
        this.optimizeDataService.dealOptimizeRecord(reqBO);
        return null;
    }

    @RequestMapping(value={"/dealAutoOptimizeRecord"}, method={RequestMethod.POST})
    public Object dealAutoOptimizeRecord(@Valid DealOptimizeRecordReqBO reqBO) {
        this.optimizeDataService.dealAutoOptimizeRecord(reqBO);
        return null;
    }
}

