/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.tydic.se.app.ability.SeAppQueryService;
import com.tydic.se.app.ability.bo.SeAppSearchReqBO;
import com.tydic.se.app.ability.bo.SeAppSearchRspBO;
import com.tydic.se.search.util.SearchSortUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/seAppQuery"})
public class SeAppQueryController {
    private static final Logger log = LoggerFactory.getLogger(SeAppQueryController.class);
    @Autowired
    private SeAppQueryService seAppQueryService;

    @PostMapping(value={"/search"})
    @BusiResponseBody
    public SeAppSearchRspBO search(@RequestBody SeAppSearchReqBO reqBO) {
        String timeBegin = SearchSortUtils.getNowTime();
        SeAppSearchRspBO rspBO = this.seAppQueryService.search(reqBO);
        if (Boolean.TRUE.equals(reqBO.getLogTrajectoryOpen())) {
            List logTrajectory = rspBO.getLogTrajectory();
            JSONObject oneLog = new JSONObject();
            oneLog.put("time", (Object)timeBegin);
            oneLog.put("type", (Object)">>>TXT>>>".replace(">>>", ""));
            oneLog.put("title", (Object)"\u5b8c\u6574\u641c\u7d22");
            oneLog.put("data", (Object)SearchSortUtils.timeCalculation((String)"\u670d\u52a1", (String)timeBegin, (String)SearchSortUtils.getNowTime()));
            logTrajectory.add(oneLog);
        }
        return rspBO;
    }

    @PostMapping(value={"/categoryList"})
    @BusiResponseBody
    public SeAppSearchRspBO categoryList(@RequestBody SeAppSearchReqBO reqBO) {
        String timeBegin = SearchSortUtils.getNowTime();
        SeAppSearchRspBO rspBO = this.seAppQueryService.categoryList(reqBO);
        if (Boolean.TRUE.equals(reqBO.getLogTrajectoryOpen())) {
            List logTrajectory = rspBO.getLogTrajectory();
            JSONObject oneLog = new JSONObject();
            oneLog.put("time", (Object)timeBegin);
            oneLog.put("type", (Object)">>>TXT>>>".replace(">>>", ""));
            oneLog.put("title", (Object)"\u5b8c\u6574\u7b5b\u9009");
            oneLog.put("data", (Object)SearchSortUtils.timeCalculation((String)"\u5904\u7406\u8017\u65f6", (String)timeBegin, (String)SearchSortUtils.getNowTime()));
            logTrajectory.add(oneLog);
        }
        return rspBO;
    }

    @PostMapping(value={"/recommend"})
    @BusiResponseBody
    public SeAppSearchRspBO recommend(@RequestBody SeAppSearchReqBO reqBO) {
        return this.seAppQueryService.recommendSorting(reqBO);
    }
}

