/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.tydic.se.manage.api.SearchFrequentUsedWordsService;
import com.tydic.se.manage.api.SearchSynonymWordsService;
import com.tydic.se.manage.bo.SearchSynonymWordsBO;
import com.tydic.se.manage.bo.SearchSynonymWordsRsp;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seAppStatic"})
public class SeAppStaticFileController {
    private static final Logger log = LoggerFactory.getLogger(SeAppStaticFileController.class);
    @Autowired
    private SearchFrequentUsedWordsService searchFrequentUsedWordsService;
    @Autowired
    private SearchSynonymWordsService searchSynonymWordsService;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;

    @GetMapping(value={"config/synonymFile"})
    public void synonymFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fileName = "synonyms.txt";
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("text/plain");
        String since = request.getHeader("If-Modified-Since");
        log.debug("\u540c\u4e49\u8bcdIf-Modified-Since:{}", (Object)since);
        response.setHeader("Last-Modified", String.valueOf(new Date()));
        String match = request.getHeader("If-None-Match");
        if (!StringUtils.isEmpty((CharSequence)match)) {
            response.setHeader("If-None-Match", match);
        } else {
            response.setHeader("If-None-Match", "ETag");
        }
        PrintWriter output = response.getWriter();
        SearchSynonymWordsRsp rsp = this.searchSynonymWordsService.querySynonymWordsList();
        if (rsp != null && rsp.getRows() != null) {
            log.debug("\u540c\u4e49\u8bcd\u53d1\u751f\u53d8\u66f4");
            for (SearchSynonymWordsBO bo : rsp.getRows()) {
                output.println(bo.getWordContent());
            }
        }
        output.close();
    }

    @GetMapping(value={"config/wordFile"})
    public void wordFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String match;
        String since = request.getHeader("If-Modified-Since");
        String date = String.valueOf(new Date());
        log.info("\u9891\u7528\u8bcdIf-Modified-Since:{},\u8c03\u7528\u65f6\u95f4{}", (Object)since, (Object)date);
        List lastModifiedList = this.searchFrequentUsedWordsMapper.selectLastModified();
        String lastModified = null;
        List nonNullLastModifiedList = lastModifiedList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!nonNullLastModifiedList.isEmpty()) {
            lastModified = (String)Collections.max(nonNullLastModifiedList);
        }
        if (lastModified != null) {
            response.setHeader("Last-Modified", lastModified);
            if (lastModified.equals(since)) {
                return;
            }
        } else {
            response.setHeader("Last-Modified", String.valueOf(new Date()));
        }
        if (!StringUtils.isEmpty((CharSequence)(match = request.getHeader("If-None-Match")))) {
            response.setHeader("If-None-Match", match);
        } else {
            response.setHeader("If-None-Match", "ETag");
        }
        String fileName = "word.txt";
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("text/plain");
        PrintWriter output = response.getWriter();
        List rsp = this.searchFrequentUsedWordsService.querAllDsWordList();
        if (rsp != null) {
            log.info("\u9891\u7528\u8bcd\u53d1\u751f\u53d8\u66f4\uff0c\u6700\u540e\u66f4\u65b0\u65f6\u95f4:{},\u8c03\u7528\u65f6\u95f4{}", (Object)lastModified, (Object)date);
            for (String word : rsp) {
                output.println(word);
            }
        }
        output.close();
    }
}

