/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchAnalyticWordsTypeService;
import com.tydic.se.manage.bo.AddAnalyticUsedWordsTypeBO;
import com.tydic.se.manage.bo.SearchAnalyticWordsTypeRspBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeReqBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeRspBO;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.enums.OperModeEnum;
import javax.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/analyticWordsType"})
@ResponseResultBody
public class SearchAnalyticWordsTypeController {
    @Autowired
    private SearchAnalyticWordsTypeService analyticWordsTypeService;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/queryAnalyticWordsTypeList"}, method={RequestMethod.POST})
    public Object queryAnalyticWordsTypeList(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchAnalyticWordsTypeRspBO rsp = this.analyticWordsTypeService.queryAnalyticWordsTypeList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/queryNotUsedFrequentUsedWords"}, method={RequestMethod.POST})
    public Object queryNotUsedFrequentUsedWords(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchFrequentUsedWordsTypeRspBO rsp = this.analyticWordsTypeService.queryNotUsedFrequentUsedWords(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addAnalyticWordsTypeInfo"}, method={RequestMethod.POST})
    public Object addAnalyticWordsTypeInfo(@Valid AddAnalyticUsedWordsTypeBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.analyticWordsTypeService.addAnalyticWordsTypeInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.analysisManage.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u5206\u6790\u8bcd\u7c7b\u76ee\uff1a" + reqBO.getAnalyticWordsList());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateAnalyticWordsTypeStatus"}, method={RequestMethod.POST})
    public Object updateAnalyticWordsTypeStatus(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.analyticWordsTypeService.updateAnalyticWordsTypeStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.analysisManage.getDesc());
        if (reqBO.getTStatus() == 0) {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u5206\u6790\u8bcd\u7c7b\u76ee\uff1a" + reqBO.getTName());
        } else {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u5206\u6790\u8bcd\u7c7b\u76ee\uff1a" + reqBO.getTName());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteAnalyticWordsTypeInfo"}, method={RequestMethod.POST})
    public Object deleteAnalyticWordsTypeInfo(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.analyticWordsTypeService.deleteAnalyticWordsTypeInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.analysisManage.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5c06" + reqBO.getTName() + "\u5206\u6790\u8bcd\u7c7b\u76ee\u5220\u9664");
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/upAnalyticWordsType"})
    public Object upOrder(@Valid SearchFrequentUsedWordsTypeReqBO reqBO) {
        this.analyticWordsTypeService.changeOrderUp(reqBO);
        return null;
    }

    @RequestMapping(value={"/downAnalyticWordsType"})
    public Object downOrder(@Valid SearchFrequentUsedWordsTypeReqBO reqBO) {
        this.analyticWordsTypeService.changeOrderDown(reqBO);
        return null;
    }
}

