/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchCommonWordService;
import com.tydic.se.manage.bo.CommonWordsImportRsp;
import com.tydic.se.manage.bo.ExportCatalogRspBO;
import com.tydic.se.manage.bo.SearchCommonReq;
import com.tydic.se.manage.bo.SearchCommonRsp;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/searchCommonWord"})
@ResponseResultBody
public class SearchCommonWordsController {
    @Autowired
    private SearchCommonWordService searchCommonWordService;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/querySearchCommonWord"}, method={RequestMethod.POST})
    public Object querySearchCommonWord(@Valid SearchCommonReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchCommonRsp rsp = this.searchCommonWordService.queryCommonWordsList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addCommonWordInfo"}, method={RequestMethod.POST})
    public Object addCommonWordInfo(@Valid SearchCommonReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchCommonWordService.addCommonWordInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u5c06" + reqBO.getWName() + "\u6539\u5199\u4e3a\uff1a" + reqBO.getCommWordList());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateCommonWordInfo"}, method={RequestMethod.POST})
    public Object updateCommonWordInfo(@Valid SearchCommonReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchCommonWordService.updateCommonWordInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
        logReqBO.setOperType("M");
        logReqBO.setOperContent("\u5c06" + reqBO.getWName() + "\u6539\u5199\u8bcd\u4fee\u6539\u4e3a\uff1a" + reqBO.getCommWordList());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateCommonWordStatus"}, method={RequestMethod.POST})
    public Object updateCommonWordStatus(@Valid SearchCommonReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchCommonWordService.updateCommonWordStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
        if (reqBO.getWStatus() == 0) {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u6539\u5199\u8bcd\uff1a" + reqBO.getWName());
        } else {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u6539\u5199\u8bcd\uff1a" + reqBO.getWName());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteCommonWordInfo"}, method={RequestMethod.POST})
    public Object deleteCommonWordInfo(@Valid SearchCommonReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchCommonWordService.deleteCommonWordInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5c06" + reqBO.getWName() + "\u6539\u5199\u8bcd\u5220\u9664");
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/exportCommonWord"}, method={RequestMethod.POST})
    public Object exportCommonWord() {
        ExportCatalogRspBO rsp = this.searchCommonWordService.exportCommonWord();
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u6539\u5199\u8bcd");
        this.operLogService.insertOperLog(logReqBO);
        return rsp;
    }

    @RequestMapping(value={"/importCommonWord"}, method={RequestMethod.POST})
    public void importCommonWord(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CommonWordsImportRsp rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.searchCommonWordService.importCommonWord(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u6539\u5199\u8bcd");
            this.operLogService.insertOperLog(logReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
    }

    public Workbook checkTemplate(Workbook workbook) {
        Row row1;
        System.out.println(workbook.getNumberOfSheets());
        if (workbook.getNumberOfSheets() <= 0) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            if (row1.getLastCellNum() != 2) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            Cell cell1 = row1.getCell(1);
            if (cell == null || !cell.toString().equals("\u4e3b\u8bcd")) {
                workbook = null;
                return workbook;
            }
            if (cell1 == null || !cell1.toString().equals("\u6539\u5199\u8bcd")) {
                workbook = null;
                return workbook;
            }
        }
        return workbook;
    }
}

