/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.SearchConfigService;
import com.tydic.se.manage.bo.SearchAllConfigReq;
import com.tydic.se.manage.bo.SearchAllConfigRspBO;
import com.tydic.se.manage.bo.SearchConfigNewBo;
import com.tydic.se.manage.bo.SearchSortConfigReq;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/searchConfig"})
@ResponseResultBody
public class SearchConfigController {
    @Autowired
    private SearchConfigService searchConfigService;

    @RequestMapping(value={"/getInitConfig"}, method={RequestMethod.POST})
    public Object getInitConfig() {
        return this.searchConfigService.getInitConfig();
    }

    @RequestMapping(value={"/queryAllConfigList"}, method={RequestMethod.POST})
    public Object queryAllConfigList(@Valid SearchAllConfigReq reqBO) {
        SearchAllConfigRspBO rspBO = this.searchConfigService.queryAllConfigList(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/updateAllConfig"}, method={RequestMethod.POST})
    public Object updateAllConfig(@Valid SearchSortConfigReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchConfigService.updateAllConfig(reqBO);
        return null;
    }

    @RequestMapping(value={"/addAutoConfig"}, method={RequestMethod.POST})
    public Object addAutoConfig(@Valid SearchConfigNewBo reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchConfigService.addAutoConfig(reqBO);
        return null;
    }
}

