/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.base.dao.po.StandSeEntityCachePo;
import com.tydic.se.manage.api.SearchEntityCacheService;
import com.tydic.se.manage.bo.EntityCacheReqBO;
import com.tydic.se.manage.bo.EntityCacheRspBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/entityCache"})
@ResponseResultBody
public class SearchEntityCacheController {
    @Autowired
    private SearchEntityCacheService searchEntityCacheService;

    @RequestMapping(value={"/addEntityCache"}, method={RequestMethod.POST})
    public Object addEntityCache(@Valid EntityCacheReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EntityCacheRspBO rspBO = this.searchEntityCacheService.addEntityCache(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/updateEntityCache"}, method={RequestMethod.POST})
    public Object updateEntityCache(@Valid EntityCacheReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        EntityCacheRspBO rspBO = this.searchEntityCacheService.updateEntityCache(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/listPage"}, method={RequestMethod.POST})
    public RspPage<StandSeEntityCachePo> selectEntityCacheList(EntityCacheReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        RspPage rspPage = this.searchEntityCacheService.selectEntityCacheList(reqBO);
        return rspPage;
    }

    @RequestMapping(value={"/queryEnum"}, method={RequestMethod.POST})
    public Object queryCacheEnum() {
        return this.searchEntityCacheService.queryCacheEnum();
    }
}

