/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.tydic.se.manage.api.SearchEvaluationWordReturnRecordService;
import com.tydic.se.manage.bo.SearchEvaluationWordReturnRecordBO;
import com.tydic.se.manage.bo.SearchEvaluationWordReturnRecordReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.util.CommTools;
import com.tydic.se.manage.util.ExcelUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/evaluation"})
@ResponseResultBody
public class SearchEvaluationWordReturnRecordController {
    @Autowired
    private SearchEvaluationWordReturnRecordService searchEvaluationWordReturnRecordService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportEvaluationRecord"}, method={RequestMethod.GET})
    public void importCollectionRuleConfig(SearchEvaluationWordReturnRecordReqBO reqBO, HttpServletRequest request, HttpServletResponse response) {
        List list = null;
        try {
            list = this.searchEvaluationWordReturnRecordService.querySearchEvaluationWordReturnRecordList(reqBO);
            ClassPathResource resource = new ClassPathResource("EvaluationRecordResults.xlsx");
            InputStream inputStream = resource.getInputStream();
            String fileName = "";
            ArrayList exportData = new ArrayList();
            ArrayList<Integer> mergeIndex = new ArrayList<Integer>();
            mergeIndex.add(0);
            if (list != null && list.size() > 0) {
                for (SearchEvaluationWordReturnRecordBO obj : list) {
                    ArrayList<String> a = new ArrayList<String>();
                    a.add(obj.getEvalWord());
                    a.add(obj.getSkuId().toString());
                    a.add(CommTools.delHTMLTag((String)obj.getSkuName()));
                    a.add(obj.getCommodityName());
                    a.add(obj.getL3CatelogName());
                    a.add(obj.getBrandName());
                    a.add(obj.getVendorName());
                    exportData.add(a);
                }
            }
            XSSFWorkbook wb = ExcelUtils.exportToExcelForXlsx(exportData, (InputStream)inputStream, mergeIndex, (HttpServletResponse)response);
            ServletOutputStream os = null;
            try {
                os = response.getOutputStream();
                fileName = reqBO.getEvalName() + ".xls";
                response.reset();
                response.setCharacterEncoding("UTF-8");
                fileName = new String(fileName.getBytes(), "ISO8859-1");
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                response.setContentType("application/octet-stream");
                wb.write((OutputStream)os);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    wb.close();
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/exportResultExcel"}, method={RequestMethod.GET})
    public void exportExcel(@Valid SearchEvaluationWordReturnRecordReqBO reqBO, HttpServletRequest request, HttpServletResponse response) {
        List list = this.searchEvaluationWordReturnRecordService.querySearchEvaluationWordReturnRecordList(reqBO);
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("\u53ec\u56de\u7ed3\u679c");
        sheet.setDefaultRowHeight((short)512);
        sheet.setColumnWidth(0, 3000);
        sheet.setColumnWidth(1, 3000);
        sheet.setColumnWidth(2, 3000);
        sheet.setColumnWidth(3, 8000);
        sheet.setColumnWidth(4, 7000);
        sheet.setColumnWidth(5, 7000);
        sheet.setColumnWidth(6, 7000);
        XSSFFont headFont = wb.createFont();
        headFont.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        headFont.setBold(true);
        headFont.setFontHeightInPoints((short)11);
        XSSFCellStyle headStyle = wb.createCellStyle();
        headStyle.setFont((Font)headFont);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFFont font = wb.createFont();
        font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        font.setFontHeightInPoints((short)11);
        XSSFCellStyle style = wb.createCellStyle();
        style.setFont((Font)font);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow row = sheet.createRow(0);
        XSSFCell cell = row.createCell(0);
        String[] heads = new String[]{"\u67e5\u8be2\u77ed\u8bed", "\u5355\u54c1SKU_ID", "\u5355\u54c1\u540d\u79f0", "\u5546\u54c1\u540d\u79f0", "\u4e09\u7ea7\u7c7b\u76ee", "\u54c1\u724c ", "\u4f9b\u5e94\u5546"};
        for (int i = 0; i < heads.length; ++i) {
            cell = row.createCell(i);
            cell.setCellValue(heads[i]);
            cell.setCellStyle((CellStyle)headStyle);
        }
        for (int i = 0; i < list.size(); ++i) {
            XSSFRow rows = sheet.createRow(i + 1);
            XSSFCell cells = rows.createCell(0);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getEvalName());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(1);
            cells.setCellValue((double)((SearchEvaluationWordReturnRecordBO)list.get(i)).getSkuId().longValue());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(2);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getSkuName());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(3);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getCommodityName());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(4);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getL3CatelogName());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(5);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getBrandName());
            cells.setCellStyle((CellStyle)style);
            cells = rows.createCell(6);
            cells.setCellValue(((SearchEvaluationWordReturnRecordBO)list.get(i)).getVendorName());
            cells.setCellStyle((CellStyle)style);
        }
        ServletOutputStream outputStream = null;
        try {
            outputStream = response.getOutputStream();
            StringBuilder s1 = new StringBuilder();
            String fileName = "\u6d4b\u8bc4\u8bb0\u5f55";
            s1.append("attachment; filename=").append(new String(fileName.getBytes("UTF-8"), "ISO-8859-1")).append(".xls");
            response.reset();
            response.setHeader("Content-disposition", s1.toString());
            response.setContentType("APPLICATION/OCTET-STREAM");
            wb.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                wb.close();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

