/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchFrequentUsedWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportFrequentUsedWordsRspBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsReqBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsRspBO;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.constants.JedisHelper;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchFrequentUsedWordsMapper;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/frequentUsedWords"})
@ResponseResultBody
public class SearchFrequentUsedWordsController {
    private static final Logger log = LoggerFactory.getLogger(SearchFrequentUsedWordsController.class);
    @Autowired
    private SearchFrequentUsedWordsService searchFrequentUsedWordsService;
    @Autowired
    private SearchFrequentUsedWordsMapper searchFrequentUsedWordsMapper;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/queryFrequentUsedWordsList"}, method={RequestMethod.POST})
    public Object queryFrequentUsedWordsList(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchFrequentUsedWordsRspBO rsp = this.searchFrequentUsedWordsService.queryFrequentUsedWordsList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addFrequentUsedWordsInfo"}, method={RequestMethod.POST})
    public Object addFrequentUsedWordsInfo(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsService.addFrequentUsedWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u9891\u7528\u8bcd:" + reqBO.getFWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateFrequentUsedWordsInfo"}, method={RequestMethod.POST})
    public Object updateFrequentUsedWordsInfo(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsService.updateFrequentUsedWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
        logReqBO.setOperType("M");
        logReqBO.setOperContent("\u4fee\u6539\u9891\u7528\u8bcd:" + reqBO.getFWord() + ",\u9891\u7528\u8bcd\u7c7b\u76ee\uff1a[\u6539\u53d8\u524d\uff1a" + reqBO.getOldTypeName() + ",\u6539\u53d8\u540e\uff1a" + reqBO.getNewTypeName() + "]");
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateFrequentUsedWordsStatus"}, method={RequestMethod.POST})
    public Object updateFrequentUsedWordsStatus(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsService.updateFrequentUsedWordsStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
        if (reqBO.getFStatus() == 1) {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u9891\u7528\u8bcd-id=" + reqBO.getFWord());
        } else {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u9891\u7528\u8bcd-id=" + reqBO.getFWord());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteFrequentUsedWordsInfo"}, method={RequestMethod.POST})
    public Object deleteFrequentUsedWordsInfo(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsService.deleteFrequentUsedWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5220\u9664\u9891\u7528\u8bcd-id=" + reqBO.getFWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/exportFrequentUsedWords"}, method={RequestMethod.POST})
    public Object exportList(@Valid SearchFrequentUsedWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ExportInfoRspBO rspBO = this.searchFrequentUsedWordsService.exportFrequentUsedWords(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/importFrequentUsedWords"}, method={RequestMethod.POST})
    public void importFrequentUsedWords(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList != null && cList.size() > 0) {
                Boolean flag = JedisHelper.tryGetDistributedLock((CacheClient)this.cacheClient, (String)"import_frequent_used_words_lock", (Boolean)false, null);
                if (!flag.booleanValue()) {
                    log.error("---------\u9891\u7528\u8bcd\u5bfc\u5165\u5176\u4ed6\u8fdb\u7a0b\u6b63\u5728\u6267\u884c\uff0c\u76f4\u63a5\u8fd4\u56de----------");
                    throw new ZTBusinessException("\u6709\u9891\u7528\u8bcd\u5bfc\u5165\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                }
                try {
                    this.searchFrequentUsedWordsService.importFrequentUsedWords(cList);
                }
                catch (Exception e) {
                    JedisHelper.releaseDistributedLock((CacheClient)this.cacheClient, (String)"import_frequent_used_words_lock", null);
                }
            } else {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            res.put("code", "0");
            res.put("message", "\u4e0a\u4f20\u6210\u529f\uff0c\u9891\u7528\u8bcd\u5bfc\u5165\u4e2d\u3002\u3002\u3002\u3002\u3002\u3002");
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u9891\u7528\u8bcd");
            this.operLogService.insertOperLog(logReqBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("code", "9999");
            res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
    }

    @RequestMapping(value={"/importFrequentUsedWordsSchedule"}, method={RequestMethod.POST})
    public Object importFrequentUsedWordsSchedule() {
        try {
            ImportFrequentUsedWordsRspBO rspBO = (ImportFrequentUsedWordsRspBO)this.cacheClient.get(Constants.ImportRspKey.frequentUsedWords_lockKey_rspKey, ImportFrequentUsedWordsRspBO.class);
            if (rspBO != null) {
                rspBO.setCode("0");
            } else {
                rspBO = new ImportFrequentUsedWordsRspBO();
                rspBO.setCode("9999");
                rspBO.setMessage("\u5f53\u524d\u6ca1\u6709\u6b63\u5728\u6267\u884c\u7684\u5bfc\u5165\u4efb\u52a1\uff01");
            }
            return rspBO;
        }
        catch (Exception e) {
            RspBaseBO rspBaseBO = new RspBaseBO();
            rspBaseBO.setCode("9999");
            rspBaseBO.setMessage("\u67e5\u8be2\u5931\u8d25\uff01");
            return rspBaseBO;
        }
    }

    public Workbook checkTemplate(Workbook workbook) {
        Row row1;
        if (workbook.getNumberOfSheets() < 1) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            if (row1.getLastCellNum() != 3) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            Cell cell1 = row1.getCell(1);
            Cell cell2 = row1.getCell(2);
            if (cell == null || !cell.toString().equals("\u9891\u7528\u8bcd\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell1 == null || !cell1.toString().equals("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell2 == null || !cell2.toString().equals("\u7d22\u5f15\u5b57\u6bb5")) {
                workbook = null;
                return workbook;
            }
        }
        return workbook;
    }

    @RequestMapping(value={"/wordFileCsv"}, method={RequestMethod.GET})
    public void exportWordFileCsv(HttpServletResponse response) throws Exception {
        String fileName = "frequentUsedWords.csv";
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("text/plain");
        PrintWriter output = response.getWriter();
        List rsp = this.searchFrequentUsedWordsService.exportFrequentUsedWords();
        if (rsp != null) {
            for (String word : rsp) {
                output.println(word);
            }
        }
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u9891\u7528\u8bcd");
        this.operLogService.insertOperLog(logReqBO);
        output.close();
    }
}

