/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchFrequentUsedWordsTypeService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportFrequentUsedWordsTypeRspBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeReqBO;
import com.tydic.se.manage.bo.SearchFrequentUsedWordsTypeRspBO;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/frequentUsedWordsType"})
@ResponseResultBody
public class SearchFrequentUsedWordsTypeController {
    @Autowired
    private SearchFrequentUsedWordsTypeService searchFrequentUsedWordsTypeService;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/queryFrequentUsedWordsTypeList"}, method={RequestMethod.POST})
    public Object queryFrequentUsedWordsTypeList(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchFrequentUsedWordsTypeRspBO rsp = this.searchFrequentUsedWordsTypeService.queryFrequentUsedWordsTypeList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/queryFrequentUsedWordsTypeAllList"}, method={RequestMethod.POST})
    public Object queryFrequentUsedWordsTypeAllList(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchFrequentUsedWordsTypeRspBO rsp = this.searchFrequentUsedWordsTypeService.queryFrequentUsedWordsTypeAllList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addFrequentUsedWordsTypeInfo"}, method={RequestMethod.POST})
    public Object addFrequentUsedWordsTypeInfo(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsTypeService.addFrequentUsedWordsTypeInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u9891\u7528\u8bcd\u7c7b\u76ee\u540d\u79f0:" + reqBO.getTName() + ",\u5bf9\u5e94\u7d22\u5f15\u5b57\u6bb5\uff1a" + reqBO.getIndexField() + ",\u9891\u7528\u8bcd\u5206\u7c7b\u6743\u91cd\uff1a" + reqBO.getTWeight());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateFrequentUsedWordsTypeInfo"}, method={RequestMethod.POST})
    public Object updateFrequentUsedWordsTypeInfo(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsTypeService.updateFrequentUsedWordsTypeInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
        logReqBO.setOperType("M");
        logReqBO.setOperContent("\u4fee\u6539\u9891\u7528\u8bcd\u7c7b\u76ee\uff1a" + reqBO.getTName() + "\u6743\u91cd\u53d8\u5316\uff1a[\u6539\u8fb9\u524d\uff1a" + reqBO.getOldTWeight() + "\uff0c\u6539\u53d8\u540e\uff1a" + reqBO.getTWeight() + "]");
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateFrequentUsedWordsTypeStatus"}, method={RequestMethod.POST})
    public Object updateFrequentUsedWordsTypeStatus(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsTypeService.updateFrequentUsedWordsTypeStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
        if (reqBO.getTStatus() == 1) {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u9891\u7528\u8bcd\u7c7b\u76ee:" + reqBO.getTName());
        } else {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u9891\u7528\u8bcd\u7c7b\u76ee:" + reqBO.getTName());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteFrequentUsedWordsTypeInfo"}, method={RequestMethod.POST})
    public Object deleteFrequentUsedWordsTypeInfo(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchFrequentUsedWordsTypeService.deleteFrequentUsedWordsTypeInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5220\u9664\u9891\u7528\u8bcd\u7c7b\u76ee:" + reqBO.getTName());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/exportFrequentUsedWordsTypes"}, method={RequestMethod.POST})
    public Object exportList(@Valid SearchFrequentUsedWordsTypeReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ExportInfoRspBO rspBO = this.searchFrequentUsedWordsTypeService.exportFrequentUsedWordsType(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u9891\u7528\u8bcd\u7c7b\u76ee");
        this.operLogService.insertOperLog(logReqBO);
        return rspBO;
    }

    @RequestMapping(value={"/importFrequentUsedWordsTypes"}, method={RequestMethod.POST})
    public void importFrequentUsedWordsTypes(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ImportFrequentUsedWordsTypeRspBO rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.searchFrequentUsedWordsTypeService.importFrequentUsedWordsType(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.frequentCateManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u9891\u7528\u8bcd\u7c7b\u76ee");
            this.operLogService.insertOperLog(logReqBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("code", "9999");
            res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
    }

    public Workbook checkTemplate(Workbook workbook) {
        Row row1;
        if (workbook.getNumberOfSheets() < 1) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            if (row1.getLastCellNum() != 2) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            Cell cell1 = row1.getCell(1);
            if (cell == null || !cell.toString().equals("\u9891\u7528\u8bcd\u7c7b\u76ee\u540d")) {
                workbook = null;
                return workbook;
            }
            if (cell1 == null || !cell1.toString().equals("\u5bf9\u5e94\u7d22\u5f15\u5b57\u6bb5")) {
                workbook = null;
                return workbook;
            }
        }
        return workbook;
    }
}

