/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.base.ability.bo.SeAppSkuSyncReqBO;
import com.tydic.se.base.ability.bo.SeAppSkuSyncRspBO;
import com.tydic.se.manage.api.SearchSkuSyncService;
import com.tydic.se.manage.bo.QueryStandSeAsyncSkusReqBO;
import com.tydic.se.manage.bo.QueryStandSeAsyncSkusRspBO;
import com.tydic.se.manage.bo.VectorSyncReqBO;
import com.tydic.se.manage.bo.VectorSyncRspBO;
import com.tydic.se.manage.config.ResponseResultBody;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/skuSync"})
@ResponseResultBody
public class SearchSkuSyncController {
    @Autowired
    private SearchSkuSyncService skuSyncService;

    @RequestMapping(value={"/addSkuChange"}, method={RequestMethod.POST})
    public Object recordSkuChanges(@Valid @RequestBody SeAppSkuSyncReqBO seAppSkuSyncReqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SeAppSkuSyncRspBO rspBO = this.skuSyncService.recordSkuChanges(seAppSkuSyncReqBO);
        return rspBO;
    }

    @RequestMapping(value={"/vectorSync"}, method={RequestMethod.POST})
    public Object vectorSync() {
        return this.skuSyncService.vectorSync();
    }

    @RequestMapping(value={"/queryStandSeAsyncSkus"}, method={RequestMethod.POST})
    public Object queryStandSeAsyncSkus(@Valid QueryStandSeAsyncSkusReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        QueryStandSeAsyncSkusRspBO rspBO = this.skuSyncService.queryStandSeAsyncSkus(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/dealSyncFailed"}, method={RequestMethod.POST})
    public Object dealSyncFailed(@Valid @RequestBody VectorSyncReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        VectorSyncRspBO rspBO = this.skuSyncService.dealSyncFailed(reqBO);
        return rspBO;
    }

    @RequestMapping(value={"/querySyncEnum"}, method={RequestMethod.POST})
    public Object querySyncEnum() {
        return this.skuSyncService.querySyncEnum();
    }
}

