/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchStopWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportStopWordsRspBO;
import com.tydic.se.manage.bo.SearchStopWordsBO;
import com.tydic.se.manage.bo.SearchStopWordsReqBO;
import com.tydic.se.manage.bo.SearchStopWordsRspBO;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchStopWordsMapper;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/searchStops"})
@ResponseResultBody
public class SearchStopWordsController {
    private static final Logger log = LoggerFactory.getLogger(SearchStopWordsController.class);
    @Autowired
    private SearchStopWordsService stopWordsService;
    @Autowired
    private SearchStopWordsMapper searchStopWordsMapper;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/queryStopWordsList"}, method={RequestMethod.POST})
    public Object queryStopWordsList(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchStopWordsRspBO rsp = this.stopWordsService.queryStopWordsList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addStopWordsInfo"}, method={RequestMethod.POST})
    public Object addStopWordsInfo(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.stopWordsService.addStopWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u505c\u7528\u8bcd:" + reqBO.getStopWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateStopWordsInfo"}, method={RequestMethod.POST})
    public Object updateStopWordsInfo(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.stopWordsService.updateStopWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
        logReqBO.setOperType("M");
        logReqBO.setOperContent("\u4fee\u6539\u505c\u7528\u8bcd:" + reqBO.getStopWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateStopWordsStatus"}, method={RequestMethod.POST})
    public Object updateStopWordsStatus(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.stopWordsService.updateStopWordsStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
        if (reqBO.getSStatus() == 1) {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u505c\u7528\u8bcd:" + reqBO.getStopWord());
        } else {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u505c\u7528\u8bcd:" + reqBO.getStopWord());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteStopWordsInfo"}, method={RequestMethod.POST})
    public Object deleteStopWordsInfo(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.stopWordsService.deleteStopWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5220\u9664\u505c\u7528\u8bcd:" + reqBO.getStopWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/exportStopWords"}, method={RequestMethod.POST})
    public Object exportList(@Valid SearchStopWordsReqBO reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ExportInfoRspBO rspBO = this.stopWordsService.exportStopWords(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u505c\u7528\u8bcd");
        this.operLogService.insertOperLog(logReqBO);
        return rspBO;
    }

    @RequestMapping(value={"/importStopWords"}, method={RequestMethod.POST})
    public void importStopWords(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ImportStopWordsRspBO rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.stopWordsService.importStopWords(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.stopManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u505c\u7528\u8bcd");
            this.operLogService.insertOperLog(logReqBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("code", "9999");
            res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
    }

    public Workbook checkTemplate(Workbook workbook) {
        Row row1;
        if (workbook.getNumberOfSheets() < 1) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            if (row1.getLastCellNum() != 1) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            if (cell == null || !cell.toString().equals("\u505c\u7528\u8bcd\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
        }
        return workbook;
    }

    @RequestMapping(value={"/stopFile"}, method={RequestMethod.GET})
    public void exportStopFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String match;
        String fileName = "stop.txt";
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("text/plain");
        String since = request.getHeader("If-Modified-Since");
        String lastModified = this.searchStopWordsMapper.selectLastModified();
        if (lastModified != null) {
            response.setHeader("Last-Modified", lastModified);
            if (lastModified.equals(since)) {
                return;
            }
        } else {
            response.setHeader("Last-Modified", String.valueOf(new Date()));
        }
        if (!StringUtils.isEmpty((CharSequence)(match = request.getHeader("If-None-Match")))) {
            response.setHeader("If-None-Match", match);
        } else {
            response.setHeader("If-None-Match", "ETag");
        }
        PrintWriter output = response.getWriter();
        List rsp = this.stopWordsService.queryStopWordsList();
        if (rsp != null && rsp.size() > 0) {
            log.info("\u505c\u7528\u8bcd\u53d1\u751f\u53d8\u66f4");
            for (SearchStopWordsBO bo : rsp) {
                output.println(bo.getStopWord());
            }
        }
        output.close();
    }
}

