/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.api.SearchSynonymWordsService;
import com.tydic.se.manage.bo.ExportInfoRspBO;
import com.tydic.se.manage.bo.ImportSynonymWordsRspBO;
import com.tydic.se.manage.bo.SearchSynonymWordsReq;
import com.tydic.se.manage.bo.SearchSynonymWordsRsp;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.XlsUtil;
import com.tydic.se.manage.dao.SearchSynonymWordsMapper;
import com.tydic.se.manage.enums.OperModeEnum;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/searchSynonymWords"})
@ResponseResultBody
public class SearchSynonymWordsController {
    private static final Logger log = LoggerFactory.getLogger(SearchSynonymWordsController.class);
    @Autowired
    private SearchSynonymWordsService searchSynonymWordsService;
    @Autowired
    private SearchSynonymWordsMapper searchSynonymWordsMapper;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/querySearchSynonymWords"}, method={RequestMethod.POST})
    public Object querySearchSynonymWords(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        SearchSynonymWordsRsp rsp = this.searchSynonymWordsService.querySynonymWordsList(reqBO);
        return rsp;
    }

    @RequestMapping(value={"/addSynonymWordsInfo"}, method={RequestMethod.POST})
    public Object addSynonymWordsInfo(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchSynonymWordsService.addSynonymWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
        logReqBO.setOperType("A");
        logReqBO.setOperContent("\u65b0\u589e\u540c\u4e49\u8bcd-\u4e3b\u8bcd\u4e3a:" + reqBO.getMainWord());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateSynonymWordsInfo"}, method={RequestMethod.POST})
    public Object updateSynonymWordsInfo(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchSynonymWordsService.updateSynonymWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
        logReqBO.setOperType("M");
        String content = "\u4fee\u6539\u540c\u4e49\u8bcd-\u4e3b\u8bcd\u5185\u5bb9\u4e3a:" + reqBO.getMainWord() + ",\u540c\u4e49\u8bcd[\u4fee\u6539\u524d\uff1a" + reqBO.getOldSimWords() + ",\u4fee\u6539\u540e\uff1a" + reqBO.getSimWords() + ",\u8bcd\u8bed\u7c7b\u578b[\u4fee\u6539\u524d\uff1a" + reqBO.getOldType() + ",\u4fee\u6539\u540e\uff1a" + reqBO.getType() + "]";
        logReqBO.setOperContent(content);
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/updateSynonymWordsStatus"}, method={RequestMethod.POST})
    public Object updateSynonymWordsStatus(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchSynonymWordsService.updateSynonymWordsStatus(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
        if (reqBO.getSStatus() == 1) {
            logReqBO.setOperType("O");
            logReqBO.setOperContent("\u542f\u7528\u540c\u4e49\u8bcd-\u540c\u4e49\u8bcd\u4e3b\u8bcd=" + reqBO.getMainWord());
        } else {
            logReqBO.setOperType("C");
            logReqBO.setOperContent("\u505c\u7528\u540c\u4e49\u8bcd-\u540c\u4e49\u8bcd\u4e3b\u8bcd=" + reqBO.getMainWord());
        }
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteSynonymWordsInfo"}, method={RequestMethod.POST})
    public Object deleteSynonymWordsInfo(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        this.searchSynonymWordsService.deleteSynonymWordsInfo(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
        logReqBO.setOperType("D");
        logReqBO.setOperContent("\u5220\u9664\u540c\u4e49\u8bcd-\u540c\u4e49\u8bcd\u4e3a\uff1a" + reqBO.getSimWords());
        this.operLogService.insertOperLog(logReqBO);
        return null;
    }

    @RequestMapping(value={"/exportSynonymWords"}, method={RequestMethod.POST})
    public Object exportList(@Valid SearchSynonymWordsReq reqBO, BindingResult result) {
        if (result.hasErrors()) {
            throw new ZTBusinessException(((ObjectError)result.getAllErrors().get(0)).getDefaultMessage());
        }
        ExportInfoRspBO rspBO = this.searchSynonymWordsService.exportSynonymWords(reqBO);
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
        logReqBO.setOperType("E");
        logReqBO.setOperContent("\u5bfc\u51fa\u540c\u4e49\u8bcd");
        this.operLogService.insertOperLog(logReqBO);
        return rspBO;
    }

    @RequestMapping(value={"/importSynonymWords"}, method={RequestMethod.POST})
    public void importSynonymWords(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ImportSynonymWordsRspBO rspBO = null;
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            Workbook work = XlsUtil.readXls((HttpServletRequest)request);
            if (work == null) {
                throw new ZTBusinessException("\u8bfb\u53d6excel\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u6b63\u786e!");
            }
            if ((work = this.checkTemplate(work)) == null) {
                throw new ZTBusinessException("\u8bf7\u786e\u4fdd\u4f7f\u7528\u6b63\u786e\u7684excel\u6a21\u677f!");
            }
            List cList = null;
            cList = XlsUtil.getBankListByExcel((Workbook)work);
            if (cList == null || cList.size() <= 0) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a!");
            }
            rspBO = this.searchSynonymWordsService.importSynonymWords(cList);
            res.put("code", "0");
            res.put("message", "success");
            res.put("data", (String)rspBO);
            SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
            logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
            logReqBO.setOperType("I");
            logReqBO.setOperContent("\u5bfc\u5165\u540c\u4e49\u8bcd");
            this.operLogService.insertOperLog(logReqBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("code", "9999");
            res.put("message", "\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            res.put("data", (String)rspBO);
            printWriter.write(JSON.toJSONString(res));
            printWriter.flush();
        }
    }

    public Workbook checkTemplate(Workbook workbook) {
        Row row1;
        System.out.println(workbook.getNumberOfSheets());
        if (workbook.getNumberOfSheets() < 1) {
            workbook = null;
            return workbook;
        }
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet != null && (row1 = sheet.getRow(0)) != null) {
            if (row1.getLastCellNum() != 3) {
                workbook = null;
                return workbook;
            }
            Cell cell = row1.getCell(0);
            Cell cell1 = row1.getCell(1);
            Cell cell2 = row1.getCell(2);
            if (cell == null || !cell.toString().equals("\u540c\u4e49\u8bcd\u7c7b\u578b")) {
                workbook = null;
                return workbook;
            }
            if (cell1 == null || !cell1.toString().equals("\u4e3b\u8bcd\u540d\u79f0")) {
                workbook = null;
                return workbook;
            }
            if (cell2 == null || !cell2.toString().equals("\u540c\u4e49\u8bcd\u5185\u5bb9")) {
                workbook = null;
                return workbook;
            }
        }
        return workbook;
    }
}

