/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.manage.controller;

import com.tydic.se.manage.api.CacheUpdateService;
import com.tydic.se.manage.api.OperLogService;
import com.tydic.se.manage.bo.SwapInsertOperLogReqBO;
import com.tydic.se.manage.bo.cache.SyncCacheReqBO;
import com.tydic.se.manage.config.ResponseResultBody;
import com.tydic.se.manage.constants.Constants;
import com.tydic.se.manage.enums.OperModeEnum;
import com.tydic.se.manage.util.CommTools;
import java.util.HashMap;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/search/v3/data/syncCache"})
@ResponseResultBody
public class SyncCacheController {
    private static final Logger logger = LoggerFactory.getLogger(SyncCacheController.class);
    @Autowired
    private CacheUpdateService cacheUpdateService;
    @Autowired
    private OperLogService operLogService;

    @RequestMapping(value={"/initSyncCache"})
    public Object initSyncCache(@Valid SyncCacheReqBO reqBO) {
        HashMap<String, String> rspBaseBO = new HashMap<String, String>();
        Boolean status = false;
        SwapInsertOperLogReqBO logReqBO = new SwapInsertOperLogReqBO();
        try {
            BeanUtils.copyProperties((Object)reqBO, (Object)logReqBO);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u7f13\u5b58\u63a5\u53e3\u8bb0\u5f55\u7528\u6237\u884c\u4e3a\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
        }
        if (reqBO == null || reqBO.getInitSyncType() == null) {
            status = Constants.SyncStatus.allStatus;
        } else {
            switch (reqBO.getInitSyncType()) {
                case 1: {
                    status = Constants.SyncStatus.commondWordStatus;
                    logReqBO.setOperMode(OperModeEnum.overwriteConfig.getDesc());
                    break;
                }
                case 2: {
                    status = Constants.SyncStatus.catalogStatus;
                    logReqBO.setOperMode(OperModeEnum.standardCateManage.getDesc());
                    break;
                }
                case 3: {
                    status = Constants.SyncStatus.typeFrequentStatus;
                    logReqBO.setOperMode(OperModeEnum.frequentManage.getDesc());
                    break;
                }
                case 4: {
                    status = Constants.SyncStatus.searchConfigStatus;
                    logReqBO.setOperMode(OperModeEnum.recallPolicyConfig.getDesc());
                    break;
                }
                case 5: {
                    status = Constants.SyncStatus.extThreeCatalogStatus;
                    logReqBO.setOperMode(OperModeEnum.outCateManage.getDesc());
                    break;
                }
                case 6: {
                    status = Constants.SyncStatus.synonymWordStatus;
                    logReqBO.setOperMode(OperModeEnum.synonymManage.getDesc());
                    break;
                }
                case 7: {
                    status = Constants.SyncStatus.indexStatus;
                    break;
                }
                default: {
                    rspBaseBO.put("code", "1");
                    rspBaseBO.put("message", "initSyncType\u53c2\u6570\u9519\u8bef");
                    return rspBaseBO;
                }
            }
        }
        if (status.booleanValue()) {
            rspBaseBO.put("code", "1");
            rspBaseBO.put("message", "\u5f53\u524d\u6709\u540c\u6b65\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6267\u884c\uff01");
            return rspBaseBO;
        }
        this.cacheUpdateService.initSyncCache(reqBO == null ? null : reqBO.getInitSyncType());
        rspBaseBO.put("code", "0");
        rspBaseBO.put("message", "\u540c\u6b65\u4efb\u52a1\u5df2\u7ecf\u542f\u52a8\uff01");
        try {
            if (!CommTools.strIsEmpty((String)logReqBO.getOperMode())) {
                logReqBO.setOperType("S");
                logReqBO.setOperContent("\u540c\u6b65\u7f13\u5b58");
                this.operLogService.insertOperLog(logReqBO);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u7f13\u5b58\u63a5\u53e3\u8bb0\u5f55\u7528\u6237\u884c\u4e3a\u5f02\u5e38\uff0cerr:{}", (Object)e.getMessage());
        }
        return rspBaseBO;
    }
}

