/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.alu.service.data;

import com.tydic.se.nlp.alu.intfs.QueryCorpusDataService;
import com.tydic.se.nlp.alu.req.QueryCorpusDataReqBo;
import com.tydic.se.nlp.alu.rsp.QueryCorpusDataRspBo;
import com.tydic.se.nlp.alu.service.constant.CountSqlEnum;
import com.tydic.se.nlp.alu.service.constant.QuerySqlEnum;
import com.tydic.se.nlp.alu.service.utils.TxtFileUtil;
import com.tydic.se.nlp.alu.util.SentencesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="queryModelService")
public class QueryModelServiceImpl
implements QueryCorpusDataService {
    private static final Logger log = LoggerFactory.getLogger(QueryModelServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String suffix_txt = ".txt";
    private final String suffix_dic = ".dic";
    private final String fileName = "model";
    private static final int PAGE_SIZE = 50000;
    private final String unitTxtUrl = "/basic/exclusion-unit-model.txt";
    List<String> nameList = new ArrayList<String>();
    List<String> dicList = new ArrayList<String>();

    public QueryCorpusDataRspBo saveDataToTxt(QueryCorpusDataReqBo reqBo) {
        String txtFile = reqBo.getOutPath() + "model" + ".txt";
        String dicFile = reqBo.getOutPath() + "model" + ".dic";
        QueryCorpusDataRspBo rspBo = new QueryCorpusDataRspBo();
        int counter = (Integer)this.jdbcTemplate.queryForObject(CountSqlEnum.MODEL.getSql(), Integer.class);
        int totalPage = counter % 50000 == 0 ? counter / 50000 : counter / 50000 + 1;
        log.info("\u67e5\u8be2\u8fd4\u56de\u7684\u603b\u8bb0\u5f55\u6570\u91cf\uff1a" + counter + ",\u8fd4\u56de\u7684\u603b\u5206\u9875\uff1a" + totalPage);
        for (int i = 0; i < totalPage; ++i) {
            this.dealData(i);
        }
        TxtFileUtil.writeContent(this.nameList, txtFile, true);
        TxtFileUtil.writeContent(this.dicList, dicFile, true);
        log.info("\u5904\u7406\u5b8c\u6210\uff01\uff01\uff01\uff01");
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void dealData(int startPage) {
        String querySql = QuerySqlEnum.MODEL.getSql() + startPage * 50000 + "," + 50000;
        log.info("\u5f00\u59cb\u5904\u7406\u9875\u6570" + startPage + ",\u67e5\u8be2\u8bed\u53e5\uff1a" + querySql);
        try {
            SqlRowSet rs = this.jdbcTemplate.queryForRowSet(querySql);
            while (rs.next()) {
                String dealName;
                List wordList;
                String modelName;
                String name = rs.getString(1);
                if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)(modelName = this.dealScreen(wordList = SentencesUtil.toSentenceList((String)(dealName = this.dealSpecialSymbols(name)))))) || this.isRepeat(modelName, this.dicList) || this.dealExclusion(modelName)) continue;
                this.dicList.add(modelName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String dealSpecialSymbols(String msg) {
        String line = msg.replaceAll("\\{", "").replaceAll("}", "").replaceAll("\\[", "").replaceAll("]", "").replaceAll("\u3010", "").replaceAll("\u3011", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\uff08", "").replaceAll("\uff09", "");
        return line;
    }

    private String dealScreen(List<String> wordList) {
        if (wordList.size() >= 6) {
            for (int i = 2; i <= 5; ++i) {
                if (!wordList.get(i).matches("[A-Z0-9-]{3,8}") || wordList.get(i).matches("[0-9]{3,8}")) continue;
                return wordList.get(i);
            }
        }
        return null;
    }

    private boolean isRepeat(String name, List<String> dic) {
        for (String s : dic) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean dealExclusion(String modelName) throws IOException {
        boolean flag = false;
        List<String> unitList = TxtFileUtil.readLine(this.getClass().getResource("/basic/exclusion-unit-model.txt").getPath());
        for (String s : unitList) {
            String substring;
            int index;
            if (StringUtils.isEmpty((Object)s) || !modelName.contains(s) || (index = modelName.indexOf(s)) <= 0 || !(substring = modelName.substring(index - 1, index)).matches("[0-9]")) continue;
            flag = true;
        }
        return flag;
    }
}

