/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.config;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.grpc.DataType;
import io.milvus.grpc.QueryResults;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.response.QueryResultsWrapper;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ObjectUtils;

@Configuration
public class MilvusConfig {
    private static final Logger logger = LoggerFactory.getLogger(MilvusConfig.class);
    @Value(value="${milvus.host}")
    private String host;
    @Value(value="${milvus.port}")
    private Integer port;
    @Value(value="${milvus.username}")
    private String username;
    @Value(value="${milvus.password}")
    private String password;
    @Value(value="${milvus.open:true}")
    private Boolean open;
    @Autowired
    private EsIndexMapper esIndexMapper;
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;
    @Autowired
    private CacheClient cacheClient;

    @Lazy
    @Bean
    public MilvusServiceClient milvusServiceClient() {
        if (this.open.booleanValue()) {
            ConnectParam connectParam = ConnectParam.newBuilder().withHost(this.host).withPort(this.port.intValue()).withAuthorization(this.username, this.password).build();
            MilvusServiceClient milvusServiceClient = new MilvusServiceClient(connectParam);
            String collection = this.esIndexMapper.queryIndexNameByIType(Byte.valueOf((byte)5));
            if (!StringUtils.isBlank((CharSequence)collection)) {
                Boolean hasCollection = false;
                R respHasCollection = milvusServiceClient.hasCollection(HasCollectionParam.newBuilder().withCollectionName(collection).build());
                hasCollection = (Boolean)respHasCollection.getData();
                if (!ObjectUtils.isEmpty((Object)hasCollection) && hasCollection.booleanValue()) {
                    R response = milvusServiceClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(collection).build());
                    logger.info("\u521d\u59cb\u5316\u52a0\u8f7dmilvus\u6570\u636e\u5230\u5185\u5b58\u51fa\u53c2\uff1a{}", (Object)response);
                } else {
                    Long seChannelType = (Long)this.cacheClient.get("{SEARCH}_DEFAULT_CHANNEL_TYPE");
                    EsIndexTemplate bo = this.esIndexTemplateMapper.selectBytType(Byte.valueOf((byte)5), seChannelType);
                    if (bo != null && !StringUtils.isBlank((CharSequence)bo.getIndexConfig())) {
                        this.createCollect(milvusServiceClient, bo.getIndexConfig(), collection);
                    } else {
                        logger.error("milvus\u5411\u91cf\u7d22\u5f15\u6a21\u677f\u672a\u67e5\u8be2\u5230\uff01");
                    }
                }
            }
            return milvusServiceClient;
        }
        logger.warn("milvus\u5411\u91cf\u7d22\u5f15\u5c4f\u853d\u542f\u52a8\uff01");
        return null;
    }

    private void createCollect(MilvusServiceClient milvusServiceClient, String config, String collectName) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)config);
            JSONArray jsonArray = jsonObject.getJSONArray("fields");
            String pk = jsonObject.getString("primary_key");
            String index = jsonObject.getString("index_key");
            Integer shards = jsonObject.getInteger("number_of_shards");
            Boolean autoId = jsonObject.getBoolean("auto_id");
            Integer dimension = jsonObject.getInteger("dimension");
            CreateCollectionParam.Builder createCollectionReq = CreateCollectionParam.newBuilder().withCollectionName(collectName).withDescription("Test").withEnableDynamicField(true).withShardsNum(shards.intValue());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                String name = object.getString("name");
                String type = object.getString("type");
                FieldType.Builder fieldType = FieldType.newBuilder().withName(name);
                if ("string".equals(type)) {
                    fieldType.withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(object.getInteger("maxLen") == null ? 256 : object.getInteger("maxLen")));
                } else if ("int64".equals(type)) {
                    fieldType.withDataType(DataType.Int64);
                } else if ("float_vector".equals(type)) {
                    fieldType.withDataType(DataType.FloatVector).withDimension(dimension);
                }
                if (pk.equals(name)) {
                    fieldType.withPrimaryKey(true).withAutoID(autoId.booleanValue());
                }
                createCollectionReq.addFieldType(fieldType.build());
            }
            milvusServiceClient.createCollection(createCollectionReq.build());
            IndexType INDEX_TYPE = IndexType.IVF_FLAT;
            String INDEX_PARAM = "{\"nlist\":8000}";
            milvusServiceClient.createIndex(CreateIndexParam.newBuilder().withCollectionName(collectName).withFieldName(index).withIndexType(INDEX_TYPE).withMetricType(MetricType.L2).withExtraParam(INDEX_PARAM).withSyncMode(Boolean.FALSE).build());
            milvusServiceClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(collectName).build());
        }
        catch (Exception e) {
            logger.error("Milvus\u96c6\u5408\u521b\u5efa\u5931\u8d25");
        }
    }

    public static void main(String[] args) {
        ConnectParam connectParam = ConnectParam.newBuilder().withHost("192.168.10.101").withPort(19530).withAuthorization("root", "Milvus").build();
        MilvusServiceClient milvusServiceClient = new MilvusServiceClient(connectParam);
        List<String> query_output_fields = Arrays.asList("sku_id");
        QueryParam queryParam = QueryParam.newBuilder().withCollectionName("zh_uccat_milvus_emberdding").withConsistencyLevel(ConsistencyLevelEnum.STRONG).withOutFields(query_output_fields).withExpr(" sku_id > 0 ").withOffset(Long.valueOf(0L)).build();
        R respQuery = milvusServiceClient.query(queryParam);
        QueryResultsWrapper wrapperQuery = new QueryResultsWrapper((QueryResults)respQuery.getData());
        System.out.println(wrapperQuery.getRowCount());
    }
}

