/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.dic.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.DarticipleQueryBO;
import com.tydic.se.base.ability.bo.DarticipleQueryReader;
import com.tydic.se.base.ability.bo.SeEsAnalyzerBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.nlp.api.AnalysisMateService;
import com.tydic.se.nlp.bo.AnalysisEsAnalyzeQueryBO;
import com.tydic.se.nlp.bo.AnalysisFourLevelCatalogCacheBO;
import com.tydic.se.nlp.bo.AnalysisSearchReqBO;
import com.tydic.se.nlp.bo.AnalysisTypeFrequentCacheBO;
import com.tydic.se.nlp.bo.AnalysisWordCacheBO;
import com.tydic.se.nlp.dic.util.HttpRequestUtils;
import com.tydic.se.nlp.req.RaNERMateResultBO;
import com.tydic.se.nlp.req.TokenBO;
import com.tydic.se.nlp.util.AnalysisCommTools;
import com.tydic.se.search.config.SearchProcessConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="search.nlp", name={"type"}, havingValue="dic")
public class AnalysisMateServiceImpl
implements AnalysisMateService {
    private static final Logger log = LoggerFactory.getLogger(AnalysisMateServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(AnalysisMateServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;

    public Boolean mateAnalyzerExtCatalog(List<TokenBO> wordList) {
        Boolean flag = false;
        if (wordList != null) {
            List extCatalogList = (List)this.cacheClient.get("{SEARCH}_EXT_THREE_CATALOG", List.class);
            if (extCatalogList != null && extCatalogList.size() > 0) {
                for (TokenBO tokenBO : wordList) {
                    if (!AnalysisCommTools.occurrences((Collection)extCatalogList, (String)tokenBO.getTerm()).booleanValue()) continue;
                    tokenBO.setExtCatalogList(new HashSet());
                    tokenBO.getExtCatalogList().add(tokenBO.getTerm());
                    tokenBO.setCatalogType(Integer.valueOf(0));
                }
            }
            for (TokenBO tokenBO : wordList) {
                String s = this.cacheClient.hget("{SEARCH}_FOUR_LEVEL_CALALOG", tokenBO.getTerm().toLowerCase());
                if (AnalysisCommTools.strIsEmpty((String)s)) continue;
                HashSet extCatelogSet = new HashSet();
                AnalysisFourLevelCatalogCacheBO f = (AnalysisFourLevelCatalogCacheBO)JSONObject.parseObject((String)s, AnalysisFourLevelCatalogCacheBO.class);
                if (f.getCatalogList() != null && f.getCatalogList().size() > 0) {
                    f.getCatalogList().forEach(c -> {
                        if (c.getExtList() != null && c.getExtList().size() > 0) {
                            c.getExtList().forEach(e -> extCatelogSet.add(e.getExtCName()));
                        }
                    });
                }
                if (extCatelogSet.size() <= 0) continue;
                tokenBO.setExtCatalogList(extCatelogSet);
                tokenBO.setCatalogType(Integer.valueOf(1));
                flag = true;
            }
        }
        return flag;
    }

    public void mateAnalyzerType(List<TokenBO> wordList, List<String> queryFields) {
        if (wordList != null) {
            wordList.forEach(tokenBO -> {
                String s = this.cacheClient.hget("{SEARCH}_TYPE_SKU_FREQUENT", tokenBO.getTerm().toLowerCase());
                if (!AnalysisCommTools.strIsEmpty((String)s)) {
                    tokenBO.setTypeMap(new HashMap());
                    AnalysisTypeFrequentCacheBO tf = (AnalysisTypeFrequentCacheBO)JSONObject.parseObject((String)s, AnalysisTypeFrequentCacheBO.class);
                    if (tf.getTypeFrequentList() != null && tf.getTypeFrequentList().size() > 0) {
                        tf.getTypeFrequentList().forEach(c -> {
                            if (queryFields != null && !queryFields.contains(c.getIndexField())) {
                                tokenBO.getTypeMap().put(c.getIndexField(), c.gettWeight());
                            }
                        });
                    }
                }
            });
        }
    }

    private RaNERMateResultBO mateRaNER(String pName, Boolean dataCatalogFlag, List<String> queryFields, Long seChannelType) {
        if (AnalysisCommTools.strIsEmpty((String)pName)) {
            return null;
        }
        Boolean searchUseRaNER = Objects.equals("1", ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseRaner);
        if (searchUseRaNER.booleanValue()) {
            try {
                String url;
                JSONArray data = (JSONArray)this.cacheClient.get("{SEARCH}_RANER_RESULT_" + pName, JSONArray.class);
                logger.info("raner\u83b7\u53d6\u7f13\u5b58\uff0ckey:{},\u7ed3\u679c:{}", (Object)("{SEARCH}_RANER_RESULT_" + pName), (Object)data);
                if (!(data != null && data.size() >= 1 || AnalysisCommTools.strIsEmpty((String)(url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchRanerUrl)))) {
                    JSONObject result;
                    JSONObject params = new JSONObject();
                    params.put("prompt", (Object)pName);
                    logger.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                    String thirdpartyApiTimeout = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).thirdPartyApiTimeout;
                    String str = HttpRequestUtils.doPost(url, params.toJSONString(), Integer.parseInt(thirdpartyApiTimeout));
                    logger.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)str);
                    if (!AnalysisCommTools.strIsEmpty((String)str) && "0".equals((result = JSONObject.parseObject((String)str)).getString("code")) && !"{}".equals(result.getString("data")) && result.getJSONArray("data") != null && result.getJSONArray("data").size() > 0) {
                        data = result.getJSONArray("data");
                        String cacheTime = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).cacheEsEeRanerTime;
                        this.cacheClient.set("{SEARCH}_RANER_RESULT_" + pName, (Object)data, Integer.parseInt(cacheTime));
                    }
                }
                if (data != null && data.size() > 0) {
                    RaNERMateResultBO resultBO = new RaNERMateResultBO();
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject d = data.getJSONObject(i);
                        if ("HC".equals(d.getString("type"))) {
                            ArrayList<String> catalogList = new ArrayList<String>();
                            catalogList.add(d.getString("span"));
                            if (catalogList.size() > 0) {
                                if (resultBO.getCatalogList() == null) {
                                    resultBO.setCatalogList(new HashSet());
                                }
                                resultBO.getCatalogList().addAll(catalogList);
                            }
                        }
                        if (dataCatalogFlag.booleanValue() || !"HP".equals(d.getString("type")) || queryFields != null && (queryFields.contains("brand_id") || queryFields.contains("brand_name") || queryFields.contains("brand_name.keyword"))) continue;
                        if (resultBO.getBrandNameList() == null) {
                            resultBO.setBrandNameList(new HashSet());
                        }
                        resultBO.getBrandNameList().add(d.getString("span"));
                    }
                    if (resultBO.getBrandNameList() != null) {
                        String weight = this.cacheClient.hget("{SEARCH}_TYPE_SKU", "brand_name");
                        resultBO.setBrandWeight(Float.valueOf(AnalysisCommTools.strIsEmpty((String)weight) ? 1.0f : Float.parseFloat(weight)));
                    }
                    return resultBO;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("RaNER\u63a5\u53e3\u8bc6\u522b\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage());
            }
        }
        return null;
    }

    private String getAnalyerStr(List<TokenBO> tokenBOList) {
        String analyerStr;
        StringBuffer analyerBuffer = new StringBuffer();
        if (tokenBOList != null) {
            tokenBOList.sort(Comparator.comparing(TokenBO::getStartOffSet));
            tokenBOList.forEach(tokenBO -> {
                if (tokenBO.getNotQuery() == null || !tokenBO.getNotQuery().booleanValue()) {
                    analyerBuffer.append(tokenBO.getTerm()).append(" ");
                }
            });
        }
        return (analyerStr = analyerBuffer.toString()).length() > 1 ? analyerStr.substring(0, analyerStr.length() - 1) : analyerStr;
    }

    public RaNERMateResultBO rewriteAndAnalyzerQueryKey(AnalysisSearchReqBO searchReqBO, List<TokenBO> analyzeTokenList, Long seChannelType) {
        RaNERMateResultBO resultBO = null;
        Boolean fourCatalogFlag = false;
        Boolean dataCatalogFlag = false;
        String rewrite = null;
        if (!AnalysisCommTools.strIsEmpty((String)searchReqBO.getSeAppSearchReqBO().getQueryStr())) {
            AnalysisWordCacheBO wordCacheBO;
            ArrayList<String> queryFields = new ArrayList<String>();
            this.initDarticipleQueryBO(searchReqBO, queryFields, seChannelType);
            Boolean maxAnalyerOpen = AnalysisCommTools.getIsOpen((CacheClient)this.cacheClient, (String)"searchMaxAnalyerOpen");
            String rewiteWord = this.cacheClient.hget("{SEARCH}_REWRITE_WORD", searchReqBO.getSeAppSearchReqBO().getQueryStr().toLowerCase());
            if (!AnalysisCommTools.strIsEmpty((String)rewiteWord) && (wordCacheBO = (AnalysisWordCacheBO)JSONObject.parseObject((String)rewiteWord, AnalysisWordCacheBO.class)) != null) {
                rewrite = wordCacheBO.getwReName();
                searchReqBO.setRewrite(rewrite);
                logger.info("\u641c\u7d22\u5173\u952e\u5b57\u5339\u914d\u5230\u6539\u5199\u8bb0\u5f55:{}", (Object)rewrite);
            }
            if (AnalysisCommTools.strIsEmpty(rewrite)) {
                rewrite = searchReqBO.getSeAppSearchReqBO().getQueryStr();
            }
            if (!AnalysisCommTools.isEffNumeric(rewrite) && !AnalysisCommTools.isEngilsh((String)rewrite)) {
                AnalysisEsAnalyzeQueryBO esAnalyzeQueryBO = new AnalysisEsAnalyzeQueryBO();
                esAnalyzeQueryBO.setText(rewrite);
                String esAnalyzer = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).elasticsearchAnalyzer;
                esAnalyzeQueryBO.setAnalyzer(maxAnalyerOpen != false ? esAnalyzer : "ik_smart");
                try {
                    String esAnalyze = this.elasticsearchUtil.postEsAnalyze(searchReqBO.getUccIndex(), JSONObject.toJSONString((Object)esAnalyzeQueryBO));
                    SeEsAnalyzerBO seEsAnalyzerBO = (SeEsAnalyzerBO)JSONObject.parseObject((String)esAnalyze, SeEsAnalyzerBO.class);
                    if (seEsAnalyzerBO != null && seEsAnalyzerBO.getTokens() != null) {
                        List tokens = seEsAnalyzerBO.getTokens();
                        for (SeEsAnalyzerBO.Tokens token : tokens) {
                            if (AnalysisCommTools.strIsChinese((String)token.getToken()) || "ik_smart".equals(esAnalyzeQueryBO.getAnalyzer())) {
                                analyzeTokenList.add(new TokenBO(token.getToken(), Integer.valueOf(rewrite.indexOf(token.getToken())), Integer.valueOf(rewrite.indexOf(token.getToken()) + token.getToken().length())));
                                continue;
                            }
                            if (rewrite.toLowerCase().contains(token.getToken())) continue;
                            Boolean flag = true;
                            for (TokenBO tokenBO2 : analyzeTokenList) {
                                if (!tokenBO2.getTerm().contains(token.getToken())) continue;
                                flag = false;
                                break;
                            }
                            if (!flag.booleanValue()) continue;
                            analyzeTokenList.add(new TokenBO(token.getToken(), Integer.valueOf(rewrite.indexOf(token.getToken())), Integer.valueOf(rewrite.indexOf(token.getToken()) + token.getToken().length())));
                        }
                        if (!"ik_smart".equals(esAnalyzeQueryBO.getAnalyzer())) {
                            Matcher matcher = Pattern.compile("[a-zA-Z0-9\\p{Punct}]+").matcher(rewrite);
                            while (matcher.find()) {
                                analyzeTokenList.add(new TokenBO(matcher.group(), Integer.valueOf(rewrite.lastIndexOf(matcher.group())), Integer.valueOf(rewrite.lastIndexOf(matcher.group()) + matcher.group().length())));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u5206\u8bcd\u8bf7\u6c42\u5931\u8d25\uff01info:{}", (Object)e.getMessage());
                }
                boolean flag = false;
                for (TokenBO tokenBO3 : analyzeTokenList) {
                    if (!tokenBO3.getTerm().equals(rewrite.toLowerCase())) continue;
                    flag = true;
                    break;
                }
                logger.info("\u641c\u7d22\u5173\u952e\u5b57\u5206\u8bcd\u7ed3\u679c:{}", analyzeTokenList);
                if (!flag) {
                    TokenBO tokenBO4 = new TokenBO(rewrite, Integer.valueOf(0), Integer.valueOf(rewrite.length()));
                    tokenBO4.setNotQuery(Boolean.valueOf(true));
                    analyzeTokenList.add(0, tokenBO4);
                }
            } else {
                logger.info("\u7eaf\u6570\u5b57\u6216\u6570\u5b57\u5b57\u6bcd\u6df7\u5408\uff0c\u4e0d\u8d70\u5206\u8bcd\u8bf7\u6c42\uff01");
                TokenBO tokenBO5 = new TokenBO(rewrite, Integer.valueOf(0), Integer.valueOf(rewrite.length()));
                analyzeTokenList.add(tokenBO5);
            }
            if (!(queryFields.contains("l3_category_name") || queryFields.contains("l3_category_name.keyword") || queryFields.contains("l3_category_id"))) {
                fourCatalogFlag = this.mateAnalyzerExtCatalog(analyzeTokenList);
            }
            this.mateAnalyzerType(analyzeTokenList, queryFields);
            for (TokenBO tokenBO6 : analyzeTokenList) {
                if (tokenBO6.getTypeMap() == null || tokenBO6.getTypeMap().size() <= 0 || !tokenBO6.getTypeMap().containsKey("brand_name")) continue;
                dataCatalogFlag = true;
            }
            logger.info("\u641c\u7d22\u5173\u952e\u5b57\u5206\u8bcd\u5339\u914d\u4e09\u7ea7\u7c7b\u76ee\u53ca\u6570\u636e\u7c7b\u76ee\u7ed3\u679c:{}", analyzeTokenList);
            searchReqBO.setAnalyerStr(this.getAnalyerStr(analyzeTokenList));
            resultBO = this.mateRaNER(rewrite, dataCatalogFlag, queryFields, seChannelType);
            if (!fourCatalogFlag.booleanValue() && resultBO != null && resultBO.getCatalogList() != null && resultBO.getCatalogList().size() > 0) {
                analyzeTokenList.forEach(tokenBO -> tokenBO.setExtCatalogList(null));
            }
            logger.info("raner\u63a5\u53e3\u5339\u914d\u7ed3\u679c:{}", (Object)resultBO);
        }
        return resultBO;
    }

    private DarticipleQueryBO initDarticipleQueryBO(AnalysisSearchReqBO searchReqBO, List<String> queryFields, Long seChannelType) {
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        String analyzer = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).esAnalyzer;
        darticipleQueryReader.setAnalyzer(analyzer);
        darticipleQueryReader.setFrom(Integer.valueOf(0));
        darticipleQueryReader.setSize(Integer.valueOf(10));
        if (searchReqBO.getSeAppSearchReqBO().getQueryFilterList() != null) {
            ArrayList termsList = new ArrayList();
            searchReqBO.getSeAppSearchReqBO().getQueryFilterList().forEach(filter -> {
                if (!AnalysisCommTools.strIsEmpty((String)filter.getFilterId()) && filter.getFilterValues() != null) {
                    SeTermsBO termsBO = new SeTermsBO();
                    termsBO.setName(filter.getFilterId());
                    termsBO.setValueList(filter.getFilterValues());
                    termsList.add(termsBO);
                    queryFields.add(filter.getFilterId());
                }
            });
            darticipleQueryReader.setTermsList(termsList);
        }
        if (searchReqBO.getSeAppSearchReqBO().getMustTermsList() != null) {
            List mustTermsList = searchReqBO.getSeAppSearchReqBO().getMustTermsList();
            mustTermsList.forEach(term -> {
                if (!AnalysisCommTools.strIsEmpty((String)term.getName())) {
                    queryFields.add(term.getName());
                }
            });
            darticipleQueryReader.setTermsList(mustTermsList);
        }
        if (searchReqBO.getSeAppSearchReqBO().getMustNotTermsList() != null) {
            darticipleQueryReader.setNotTermsList(searchReqBO.getSeAppSearchReqBO().getMustNotTermsList());
            searchReqBO.getSeAppSearchReqBO().getMustNotTermsList().forEach(term -> {
                if (!AnalysisCommTools.strIsEmpty((String)term.getName())) {
                    queryFields.add(term.getName());
                }
            });
        }
        if (searchReqBO.getSeAppSearchReqBO().getShouldList() != null) {
            darticipleQueryReader.setShouldList(searchReqBO.getSeAppSearchReqBO().getShouldList());
        }
        darticipleQueryBO.init(darticipleQueryReader);
        return darticipleQueryBO;
    }
}

