/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.nlp.dic.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexTemplateMapper;
import com.tydic.se.base.dao.po.EsIndexTemplate;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.nlp.api.SearchAnalysisService;
import com.tydic.se.nlp.dic.util.HttpRequestUtils;
import com.tydic.se.nlp.req.NerEntityBO;
import com.tydic.se.nlp.req.NerResultBO;
import com.tydic.se.nlp.req.QueryRewriteResultBO;
import com.tydic.se.nlp.req.RaNERMateResultBO;
import com.tydic.se.nlp.req.SearchAnalysisReqBo;
import com.tydic.se.nlp.req.VectorRspBO;
import com.tydic.se.nlp.util.AnalysisCommTools;
import com.tydic.se.search.config.SearchProcessConfig;
import io.milvus.client.MilvusServiceClient;
import io.milvus.common.clientenum.ConsistencyLevelEnum;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="search.nlp", name={"type"}, havingValue="dic")
public class SearchAnalysisServiceImpl
implements SearchAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(SearchAnalysisServiceImpl.class);
    @Value(value="${smart.vector.commodityName.to.skuName:false}")
    private Boolean vectorCommodityNameToSkuName;
    @Value(value="${es.config.maxRetries:5}")
    private int maxRetries;
    @Autowired
    private CacheClient cacheClient;
    @Lazy
    @Autowired
    private MilvusServiceClient milvusServiceClient;
    @Qualifier(value="restHighLevelClient")
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private EsIndexTemplateMapper esIndexTemplateMapper;

    public SearchAnalysisServiceImpl() {
        log.info("DIC\u67e5\u8be2NLP\u5206\u6790\u521d\u59cb\u5316\uff01");
    }

    public Map<Long, JSONObject> analysisSimilarityRecallVector(SearchAnalysisReqBo reqBO, Long seChannelType) {
        log.info("========\u5411\u91cf\u53ec\u56de\u5f00\u59cb========");
        HashMap<Long, JSONObject> skuIds = new HashMap<Long, JSONObject>();
        String queryStr = StringUtils.isEmpty((CharSequence)reqBO.getRewrite()) ? reqBO.getExecuteSearchReqBO().getQueryStr() : reqBO.getRewrite();
        String pre = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).elasticsearchPreference;
        if (StringUtils.isEmpty((CharSequence)pre)) {
            pre = "" + reqBO.getAnalyerStr().hashCode();
        }
        ArrayList<String> sentences = new ArrayList<String>();
        sentences.add(queryStr);
        List<List<Float>> vectorList = this.getVectorList(sentences, seChannelType);
        if (vectorList != null && vectorList.size() > 0) {
            try {
                JSONObject milvusConfig;
                String vectorFieldName = "";
                ArrayList<String> queryOutputFields = new ArrayList<String>();
                EsIndexTemplate esTemplate = this.esIndexTemplateMapper.selectBytType(ToOdpsCommConstant.esType.TYPE_3, seChannelType);
                EsIndexTemplate milvusTemplate = this.esIndexTemplateMapper.selectBytType(ToOdpsCommConstant.esType.TYPE_5, seChannelType);
                if (esTemplate == null && milvusTemplate == null) {
                    log.error("\u672a\u627e\u5230\u5411\u91cf\u7d22\u5f15\u914d\u7f6e");
                    return Collections.emptyMap();
                }
                JSONObject esConfig = esTemplate != null ? JSON.parseObject((String)esTemplate.getIndexConfig()) : null;
                JSONObject jSONObject = milvusConfig = milvusTemplate != null ? JSON.parseObject((String)milvusTemplate.getIndexConfig()) : null;
                if (reqBO.getEmberddingType() != null && reqBO.getEmberddingType() == 0 && esConfig != null) {
                    JSONObject mappings = esConfig.getJSONObject("mappings");
                    JSONObject properties = mappings.getJSONObject("properties");
                    for (String fieldName : properties.keySet()) {
                        JSONObject fieldConfig = properties.getJSONObject(fieldName);
                        if ("dense_vector".equals(fieldConfig.getString("type"))) {
                            vectorFieldName = fieldName;
                            continue;
                        }
                        queryOutputFields.add(fieldName);
                    }
                } else if (reqBO.getEmberddingType() != null && reqBO.getEmberddingType() == 1 && milvusConfig != null) {
                    JSONArray fields = milvusConfig.getJSONArray("fields");
                    for (int i = 0; i < fields.size(); ++i) {
                        JSONObject fieldConfig = fields.getJSONObject(i);
                        if ("float_vector".equals(fieldConfig.getString("type"))) {
                            vectorFieldName = fieldConfig.getString("name");
                            continue;
                        }
                        queryOutputFields.add(fieldConfig.getString("name"));
                    }
                }
                if (StringUtils.isEmpty((CharSequence)vectorFieldName)) {
                    throw new IllegalArgumentException("\u672a\u627e\u5230\u6709\u6548\u7684\u5411\u91cf\u5b57\u6bb5\u914d\u7f6e\uff01");
                }
                Set catelgoSet = (Set)reqBO.getPredictionMap().get("l3_category_name");
                log.info("========\u5411\u91cf\u641c\u7d22========");
                long startTime = System.currentTimeMillis();
                if (reqBO.getEmberddingType() != null && reqBO.getEmberddingType() == 0) {
                    String esQueryBody = this.getEsParam(vectorList.get(0), reqBO.getExecuteSearchReqBO().getQueryStr(), reqBO.getSize(), seChannelType);
                    String indexName = reqBO.getEsVectorIndex() + "?preference=" + pre;
                    String esResult = this.elasticsearchUtil.postEsSearch(indexName, esQueryBody, "NER", Integer.valueOf(this.maxRetries));
                    JSONObject rsp = JSONObject.parseObject((String)esResult);
                    log.info("========\u5411\u91cf\u641c\u7d22\u7ed3\u675f\uff0c\u8017\u65f6:{}========", (Object)(System.currentTimeMillis() - startTime));
                    if (rsp != null && rsp.getJSONObject("hits") != null && rsp.getJSONObject("hits").getJSONArray("hits") != null && rsp.getJSONObject("hits").getJSONArray("hits").size() > 0) {
                        log.info("\u5411\u91cf\u68c0\u7d22\u6700\u4f4e\u5206\u8fc7\u6ee4\u524d\u8fd4\u56de\u5355\u54c1id\u4e2a\u6570\uff1a{}", (Object)rsp.getJSONObject("hits").getJSONArray("hits").size());
                        for (Object hitObject : rsp.getJSONObject("hits").getJSONArray("hits")) {
                            JSONObject hit = (JSONObject)hitObject;
                            Double score = hit.getDouble("_score");
                            String catelog = hit.getJSONObject("_source").getString("l3_category_name");
                            if (!StringUtils.isEmpty((CharSequence)catelog)) {
                                String[] split;
                                if (catelog.startsWith("[") && catelog.endsWith("]")) {
                                    catelog = catelog.substring(1, catelog.length() - 1);
                                }
                                for (String s : split = catelog.split(",")) {
                                    if (!catelgoSet.contains(s)) continue;
                                    score = score + (double)0.005f;
                                    break;
                                }
                            }
                            JSONObject o = new JSONObject();
                            o.put("sku_id", (Object)hit.getJSONObject("_source").getLong("sku_id"));
                            o.put("commodity_id", (Object)hit.getJSONObject("_source").getLong("commodity_id"));
                            o.put("score", (Object)score);
                            skuIds.put(o.getLong("sku_id"), o);
                        }
                    }
                } else {
                    ArrayList<List<Float>> search_vectors = new ArrayList<List<Float>>();
                    search_vectors.add(vectorList.get(0));
                    ArrayList<String> query_output_fields = queryOutputFields;
                    if (Boolean.TRUE.equals(this.vectorCommodityNameToSkuName)) {
                        ArrayList<String> new_query_output_fields = new ArrayList<String>(query_output_fields);
                        new_query_output_fields.add("commodity_name");
                        query_output_fields = new_query_output_fields;
                    }
                    SearchParam searchParam = SearchParam.newBuilder().withCollectionName(reqBO.getMilvusVectorCollection()).withConsistencyLevel(ConsistencyLevelEnum.STRONG).withMetricType(MetricType.L2).withOutFields(query_output_fields).withTopK(reqBO.getSize()).withVectors(search_vectors).withVectorFieldName(vectorFieldName).withParams("{\"nprobe\":" + reqBO.getSize() + "}").build();
                    R searchResultsR = this.milvusServiceClient.search(searchParam);
                    log.info("========\u5411\u91cf\u641c\u7d22\u7ed3\u675f\uff0c\u8017\u65f6:{}========", (Object)(System.currentTimeMillis() - startTime));
                    if (searchResultsR != null && searchResultsR.getData() != null) {
                        SearchResultsWrapper wrapper = new SearchResultsWrapper(((SearchResults)searchResultsR.getData()).getResults());
                        List scoresList = ((SearchResults)searchResultsR.getData()).getResults().getScoresList();
                        Float maxValue = (Float)scoresList.get(scoresList.size() - 1);
                        Float minValue = (Float)scoresList.get(0);
                        for (QueryResultsWrapper.RowRecord rowRecord : wrapper.getRowRecords()) {
                            double oldScore;
                            String[] split;
                            Double score = AnalysisCommTools.sigmoid((double)Double.parseDouble(rowRecord.get("distance").toString()), (float)maxValue.floatValue(), (float)minValue.floatValue());
                            String catelog = rowRecord.get("l3_category_name").toString();
                            for (String s : split = catelog.split(",")) {
                                if (!catelgoSet.contains(s)) continue;
                                score = score + (double)0.05f;
                                break;
                            }
                            if (skuIds.containsKey(Long.parseLong(rowRecord.get("sku_id").toString())) && (oldScore = ((JSONObject)skuIds.get(Long.parseLong(rowRecord.get("sku_id").toString()))).getDouble("score").doubleValue()) <= score) continue;
                            JSONObject o = new JSONObject();
                            o.put("sku_id", (Object)Long.parseLong(rowRecord.get("sku_id").toString()));
                            o.put("commodity_id", (Object)Long.parseLong(rowRecord.get("commodity_id").toString()));
                            if (Boolean.TRUE.equals(this.vectorCommodityNameToSkuName)) {
                                o.put("commodity_name", (Object)rowRecord.get("commodity_name").toString());
                                o.put("sku_name", (Object)rowRecord.get("commodity_name").toString());
                            }
                            o.put("score", (Object)score);
                            skuIds.put(o.getLong("sku_id"), o);
                        }
                        log.info("\u5411\u91cf\u68c0\u7d22\u6700\u4f4e\u5206\u8fc7\u6ee4\u524d\u8fd4\u56de\u5355\u54c1id\u4e2a\u6570\uff1a{}", (Object)skuIds.size());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5411\u91cf\u53ec\u56de\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        log.info("===================\u5411\u91cf\u53ec\u56de\u7ed3\u675f\uff0c\u53ec\u56de\u6761\u6570\uff1a{}=======================", (Object)skuIds.size());
        return skuIds;
    }

    public RaNERMateResultBO mateRaNER(String pName, Boolean dataCatalogFlag, List<String> queryFields, Long seChannelType) {
        if (StringUtils.isEmpty((CharSequence)pName)) {
            return null;
        }
        Boolean searchUseRaNER = Objects.equals("1", ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseRaner);
        if (searchUseRaNER.booleanValue()) {
            try {
                String url;
                JSONArray data = (JSONArray)this.cacheClient.get("{SEARCH}_RANER_RESULT_" + pName, JSONArray.class);
                log.info("raner\u83b7\u53d6\u7f13\u5b58\uff0ckey:{},\u7ed3\u679c:{}", (Object)("{SEARCH}_RANER_RESULT_" + pName), (Object)data);
                if (!(data != null && data.size() >= 1 || StringUtils.isEmpty((CharSequence)(url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchRanerUrl)))) {
                    JSONObject result;
                    JSONObject params = new JSONObject();
                    params.put("prompt", (Object)pName);
                    log.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                    String thirdpartyApiTimeout = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).thirdPartyApiTimeout;
                    String str = HttpRequestUtils.doPost(url, params.toJSONString(), Integer.parseInt(thirdpartyApiTimeout));
                    log.info("RaNER\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)str);
                    if (!StringUtils.isEmpty((CharSequence)str) && "0".equals((result = JSONObject.parseObject((String)str)).getString("code")) && !"{}".equals(result.getString("data")) && result.getJSONArray("data") != null && result.getJSONArray("data").size() > 0) {
                        data = result.getJSONArray("data");
                        String cacheTime = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).cacheEsEeRanerTime;
                        this.cacheClient.set("{SEARCH}_RANER_RESULT_" + pName, (Object)data, Integer.parseInt(cacheTime));
                    }
                }
                if (data != null && data.size() > 0) {
                    RaNERMateResultBO resultBO = new RaNERMateResultBO();
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject d = data.getJSONObject(i);
                        if ("HC".equals(d.getString("type"))) {
                            ArrayList<String> catalogList = new ArrayList<String>();
                            catalogList.add(d.getString("span"));
                            if (catalogList.size() > 0) {
                                if (resultBO.getCatalogList() == null) {
                                    resultBO.setCatalogList(new HashSet());
                                }
                                resultBO.getCatalogList().addAll(catalogList);
                            }
                        }
                        if (dataCatalogFlag.booleanValue() || !"HP".equals(d.getString("type")) || queryFields != null && (queryFields.contains("brandId") || queryFields.contains("brandName") || queryFields.contains("brandName.keyword"))) continue;
                        if (resultBO.getBrandNameList() == null) {
                            resultBO.setBrandNameList(new HashSet());
                        }
                        resultBO.getBrandNameList().add(d.getString("span"));
                    }
                    if (resultBO.getBrandNameList() != null) {
                        String weight = this.cacheClient.hget("{SEARCH}_TYPE_SKU", "brandName");
                        resultBO.setBrandWeight(Float.valueOf(StringUtils.isEmpty((CharSequence)weight) ? 1.0f : Float.parseFloat(weight)));
                    }
                    return resultBO;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("RaNER\u63a5\u53e3\u8bc6\u522b\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public List<List<Float>> getVectorList(List<String> textList, Long seChannelType) {
        ArrayList<List<Float>> vectorList = new ArrayList<List<Float>>();
        if (textList != null && textList.size() > 0) {
            JSONObject param = new JSONObject();
            param.put("sentences", textList);
            String url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchVectorUrl;
            if (StringUtils.isEmpty((CharSequence)url)) {
                log.error("=====\u641c\u7d22\u5173\u952e\u5b57\u5411\u91cf\u5316\u8bf7\u6c42\u5931\u8d25=======\uff0curl:{}", (Object)url);
                return null;
            }
            log.debug("=====\u641c\u7d22\u5173\u952e\u5b57\u5411\u91cf\u5316\u8bf7\u6c42\u5f00\u59cb=======\uff0curl:{},param:{}", (Object)url, (Object)param);
            long startTime = System.currentTimeMillis();
            String result = null;
            if (textList.size() < 2) {
                String thirdpartyApiTimeout = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).thirdPartyApiTimeout;
                result = HttpRequestUtils.doPost(url, param.toJSONString(), Integer.parseInt(thirdpartyApiTimeout));
            } else {
                result = HttpRequestUtils.doPost(url, param.toJSONString(), null);
            }
            log.info("======\u641c\u7d22\u5173\u952e\u5b57\u5411\u91cf\u5316\u8bf7\u6c42\u7ed3\u675f,\u8017\u65f6:{}=======", (Object)(System.currentTimeMillis() - startTime));
            try {
                if (!StringUtils.isEmpty((CharSequence)result)) {
                    VectorRspBO vectorRspBO = (VectorRspBO)JSONObject.parseObject((String)result, VectorRspBO.class);
                    if ("0".equals(vectorRspBO.getCode()) && vectorRspBO.getData() != null && vectorRspBO.getData().getEmbeddings() != null && vectorRspBO.getData().getEmbeddings().size() > 0) {
                        vectorList.addAll(vectorRspBO.getData().getEmbeddings());
                    } else {
                        log.warn("\u641c\u7d20\u5173\u952e\u5b57\u5411\u91cf\u8bf7\u6c42\u5931\u8d25\uff0cresult:{}", (Object)result);
                    }
                } else {
                    log.error("\u641c\u7d20\u5173\u952e\u5b57\u5411\u91cf\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff01");
                }
            }
            catch (Exception e) {
                log.error("\u641c\u7d22\u5173\u952e\u5b57\u5411\u91cf\u5316\u8bf7\u6c42\u5931\u8d25\uff0cerr:{}", (Object)e.getMessage());
            }
        }
        return vectorList;
    }

    public QueryRewriteResultBO queryRewrite(String queryStr, Boolean enableTokenization, Boolean enableSynonymExpansion, Boolean enableCorrection, Long seChannelType) {
        if (StringUtils.isEmpty((CharSequence)queryStr)) {
            return null;
        }
        QueryRewriteResultBO resultBO = new QueryRewriteResultBO();
        resultBO.setOriginalQuery(queryStr);
        try {
            List<NerEntityBO> nerEntities = this.performNER(queryStr, seChannelType);
            if (nerEntities != null && !nerEntities.isEmpty()) {
                resultBO.setNerEntities(nerEntities);
                this.processNEREntities(resultBO, nerEntities);
            }
            if (Boolean.TRUE.equals(enableTokenization)) {
                List<String> tokens = this.performTokenization(queryStr, seChannelType);
                resultBO.setTokens(tokens);
            }
            if (Boolean.TRUE.equals(enableSynonymExpansion)) {
                List<String> synonyms = this.performSynonymExpansion(queryStr, seChannelType);
                resultBO.setSynonyms(synonyms);
            }
            if (Boolean.TRUE.equals(enableCorrection)) {
                List<String> corrections = this.performCorrection(queryStr);
                resultBO.setCorrections(corrections);
            }
            String rewrittenQuery = this.generateRewrittenQuery(resultBO);
            resultBO.setRewrittenQuery(rewrittenQuery);
            resultBO.setIsRewritten(Boolean.valueOf(!queryStr.equals(rewrittenQuery)));
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6539\u5199\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
        }
        return resultBO;
    }

    public List<Float> querySkuVectorBySkuId(Long skuId) {
        try {
            String esVectorIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsVectorName");
            String milvusIndex = this.cacheClient.hget("{SEARCH}_INDEX", "indexMilvusVectorName");
            if (!StringUtils.isEmpty((CharSequence)esVectorIndex)) {
                return this.queryVectorFromEs(skuId, esVectorIndex);
            }
            if (!StringUtils.isEmpty((CharSequence)milvusIndex)) {
                return this.queryVectorFromMilvus(skuId, milvusIndex);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5546\u54c1\u5411\u91cf\u503c\u5931\u8d25\uff0cskuId: {}, error: {}", new Object[]{skuId, e.getMessage(), e});
            return Collections.emptyList();
        }
    }

    private boolean getIsOpen(CacheClient cacheClient, String key) {
        Boolean isOpen = false;
        try {
            String vaule = cacheClient.hget("{SEARCH}_CONFIG", key);
            if ("1".equals(vaule)) {
                isOpen = true;
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6392\u5e8f\u914d\u7f6e\u5f02\u5e38\uff0ckey:{}\uff0cerr:{}", (Object)key, (Object)e.getMessage());
            isOpen = false;
        }
        return isOpen;
    }

    private String getEsParam(List<Float> queryVector, String key, Integer size, Long seChannelType) {
        JSONObject knnParam = new JSONObject();
        String esVectorField = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).elasticsearchVectorField;
        knnParam.put("field", (Object)esVectorField);
        knnParam.put("query_vector", queryVector);
        knnParam.put("num_candidates", (Object)(size * 2));
        knnParam.put("k", (Object)size);
        JSONObject esParam = new JSONObject();
        esParam.put("knn", (Object)knnParam);
        ArrayList<String> s = new ArrayList<String>();
        s.add("sku_id");
        s.add("commodity_id");
        s.add("l3_category_name");
        esParam.put("_source", s);
        esParam.put("size", (Object)size);
        return JSONObject.toJSONString((Object)esParam);
    }

    private List<NerEntityBO> performNER(String queryStr, Long seChannelType) {
        Boolean searchUseNER = Objects.equals("1", ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchUseVector);
        if (Boolean.FALSE.equals(searchUseNER)) {
            return null;
        }
        try {
            String url;
            String cacheKey = "{SEARCH}_RANER_RESULT_" + queryStr;
            JSONArray cachedData = (JSONArray)this.cacheClient.get(cacheKey, JSONArray.class);
            log.info("NER\u83b7\u53d6\u7f13\u5b58\uff0ckey:{},\u7ed3\u679c:{}", (Object)cacheKey, (Object)cachedData);
            if (!(cachedData != null && cachedData.size() >= 1 || StringUtils.isEmpty((CharSequence)(url = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).searchRanerUrl)))) {
                NerResultBO nerResult;
                JSONObject params = new JSONObject();
                params.put("query", (Object)queryStr);
                log.info("NER\u63a5\u53e3\u8bf7\u6c42\u5f00\u59cb\uff1aurl:{},params:{}", (Object)url, (Object)params);
                String thirdpartyApiTimeout = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).thirdPartyApiTimeout;
                String response = HttpRequestUtils.doPost(url, params.toJSONString(), Integer.parseInt(thirdpartyApiTimeout));
                log.info("NER\u63a5\u53e3\u8bf7\u6c42\u7ed3\u675f\uff1aresult:{}", (Object)response);
                if (!StringUtils.isEmpty((CharSequence)response) && (nerResult = (NerResultBO)JSONObject.parseObject((String)response, NerResultBO.class)).getCode() == 0 && nerResult.getData() != null && !nerResult.getData().isEmpty()) {
                    cachedData = JSONArray.parseArray((String)JSON.toJSONString((Object)nerResult.getData()));
                    String cacheTime = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).cacheEsEeRanerTime;
                    this.cacheClient.set(cacheKey, (Object)cachedData, Integer.parseInt(cacheTime));
                }
            }
            if (cachedData != null && cachedData.size() > 0) {
                ArrayList<NerEntityBO> entities = new ArrayList<NerEntityBO>();
                for (int i = 0; i < cachedData.size(); ++i) {
                    JSONObject entityJson = cachedData.getJSONObject(i);
                    NerEntityBO entity = (NerEntityBO)JSONObject.parseObject((String)entityJson.toJSONString(), NerEntityBO.class);
                    entities.add(entity);
                }
                return entities;
            }
        }
        catch (Exception e) {
            log.error("NER\u63a5\u53e3\u8bc6\u522b\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private void processNEREntities(QueryRewriteResultBO resultBO, List<NerEntityBO> nerEntities) {
        HashSet<String> brandList = new HashSet<String>();
        HashSet<String> categoryList = new HashSet<String>();
        HashSet<String> modelList = new HashSet<String>();
        for (NerEntityBO entity : nerEntities) {
            switch (entity.getType()) {
                case "HP": {
                    brandList.add(entity.getSpan());
                    break;
                }
                case "HC": {
                    categoryList.add(entity.getSpan());
                    break;
                }
                case "XH": {
                    modelList.add(entity.getSpan());
                    break;
                }
            }
        }
        resultBO.setBrandList(brandList.isEmpty() ? null : brandList);
        resultBO.setCategoryList(categoryList.isEmpty() ? null : categoryList);
        resultBO.setModelList(modelList.isEmpty() ? null : modelList);
    }

    private List<String> performTokenization(String queryStr, Long seChannelType) {
        try {
            JSONObject result;
            JSONArray tokens;
            String INDEX_NAME = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
            String esAnalyzer = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)seChannelType)).esAnalyzer;
            JSONObject analyzeRequest = new JSONObject();
            analyzeRequest.put("text", (Object)queryStr);
            analyzeRequest.put("analyzer", (Object)(esAnalyzer != null ? esAnalyzer : "ik_smart"));
            String esResult = this.elasticsearchUtil.postEsAnalyze(INDEX_NAME, analyzeRequest.toJSONString());
            if (!StringUtils.isEmpty((CharSequence)esResult) && (tokens = (result = JSONObject.parseObject((String)esResult)).getJSONArray("tokens")) != null) {
                ArrayList<String> tokenList = new ArrayList<String>();
                for (int i = 0; i < tokens.size(); ++i) {
                    JSONObject token = tokens.getJSONObject(i);
                    tokenList.add(token.getString("token"));
                }
                return tokenList;
            }
        }
        catch (Exception e) {
            log.error("\u5206\u8bcd\u5904\u7406\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    private List<String> performSynonymExpansion(String queryStr, Long seChannelType) {
        try {
            ArrayList<String> synonyms = new ArrayList<String>();
            List<String> tokens = this.performTokenization(queryStr, seChannelType);
            if (tokens != null) {
                for (String token : tokens) {
                    String synonymWord = this.cacheClient.hget("{SEARCH}_SYNONYM_WORD", token);
                    if (synonymWord == null) continue;
                    String[] synonymArray = synonymWord.split(" ");
                    synonyms.addAll(Arrays.asList(synonymArray));
                }
            }
            return synonyms.isEmpty() ? null : synonyms;
        }
        catch (Exception e) {
            log.error("\u540c\u4e49\u8bcd\u6269\u5c55\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private List<String> performCorrection(String queryStr) {
        block5: {
            try {
                String rewriteQueryStr = this.cacheClient.hget("{SEARCH}_REWRITE_WORD", queryStr);
                if (!StringUtils.isNotBlank((CharSequence)rewriteQueryStr)) break block5;
                try {
                    JSONObject rewriteJson = JSON.parseObject((String)rewriteQueryStr);
                    String wReName = rewriteJson.getString("wReName");
                    if (StringUtils.isNotBlank((CharSequence)wReName)) {
                        String[] correctionArray = wReName.split("\\|");
                        return Arrays.asList(correctionArray);
                    }
                }
                catch (Exception e) {
                    log.error("\u7ea0\u9519\u8bcd\u89e3\u6790\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u67e5\u8be2\u5b57\u7b26\u4e32\uff0cerror:{}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("\u7ea0\u9519\u5904\u7406\u5931\u8d25\uff0cerror:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return null;
    }

    private String generateRewrittenQuery(QueryRewriteResultBO resultBO) {
        if (resultBO.getCorrections() != null && !resultBO.getCorrections().isEmpty()) {
            if (resultBO.getCorrections().size() == 1) {
                return (String)resultBO.getCorrections().get(0);
            }
            return String.join((CharSequence)" ", resultBO.getCorrections());
        }
        if (resultBO.getNerEntities() != null && !resultBO.getNerEntities().isEmpty()) {
            return this.generateNerBasedRewrite(resultBO);
        }
        StringBuilder rewrittenQuery = new StringBuilder();
        if (resultBO.getTokens() != null && !resultBO.getTokens().isEmpty()) {
            rewrittenQuery.append(String.join((CharSequence)" ", resultBO.getTokens()));
        } else {
            rewrittenQuery.append(resultBO.getOriginalQuery());
        }
        if (resultBO.getSynonyms() != null && !resultBO.getSynonyms().isEmpty()) {
            for (String synonym : resultBO.getSynonyms()) {
                rewrittenQuery.append(" ").append(synonym);
            }
        }
        return rewrittenQuery.toString().trim();
    }

    private String generateNerBasedRewrite(QueryRewriteResultBO resultBO) {
        String result;
        String afterText;
        String originalQuery = resultBO.getOriginalQuery();
        List nerEntities = resultBO.getNerEntities();
        nerEntities.sort((e1, e2) -> e1.getStart().compareTo(e2.getStart()));
        StringBuilder rewrittenQuery = new StringBuilder();
        int lastEnd = 0;
        for (NerEntityBO entity : nerEntities) {
            String beforeText;
            if (entity.getStart() > lastEnd && !(beforeText = originalQuery.substring(lastEnd, entity.getStart()).trim()).isEmpty()) {
                if (rewrittenQuery.length() > 0) {
                    rewrittenQuery.append(" ");
                }
                rewrittenQuery.append(beforeText);
            }
            if (rewrittenQuery.length() > 0) {
                rewrittenQuery.append(" ");
            }
            rewrittenQuery.append(entity.getSpan());
            lastEnd = entity.getEnd();
        }
        if (lastEnd < originalQuery.length() && !(afterText = originalQuery.substring(lastEnd).trim()).isEmpty()) {
            if (rewrittenQuery.length() > 0) {
                rewrittenQuery.append(" ");
            }
            rewrittenQuery.append(afterText);
        }
        if ((result = rewrittenQuery.toString().trim()).isEmpty()) {
            return originalQuery;
        }
        if (resultBO.getSynonyms() != null && !resultBO.getSynonyms().isEmpty()) {
            StringBuilder finalQuery = new StringBuilder(result);
            for (String synonym : resultBO.getSynonyms()) {
                finalQuery.append(" ").append(synonym);
            }
            return finalQuery.toString();
        }
        return result;
    }

    private List<Float> queryVectorFromEs(Long skuId, String esVectorIndex) {
        try {
            SearchRequest request = new SearchRequest(new String[]{esVectorIndex});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (Object)skuId));
            sourceBuilder.fetchSource(new String[]{"skuName_emberdding", "vector"}, null);
            sourceBuilder.size(1);
            request.source(sourceBuilder);
            SearchResponse response = this.esClient.search(request, RequestOptions.DEFAULT);
            if (response.getHits().getHits().length > 0) {
                SearchHit hit = response.getHits().getHits()[0];
                Map source = hit.getSourceAsMap();
                Object vectorObj = source.get("skuName_emberdding");
                if (vectorObj == null) {
                    vectorObj = source.get("vector");
                }
                if (vectorObj instanceof List) {
                    List vector = (List)vectorObj;
                    return vector;
                }
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            log.error("ES\u67e5\u8be2\u5546\u54c1\u5411\u91cf\u503c\u5931\u8d25\uff0cskuId: {}, error: {}", new Object[]{skuId, e.getMessage(), e});
            return Collections.emptyList();
        }
    }

    private List<Float> queryVectorFromMilvus(Long skuId, String milvusIndex) {
        try {
            QueryResultsWrapper wrapper;
            QueryParam queryParam = QueryParam.newBuilder().withCollectionName(milvusIndex).withConsistencyLevel(ConsistencyLevelEnum.STRONG).withOutFields(Arrays.asList("skuName_emberdding")).withExpr(String.format("skuId == %d", skuId)).withOffset(Long.valueOf(0L)).withLimit(Long.valueOf(1L)).build();
            R queryResult = this.milvusServiceClient.query(queryParam);
            if (queryResult.getStatus().intValue() == R.Status.Success.getCode() && queryResult.getData() != null && (wrapper = new QueryResultsWrapper((QueryResults)queryResult.getData())).getRowCount() > 0L) {
                for (QueryResultsWrapper.RowRecord record : wrapper.getRowRecords()) {
                    Object vectorObj = record.get("skuName_emberdding");
                    if (!(vectorObj instanceof List)) continue;
                    List vector = (List)vectorObj;
                    return vector;
                }
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            log.error("Milvus\u67e5\u8be2\u5546\u54c1\u5411\u91cf\u503c\u5931\u8d25\uff0cskuId: {}, error: {}", new Object[]{skuId, e.getMessage(), e});
            return Collections.emptyList();
        }
    }
}

