/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.config;

import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.SearchSortWeightCalculation;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchSortConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SearchSortConfig.class);
    private File file;
    private Map<String, Double> idf = new HashMap<String, Double>();
    private Map<String, Double> iwf = new HashMap<String, Double>();
    private int wordTotal = 0;
    private int docTotal = 0;
    @Value(value="${search.sort.trainDataPath:null}")
    private String trainDataPath;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    SearchSortWeightCalculation weightCalculation;

    private void initData() {
        this.weightCalculation.TF_IDF(this.file);
        this.idf = this.weightCalculation.getIdf();
        this.iwf = this.weightCalculation.getIwf();
        this.wordTotal = this.weightCalculation.getWordTotal();
        this.docTotal = this.weightCalculation.getDocTotal();
    }

    public void run(String ... args) throws SearchSortException {
        try {
            this.file = new File(this.trainDataPath);
            if (!"null".equals(this.trainDataPath) && this.file.exists()) {
                this.initData();
            }
        }
        catch (SearchSortException e) {
            throw new SearchSortException("9990", "\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public Map<String, Double> getIdf() {
        return this.idf;
    }

    public Map<String, Double> getIwf() {
        return this.iwf;
    }

    public int getWordTotal() {
        return this.wordTotal;
    }

    public int getDocTotal() {
        return this.docTotal;
    }

    public String getTrainDataPath() {
        return this.trainDataPath;
    }

    public SearchProcessConfig getSearchProcessConfig() {
        return this.searchProcessConfig;
    }

    public SearchSortWeightCalculation getWeightCalculation() {
        return this.weightCalculation;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setIdf(Map<String, Double> idf) {
        this.idf = idf;
    }

    public void setIwf(Map<String, Double> iwf) {
        this.iwf = iwf;
    }

    public void setWordTotal(int wordTotal) {
        this.wordTotal = wordTotal;
    }

    public void setDocTotal(int docTotal) {
        this.docTotal = docTotal;
    }

    public void setTrainDataPath(String trainDataPath) {
        this.trainDataPath = trainDataPath;
    }

    public void setSearchProcessConfig(SearchProcessConfig searchProcessConfig) {
        this.searchProcessConfig = searchProcessConfig;
    }

    public void setWeightCalculation(SearchSortWeightCalculation weightCalculation) {
        this.weightCalculation = weightCalculation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchSortConfig)) {
            return false;
        }
        SearchSortConfig other = (SearchSortConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        Map<String, Double> this$idf = this.getIdf();
        Map<String, Double> other$idf = other.getIdf();
        if (this$idf == null ? other$idf != null : !((Object)this$idf).equals(other$idf)) {
            return false;
        }
        Map<String, Double> this$iwf = this.getIwf();
        Map<String, Double> other$iwf = other.getIwf();
        if (this$iwf == null ? other$iwf != null : !((Object)this$iwf).equals(other$iwf)) {
            return false;
        }
        if (this.getWordTotal() != other.getWordTotal()) {
            return false;
        }
        if (this.getDocTotal() != other.getDocTotal()) {
            return false;
        }
        String this$trainDataPath = this.getTrainDataPath();
        String other$trainDataPath = other.getTrainDataPath();
        if (this$trainDataPath == null ? other$trainDataPath != null : !this$trainDataPath.equals(other$trainDataPath)) {
            return false;
        }
        SearchProcessConfig this$searchProcessConfig = this.getSearchProcessConfig();
        SearchProcessConfig other$searchProcessConfig = other.getSearchProcessConfig();
        if (this$searchProcessConfig == null ? other$searchProcessConfig != null : !this$searchProcessConfig.equals(other$searchProcessConfig)) {
            return false;
        }
        SearchSortWeightCalculation this$weightCalculation = this.getWeightCalculation();
        SearchSortWeightCalculation other$weightCalculation = other.getWeightCalculation();
        return !(this$weightCalculation == null ? other$weightCalculation != null : !this$weightCalculation.equals(other$weightCalculation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchSortConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        Map<String, Double> $idf = this.getIdf();
        result = result * 59 + ($idf == null ? 43 : ((Object)$idf).hashCode());
        Map<String, Double> $iwf = this.getIwf();
        result = result * 59 + ($iwf == null ? 43 : ((Object)$iwf).hashCode());
        result = result * 59 + this.getWordTotal();
        result = result * 59 + this.getDocTotal();
        String $trainDataPath = this.getTrainDataPath();
        result = result * 59 + ($trainDataPath == null ? 43 : $trainDataPath.hashCode());
        SearchProcessConfig $searchProcessConfig = this.getSearchProcessConfig();
        result = result * 59 + ($searchProcessConfig == null ? 43 : $searchProcessConfig.hashCode());
        SearchSortWeightCalculation $weightCalculation = this.getWeightCalculation();
        result = result * 59 + ($weightCalculation == null ? 43 : $weightCalculation.hashCode());
        return result;
    }

    public String toString() {
        return "SearchSortConfig(file=" + this.getFile() + ", idf=" + this.getIdf() + ", iwf=" + this.getIwf() + ", wordTotal=" + this.getWordTotal() + ", docTotal=" + this.getDocTotal() + ", trainDataPath=" + this.getTrainDataPath() + ", searchProcessConfig=" + this.getSearchProcessConfig() + ", weightCalculation=" + this.getWeightCalculation() + ")";
    }
}

