/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.config;

import com.tydic.se.search.sort.SearchSortWeightCalculation;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public class SearchSortConfigBak
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SearchSortConfigBak.class);
    private File file;
    private Map<String, Double> idf = new HashMap<String, Double>();
    private Map<String, Double> iwf = new HashMap<String, Double>();
    private int wordTotal = 0;
    private int docTotal = 0;
    @Value(value="${search.sort.redisCacheTime:10}")
    private String redisCacheTime;
    @Value(value="${search.sort.redisCacheNumber:3}")
    private String redisCacheNumber;
    @Value(value="${search.sort.irrelevantRatioLowest:0.25}")
    private String irrelevantRatioLowest;
    @Value(value="${search.sort.irrelevantRatioPass:0.75}")
    private String irrelevantRatioPass;
    @Value(value="${search.sort.trainDataPath:null}")
    private String trainDataPath;
    @Value(value="${search.sort.weightWay:default}")
    private String weightWay;
    @Value(value="${search.sort.segLength:50}")
    private String segLength;
    @Value(value="${search.sort.startSortThreshold:0}")
    private String startSortThreshold;
    @Value(value="${search.sort.humanInterventionValue:0.2}")
    private Double humanInterventionValue;
    @Value(value="${search.sort.bitwiseCorrelationWeight:0.9}")
    private Double bitwiseCorrelationWeight;
    @Value(value="${search.sort.redisUse:false}")
    private Boolean redisUse;
    private Map<String, BigDecimal> esFields;
    @Value(value="${search.sort.relevanceFieldMatching:null}")
    private String relevanceFieldMatching;
    @Value(value="${search.sort.relevanceChineseFieldMatching:null}")
    private String relevanceChineseFieldMatching;
    @Value(value="${search.sort.SearchRowSize:10}")
    private int searchRowSize;
    @Value(value="${search.sort.seQuerySkuName:skuName}")
    private String seQuerySkuName;
    @Value(value="${search.sort.noPictureMode:false}")
    private Boolean noPictureMode;
    @Value(value="${search.sort.allUseWeights:true}")
    private Boolean allUseWeights;
    @Value(value="${search.sort.base.timeout:200000}")
    private long baseSortTimeout;
    @Value(value="${search.sort.recommend.timeout:5000}")
    private long recommendSortTimeout;
    @Value(value="${search.sort.by.method:SearchCommodityRelevanceSortServiceImpl.relevanceSort}")
    private String sortByMethod;
    private List<Double> smoothingParameters = new LinkedList<Double>();
    @Autowired
    SearchSortWeightCalculation weightCalculation;

    private void initData() {
        this.weightCalculation.TF_IDF(this.file);
        this.idf = this.weightCalculation.getIdf();
        this.iwf = this.weightCalculation.getIwf();
        this.wordTotal = this.weightCalculation.getWordTotal();
        this.docTotal = this.weightCalculation.getDocTotal();
    }

    public void run(String ... args) throws SearchSortException {
        try {
            for (int i = 10; i >= 3; --i) {
                this.smoothingParameters.add(Math.log(i));
            }
            log.info("\u5e73\u6ed1\u6743\u91cd\u521d\u59cb\u5316\u5b8c\u6210\uff01 list:{}", this.smoothingParameters);
            this.file = new File(this.trainDataPath);
            if ("null".equals(this.trainDataPath) || !this.file.exists()) {
                if (StringUtils.isBlank((CharSequence)this.weightWay)) {
                    log.error("\u521d\u59cb\u5316\u6392\u5e8f\u6743\u503c\u8ba1\u7b97\u9519\u8bef\uff0c\u8def\u5f84\u4e3a{}\uff0c\u6743\u503c\u8ba1\u7b97\u65b9\u5f0f\u88ab\u52a8\u5207\u6362\u4e3adefault", (Object)this.trainDataPath);
                    this.weightWay = "default";
                }
            } else {
                this.initData();
            }
        }
        catch (SearchSortException e) {
            throw new SearchSortException("9990", "\u6570\u636e\u521d\u59cb\u5316\u5931\u8d25\uff01", e);
        }
    }
}

