/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.util;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SearchSortUtils {
    private static final Logger log = LoggerFactory.getLogger(SearchSortUtils.class);
    private static final Pattern LINE_PATTERN = Pattern.compile("_(\\w)");
    private static final Pattern NUM_PATTERN = Pattern.compile(".*\\d+.*");

    public static String sessionKeyFormat(SearchSortMsgBo searchSortMsgBo) {
        return SearchSortUtils.getNowTime() + "+" + searchSortMsgBo.getSessionId() + "+" + searchSortMsgBo.getQueryStr() + "+" + searchSortMsgBo.getProvince().toString() + "+" + searchSortMsgBo.getCity().toString() + "+" + searchSortMsgBo.getCounty().toString() + "+" + searchSortMsgBo.getTown().toString();
    }

    public static String sessionKeyFormatBlurry(SearchSortMsgBo searchSortMsgBo) {
        return "*" + searchSortMsgBo.getSessionId() + "+" + searchSortMsgBo.getQueryStr() + "+" + searchSortMsgBo.getProvince().toString() + "+" + searchSortMsgBo.getCity().toString() + "+" + searchSortMsgBo.getCounty().toString() + "+" + searchSortMsgBo.getTown().toString() + "*";
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) throws SearchSortException {
        String jsonStr = JSON.toJSONString(map);
        return JSON.parseObject((String)jsonStr, beanClass);
    }

    public static Map<String, Object> objectToMap(Object obj) {
        String jsonStr = JSON.toJSONString((Object)obj);
        return JSON.parseObject((String)jsonStr);
    }

    public static void printSupplier(SeSearchRspBO rspBo) {
        LinkedList<String> list = new LinkedList<String>();
        int i = 60;
        if (!CollectionUtils.isEmpty((Collection)rspBo.getSkuList())) {
            for (SeQuerySkuBO seQuerySkuBO : rspBo.getSkuList()) {
                list.add(seQuerySkuBO.getSkuName());
                if (i-- >= 0) continue;
                break;
            }
        }
        log.error("{}", list);
    }

    public static void printCommodityName(SeSearchRspBO rspBo) {
        LinkedList<String> list = new LinkedList<String>();
        int i = 20;
        if (!CollectionUtils.isEmpty((Collection)rspBo.getSkuList())) {
            for (SeQuerySkuBO seQuerySkuBo : rspBo.getSkuList()) {
                list.add("\r\n" + seQuerySkuBo.getSkuName() + "\r\n\t\t\u6743\u91cd\uff1a" + seQuerySkuBo.getWeight() + "\t\u6743\u91cd\u8f68\u8ff9\uff1a" + seQuerySkuBo.getWeightDesc() + "\r\n\t\t\u540c\u4e49\u8bcd\u6743\u91cd\uff1a" + seQuerySkuBo.getSynonymWeight() + "\t\u540c\u4e49\u8bcd\u6743\u91cd\u8f68\u8ff9\uff1a" + seQuerySkuBo.getSynonymWeightDesc() + "\r\n\t\t\u6743\u91cd\u5e73\u6ed1\u5904\u7406\uff1a" + seQuerySkuBo.getSmoothingWeightDesc());
                if (i-- >= 0) continue;
                break;
            }
        }
        log.error("{}", list);
    }

    public static void printCustomize(List<Object> listData, String field, SearchSortMsgBo searchSortMsgBo) {
        LinkedList list = new LinkedList();
        int end = Math.min(searchSortMsgBo.getPageNo() * searchSortMsgBo.getPageSize(), listData.size() - 1);
        for (int start = (searchSortMsgBo.getPageNo() - 1) * searchSortMsgBo.getPageSize(); start <= end; ++start) {
            Object obj = listData.get(start);
            Map<String, Object> map = SearchSortUtils.objectToMap(obj);
            TreeMap<String, Object> single = new TreeMap<String, Object>();
            single.put(map.get("weight") + ":" + map.get("synonymWeight"), map.get(field));
            list.add(single);
        }
        log.error("\u6392\u5e8f\u6307\u5b9a\uff1a{}\uff0c\u5206\u9875\u4fe1\u606f\uff1apageNo {}\uff0cpageSize {}\uff0c\u6392\u5e8f\u7ed3\u679c\uff1a{}", new Object[]{field, searchSortMsgBo.getPageNo(), searchSortMsgBo.getPageSize(), list});
    }

    public static String getNowTime() {
        LocalDateTime nowDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        return nowDateTime.format(dateTimeFormatter);
    }

    public static String timeCalculation(String desc, String time1, String time2) {
        SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        long between = 0L;
        try {
            Date begin = dfs.parse(time1);
            Date end = dfs.parse(time2);
            between = end.getTime() - begin.getTime();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long day = between / 86400000L;
        long hour = between / 3600000L - day * 24L;
        long min = between / 60000L - day * 24L * 60L - hour * 60L;
        long s = between / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        long ms = between - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
        return String.format("%s \u6d88\u8017\u65f6\u95f4\uff1a%s", desc, day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206" + s + "\u79d2" + ms + "\u6beb\u79d2");
    }

    public static String getNowTimeRedis() {
        LocalDateTime nowDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        return nowDateTime.format(dateTimeFormatter);
    }

    public static String parseProperties(Object o, Class clazz) {
        try {
            String propertiesGroup;
            Field queryFilterListField = clazz.getDeclaredField("queryFilterList");
            queryFilterListField.setAccessible(true);
            Field queryPropertyListField = clazz.getDeclaredField("queryPropertyList");
            queryPropertyListField.setAccessible(true);
            List<SeQueryFilterBO> queryFilterList = SearchSortUtils.castList(queryFilterListField.get(o), SeQueryFilterBO.class);
            List<SeQueryPropertyBO> queryPropertyList = SearchSortUtils.castList(queryPropertyListField.get(o), SeQueryPropertyBO.class);
            StringBuilder properties = new StringBuilder();
            if (queryPropertyList != null) {
                for (SeQueryPropertyBO queryProperty : queryPropertyList) {
                    propertiesGroup = queryProperty.getPropertyId();
                    List propertyValueList = queryProperty.getPropertyValues();
                    if (propertyValueList == null || propertyValueList.size() <= 0) continue;
                    for (String propertyValue : propertyValueList) {
                        properties.append(propertiesGroup);
                        properties.append("*~~");
                        properties.append(propertyValue);
                        properties.append("\n");
                    }
                }
            }
            if (queryFilterList != null) {
                for (SeQueryFilterBO queryFilter : queryFilterList) {
                    List filterValueList;
                    if (queryFilter.getFilterId().contains("*~~")) {
                        propertiesGroup = queryFilter.getFilterId();
                        List filterValueList2 = queryFilter.getFilterValues();
                        if (filterValueList2 == null || filterValueList2.size() <= 0) continue;
                        for (String propertyValue : filterValueList2) {
                            properties.append(propertiesGroup);
                            properties.append("*~~");
                            properties.append(propertyValue);
                            properties.append("\n");
                        }
                        continue;
                    }
                    if (!"model".equals(queryFilter.getFilterId()) || (filterValueList = queryFilter.getFilterValues()) == null || filterValueList.size() <= 0) continue;
                    String propertiesGroup2 = queryFilter.getFilterId();
                    for (String propertyValue : filterValueList) {
                        properties.append(propertiesGroup2);
                        properties.append("*~~");
                        properties.append(propertyValue);
                        properties.append("\n");
                    }
                }
            }
            return properties.toString();
        }
        catch (NoSuchFieldException e) {
            throw new SearchSortException("9999", "\u5546\u54c1\u5c5e\u6027\u62fc\u63a5\uff01", e);
        }
        catch (IllegalAccessException e) {
            throw new SearchSortException("9999", "\u5546\u54c1\u5c5e\u6027\u62fc\u63a5,\u6570\u7ec4\u8f6c\u6362\u9519\u8bef\uff01", e);
        }
    }

    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        if (obj instanceof List) {
            for (Object o : (List)obj) {
                result.add(clazz.cast(o));
            }
            return result;
        }
        return null;
    }

    public static SeEsResultBO propertyFilter(SeEsResultBO esResultBO, String properties) {
        if (StringUtils.isNotBlank((CharSequence)properties)) {
            String[] proArr = properties.split("\n");
            ArrayList hitList = new ArrayList();
            esResultBO.getHits().setHits(hitList);
            return esResultBO;
        }
        return esResultBO;
    }

    public static String lineToHump(String str) {
        if (!str.contains("_")) {
            return str;
        }
        if (str.startsWith("$")) {
            return str;
        }
        str = str.toLowerCase();
        StringBuffer sb = new StringBuffer();
        Matcher lineMatcher = LINE_PATTERN.matcher(str);
        while (lineMatcher.find()) {
            lineMatcher.appendReplacement(sb, lineMatcher.group(1).toUpperCase());
        }
        lineMatcher.appendTail(sb);
        if (!SearchSortUtils.hasDigit(str)) {
            return sb.toString();
        }
        str = sb.toString();
        sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            sb.append(str.charAt(i));
            if (!SearchSortUtils.hasDigit(String.valueOf(str.charAt(i)))) continue;
            sb.append(String.valueOf(str.charAt(++i)).toUpperCase());
        }
        return sb.toString();
    }

    private static boolean hasDigit(String content) {
        boolean flag = false;
        Matcher m = NUM_PATTERN.matcher(content);
        if (m.matches()) {
            flag = true;
        }
        return flag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchSortUtils)) {
            return false;
        }
        SearchSortUtils other = (SearchSortUtils)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchSortUtils;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "SearchSortUtils()";
    }
}

