/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.ability.CommodityDealService;
import com.tydic.se.search.ability.SeQueryService;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommodityDealServiceImpl
implements CommodityDealService {
    private static final Logger log = LoggerFactory.getLogger(CommodityDealServiceImpl.class);
    @Autowired
    private SeQueryService seQueryService;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    public List<SeQuerySkuBO> replaceStandardProducts(List<SeQuerySkuBO> skuList, ExecuteSearchReqBO executeSearchReqBO) {
        if (CollectionUtils.isEmpty(skuList)) {
            return skuList;
        }
        String commodityStandardBanedField = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).commodityStandardBanedField;
        String commodityStandardBanedValues = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).commodityStandardBanedValues;
        JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)executeSearchReqBO);
        this.processBanedFields(jsonObject, commodityStandardBanedField);
        this.processBanedValues(jsonObject, commodityStandardBanedValues);
        executeSearchReqBO = (ExecuteSearchReqBO)JSON.toJavaObject((JSON)jsonObject, ExecuteSearchReqBO.class);
        try {
            log.info("{}{}\u5f00\u59cb\u6807\u51c6\u5546\u54c1\u66ff\u6362\u5904\u7406\uff0c\u539f\u59cb\u5546\u54c1\u6570\u91cf\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", skuList.size()});
            LinkedHashMap<String, SeQuerySkuBO> uniqueOriginalSkus = new LinkedHashMap<String, SeQuerySkuBO>();
            String commodityStandardAggField = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).commodityStandardAggField;
            for (SeQuerySkuBO sku : skuList) {
                try {
                    String standardField;
                    Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(SeQuerySkuBO.class, commodityStandardAggField);
                    Object fieldValue = field.get(sku);
                    String string = standardField = fieldValue != null ? fieldValue.toString() : "";
                    if (StringUtils.isNotBlank((CharSequence)standardField) && !uniqueOriginalSkus.containsKey(standardField)) {
                        uniqueOriginalSkus.put(standardField, sku);
                        continue;
                    }
                    if (!StringUtils.isBlank((CharSequence)standardField)) continue;
                    uniqueOriginalSkus.put("no_sta_" + sku.getSkuId(), sku);
                }
                catch (Exception e) {
                    log.error("{}{}\u83b7\u53d6\u5546\u54c1{}\u5f02\u5e38\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", commodityStandardAggField, e.getMessage()});
                    uniqueOriginalSkus.put("error_" + sku.getSkuId(), sku);
                }
            }
            log.info("{}{}\u539f\u5546\u54c1\u5217\u8868\u53bb\u91cd\u540e\u6570\u91cf\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", uniqueOriginalSkus.size()});
            List<String> validStandardFields = uniqueOriginalSkus.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("no_sta_") && !((String)entry.getKey()).startsWith("error_")).map(Map.Entry::getKey).collect(Collectors.toList());
            if (validStandardFields.isEmpty()) {
                return new ArrayList<SeQuerySkuBO>(uniqueOriginalSkus.values());
            }
            Map<String, List<SeQuerySkuBO>> aggregatedProducts = this.aggregateStandardProducts(validStandardFields, executeSearchReqBO);
            ArrayList<SeQuerySkuBO> replacedSkuList = new ArrayList<SeQuerySkuBO>();
            int replaceCount = 0;
            String commodityStandardReplaceLogOpen = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).commodityStandardReplaceLogOpen;
            for (Map.Entry entry2 : uniqueOriginalSkus.entrySet()) {
                String standardField = (String)entry2.getKey();
                SeQuerySkuBO originalSku = (SeQuerySkuBO)entry2.getValue();
                if (standardField.startsWith("no_sta_") || standardField.startsWith("error_")) {
                    replacedSkuList.add(originalSku);
                    continue;
                }
                List<SeQuerySkuBO> spuProducts = aggregatedProducts.get(standardField);
                if (CollectionUtils.isEmpty(spuProducts)) {
                    replacedSkuList.add(originalSku);
                    continue;
                }
                if (Objects.equals(commodityStandardReplaceLogOpen, "1")) {
                    boolean originalExists = spuProducts.stream().anyMatch(product -> Objects.equals(product.getSkuId(), originalSku.getSkuId()));
                    if (originalExists) {
                        log.warn("{}{}\u6807\u51c6\u5546\u54c1\u5b57\u6bb5: {} \u7684\u539f\u5546\u54c1\u5728\u805a\u5408\u7ed3\u679c\u4e2d\u5b58\u5728\uff0c\u805a\u5408\u5546\u54c1\u6570\u91cf: {}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", standardField, spuProducts.size()});
                    } else {
                        log.warn("{}{}\u6807\u51c6\u5546\u54c1\u5b57\u6bb5: {} \u7684\u539f\u5546\u54c1\u5728\u805a\u5408\u7ed3\u679c\u4e2d\u4e0d\u5b58\u5728\uff0c\u805a\u5408\u5546\u54c1\u6570\u91cf: {}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", standardField, spuProducts.size()});
                    }
                }
                SeQuerySkuBO lowestPriceSku = spuProducts.get(0);
                this.setSubProducts(lowestPriceSku, spuProducts);
                replacedSkuList.add(lowestPriceSku);
                boolean isReplaced = !Objects.equals(originalSku.getSkuId(), lowestPriceSku.getSkuId());
                if (!isReplaced) continue;
                ++replaceCount;
            }
            log.info("{}{}\u6807\u51c6\u5546\u54c1\u66ff\u6362\u5904\u7406\u5b8c\u6210\uff0c\u6700\u7ec8\u5546\u54c1\u6570\u91cf\uff1a{}\uff0c\u66ff\u6362\u6570\u91cf\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", replacedSkuList.size(), replaceCount});
            return replacedSkuList;
        }
        catch (Exception e) {
            log.error("{}{}\u6807\u51c6\u5546\u54c1\u66ff\u6362\u5904\u7406\u5f02\u5e38\uff0c\u8fd4\u56de\u539f\u59cb\u5546\u54c1\u5217\u8868\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", e.getMessage()});
            return skuList;
        }
    }

    public Map<String, List<SeQuerySkuBO>> aggregateStandardProducts(List<String> spuIds, ExecuteSearchReqBO executeSearchReqBO) {
        HashMap<String, List<SeQuerySkuBO>> result = new HashMap<String, List<SeQuerySkuBO>>();
        if (CollectionUtils.isEmpty(spuIds)) {
            return result;
        }
        try {
            JSONObject groupBySpu;
            JSONArray buckets;
            ExecuteSearchRspBO aggregationResult;
            Map<Long, Map<String, String>> standardOpenChannelMap;
            Long seChannelType = executeSearchReqBO.getSeChannelType();
            if (seChannelType == null) {
                seChannelType = 1L;
            }
            if ((standardOpenChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_STANDARD_OPEN")) != null && standardOpenChannelMap.containsKey(seChannelType)) {
                standardOpenChannelMap.get(seChannelType).put("isStandardOpen", String.valueOf(1));
            }
            if ((aggregationResult = this.seQueryService.search(executeSearchReqBO)) == null || StringUtils.isBlank((CharSequence)aggregationResult.getResult())) {
                log.warn("{}{}\u805a\u5408\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", (Object)">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", (Object)">>>TXT>>>");
                return result;
            }
            JSONObject esResult = JSON.parseObject((String)aggregationResult.getResult());
            JSONObject aggregations = esResult.getJSONObject("aggregations");
            if (aggregations != null && aggregations.containsKey((Object)"group_by_spu") && (buckets = (groupBySpu = aggregations.getJSONObject("group_by_spu")).getJSONArray("buckets")) != null) {
                for (int i = 0; i < buckets.size(); ++i) {
                    JSONArray hitArray;
                    JSONObject hits;
                    JSONObject bucket = buckets.getJSONObject(i);
                    String spuId = bucket.getString("key");
                    JSONObject topHitsInGroup = bucket.getJSONObject("top_hits_in_group");
                    if (topHitsInGroup == null || (hits = topHitsInGroup.getJSONObject("hits")) == null || (hitArray = hits.getJSONArray("hits")) == null) continue;
                    ArrayList<SeQuerySkuBO> spuProducts = new ArrayList<SeQuerySkuBO>();
                    for (int j = 0; j < hitArray.size(); ++j) {
                        SeQuerySkuBO sku;
                        JSONObject hit = hitArray.getJSONObject(j);
                        JSONObject source = hit.getJSONObject("_source");
                        if (source == null || (sku = (SeQuerySkuBO)JSON.parseObject((String)source.toJSONString(), SeQuerySkuBO.class)) == null) continue;
                        spuProducts.add(sku);
                    }
                    if (spuProducts.isEmpty()) continue;
                    spuProducts.sort((s1, s2) -> {
                        if (s1.getSalePrice() == null && s2.getSalePrice() == null) {
                            return 0;
                        }
                        if (s1.getSalePrice() == null) {
                            return 1;
                        }
                        if (s2.getSalePrice() == null) {
                            return -1;
                        }
                        return s1.getSalePrice().compareTo(s2.getSalePrice());
                    });
                    result.put(spuId, spuProducts);
                }
            }
            log.info("{}{}\u6807\u51c6\u5546\u54c1\u805a\u5408\u67e5\u8be2\u5b8c\u6210\uff0c\u805a\u5408\u5230 {} \u4e2a\u4e0d\u540c\u6807\u51c6\u5546\u54c1\u7ec4", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", result.size()});
        }
        catch (Exception e) {
            log.error("{}{}\u6807\u51c6\u5546\u54c1\u805a\u5408\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", e.getMessage(), e});
        }
        return result;
    }

    private void setSubProducts(SeQuerySkuBO mainProduct, List<SeQuerySkuBO> allProducts) {
        if (mainProduct == null || CollectionUtils.isEmpty(allProducts)) {
            return;
        }
        try {
            List subProducts = allProducts.stream().filter(product -> !Objects.equals(product.getSkuId(), mainProduct.getSkuId())).collect(Collectors.toList());
            if (!subProducts.isEmpty()) {
                mainProduct.setSameSku(subProducts);
            }
        }
        catch (Exception e) {
            log.error("{}{}\u8bbe\u7f6e\u526f\u5546\u54c1\u5f02\u5e38\uff1a{}", new Object[]{">>>\u6807\u51c6\u5546\u54c1\u66ff\u6362", ">>>TXT>>>", e.getMessage()});
        }
    }

    private void processBanedFields(JSONObject jsonObject, String banedFieldStr) {
        String[] fields;
        if (banedFieldStr == null || banedFieldStr.trim().isEmpty()) {
            return;
        }
        for (String field : fields = banedFieldStr.split(",")) {
            String fieldName = field.trim();
            if (!jsonObject.containsKey((Object)fieldName)) continue;
            jsonObject.put(fieldName, null);
        }
    }

    private void processBanedValues(JSONObject jsonObject, String banedValuesStr) {
        String[] expressions;
        if (banedValuesStr == null || banedValuesStr.trim().isEmpty()) {
            return;
        }
        for (String expr : expressions = banedValuesStr.split(",")) {
            if ((expr = expr.trim()).isEmpty()) continue;
            this.processJsonPathExpression(jsonObject, expr);
        }
    }

    private void processJsonPathExpression(JSONObject jsonObject, String expression) {
        try {
            Object result = JSONPath.eval((Object)jsonObject, (String)expression);
            if (result instanceof List) {
                List list = (List)result;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map itemMap;
                    Object item = iterator.next();
                    if (!(item instanceof Map) || !this.shouldRemoveItem(itemMap = (Map)item, expression)) continue;
                    iterator.remove();
                }
            }
        }
        catch (Exception e) {
            log.error("JSONPath\u89e3\u6790\u5f02\u5e38 - JSONPath: {}, \u9519\u8bef: {}", new Object[]{expression, e.getMessage(), e});
        }
    }

    private boolean shouldRemoveItem(Map<String, Object> itemMap, String expression) {
        String[] conditions;
        int startIndex = expression.indexOf("?(");
        int endIndex = expression.lastIndexOf(")");
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            return false;
        }
        String conditionStr = expression.substring(startIndex + 2, endIndex);
        for (String condition : conditions = conditionStr.split("\\|\\|")) {
            if (!this.isConditionMet(itemMap, condition = condition.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isConditionMet(Map<String, Object> itemMap, String condition) {
        String[] parts = condition.split("==");
        if (parts.length != 2) {
            return false;
        }
        String fieldPart = parts[0].trim();
        String valuePart = parts[1].trim();
        if (!fieldPart.startsWith("@.")) {
            return false;
        }
        String fieldName = fieldPart.substring(2);
        if (!valuePart.startsWith("'") || !valuePart.endsWith("'")) {
            return false;
        }
        String expectedValue = valuePart.substring(1, valuePart.length() - 1);
        Object actualValue = this.getNestedFieldValue(itemMap, fieldName);
        return expectedValue.equals(String.valueOf(actualValue));
    }

    private Object getNestedFieldValue(Map<String, Object> map, String fieldName) {
        String[] parts = fieldName.split("\\.");
        Object current = map;
        for (String part : parts) {
            if (!(current instanceof Map)) {
                return null;
            }
            Map<String, Object> currentMap = current;
            current = currentMap.get(part);
        }
        return current;
    }
}

