/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.impl.steps;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQueryFilterValueBO;
import com.tydic.se.base.ability.bo.SeQueryPropertyBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSkuPropertiesBO;
import com.tydic.se.base.dao.EsFiledObjConfigMapper;
import com.tydic.se.base.dao.po.EsFiledObjConfigPo;
import com.tydic.se.base.util.ParseStringUtil;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.impl.steps.api.SearchCategoryParseFilterService;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.util.JsonPathUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchCategoryParseFilterServiceImpl
implements SearchCategoryParseFilterService {
    private static final Logger log = LoggerFactory.getLogger(SearchCategoryParseFilterServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchCommodityBaseService searchCommodityBaseService;
    @Autowired
    private EsFiledObjConfigMapper esFiledObjConfigMapper;

    @Override
    public List<SeQueryPropertyBO> parseQueryPropertyList(List<SeSkuPropertiesBO> skuPropertiesList) {
        LinkedHashMap<String, SeQueryPropertyBO> queryPropertyMap = new LinkedHashMap<String, SeQueryPropertyBO>();
        LinkedHashSet<String> skuPropertiesSet = new LinkedHashSet<String>();
        for (SeSkuPropertiesBO skuPropertiesBO : skuPropertiesList) {
            SeQueryPropertyBO propertyBO;
            String setKey;
            if (!"2".equals(skuPropertiesBO.getPropTag()) || skuPropertiesSet.contains(setKey = skuPropertiesBO.getCommodityPropGrpName() + skuPropertiesBO.getPropValue())) continue;
            if (queryPropertyMap.containsKey(skuPropertiesBO.getCommodityPropGrpName())) {
                propertyBO = (SeQueryPropertyBO)queryPropertyMap.get(skuPropertiesBO.getCommodityPropGrpName());
                List propertyValues = propertyBO.getPropertyValues();
                propertyValues.add(skuPropertiesBO.getPropValue());
                propertyBO.setPropertyValues(propertyValues);
                skuPropertiesSet.add(setKey);
                continue;
            }
            propertyBO = new SeQueryPropertyBO();
            String propertyId = skuPropertiesBO.getPropTag() + "*~~" + "1" + "*~~" + skuPropertiesBO.getCommodityPropGrpName();
            propertyBO.setPropertyId(propertyId);
            propertyBO.setPropertyName(skuPropertiesBO.getCommodityPropGrpName());
            ArrayList<String> propertyValues = new ArrayList<String>();
            propertyValues.add(skuPropertiesBO.getPropValue());
            propertyBO.setPropertyValues(propertyValues);
            queryPropertyMap.put(skuPropertiesBO.getCommodityPropGrpName(), propertyBO);
            skuPropertiesSet.add(setKey);
        }
        return new ArrayList<SeQueryPropertyBO>(queryPropertyMap.values());
    }

    @Override
    public List<SeSkuPropertiesBO> parseSkuPropertiesList(List<SeQuerySkuBO> skuBoList, Long seChannelType) {
        LinkedList<SeSkuPropertiesBO> skuPropertiesList = new LinkedList<SeSkuPropertiesBO>();
        for (SeQuerySkuBO seQuerySkuBO : skuBoList) {
            String[] proAttrList;
            if (!StringUtils.isNotBlank((CharSequence)"") || (proAttrList = "".split("\n")) == null) continue;
            String propertiesFilterCondition = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get(seChannelType)).getSearchFilterPropertiesCondition();
            if (StringUtils.isNotBlank((CharSequence)propertiesFilterCondition)) {
                try {
                    String[] filter = propertiesFilterCondition.split(":");
                    String fieldName = filter[0];
                    String judge = filter[1];
                    List<String> fieldValue = Arrays.asList(filter[2].split(","));
                    Map seQuerySkuBoMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)seQuerySkuBO), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    String value = (String)seQuerySkuBoMap.get(fieldName);
                    if ("in".equals(judge)) {
                        if (fieldValue.contains(value)) {
                            continue;
                        }
                    } else if ("not_in".equals(judge)) {
                        if (!fieldValue.contains(value)) {
                            continue;
                        }
                    } else {
                        log.warn("\u6307\u5b9a\u5b57\u6bb5\u8fc7\u6ee4\u5c5e\u6027\u89c4\u5219\u89e3\u6790\u5f02\u5e38\uff01{}", (Object)judge);
                    }
                }
                catch (Exception e) {
                    log.error("\u6307\u5b9a\u5b57\u6bb5\u8fc7\u6ee4\u5c5e\u6027\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
                }
            }
            for (String s : proAttrList) {
                String[] proAttr = s.split("\\*~~");
                if (proAttr.length < 5) continue;
                SeSkuPropertiesBO skuPropertiesBO = new SeSkuPropertiesBO();
                skuPropertiesBO.setCommodityPropDefId(proAttr[0]);
                skuPropertiesBO.setPropTag(proAttr[1]);
                skuPropertiesBO.setPropertyLink(proAttr[2]);
                skuPropertiesBO.setCommodityPropGrpName(proAttr[3]);
                skuPropertiesBO.setPropValue(proAttr[4]);
                if (!"1".equals(proAttr[2])) continue;
                skuPropertiesList.add(skuPropertiesBO);
            }
        }
        return skuPropertiesList;
    }

    @Override
    public List<SeQueryFilterBO> parseQueryFilterList(SeEsResultBO esResultBO, List<SeSkuPropertiesBO> skuPropertiesList, Long seChannelType) {
        Map<Long, Map<String, String>> entityCacheSearchFilterChannelMap;
        if (seChannelType == null) {
            seChannelType = 1L;
        }
        Map<String, String> entityCacheSearchFilter = (entityCacheSearchFilterChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_SEARCH_FILTER_MAPPING")) != null ? entityCacheSearchFilterChannelMap.get(seChannelType) : null;
        ArrayList<SeQueryFilterBO> seQueryFilterBO = new ArrayList<SeQueryFilterBO>();
        if (entityCacheSearchFilter != null) {
            for (Map.Entry<String, String> entry : entityCacheSearchFilter.entrySet()) {
                String groupKey = "group_" + ParseStringUtil.parseFilterId((String)entry.getKey(), (boolean)false);
                JSONObject searchFilter = JSON.parseObject((String)entry.getValue());
                SeEsResultBO.Aggregations.Category groupData = (SeEsResultBO.Aggregations.Category)JSONObject.parseObject((String)JSONObject.toJSONString((Object)esResultBO.getAggregations().get((Object)groupKey)), SeEsResultBO.Aggregations.Category.class);
                SeQueryFilterBO parseQueryFilterBO = this.parseQueryFilter(groupData, entry.getKey(), searchFilter.getString("searchFilterName"));
                seQueryFilterBO.add(parseQueryFilterBO);
            }
        }
        HashMap<String, SeQueryFilterBO> queryFilterMap = new HashMap<String, SeQueryFilterBO>();
        HashSet<String> skuPropertiesSet = new HashSet<String>();
        for (SeSkuPropertiesBO skuPropertiesBO : skuPropertiesList) {
            SeQueryFilterBO filterBO;
            String setKey;
            if ("2".equals(skuPropertiesBO.getPropTag()) || skuPropertiesSet.contains(setKey = skuPropertiesBO.getCommodityPropGrpName() + skuPropertiesBO.getPropValue())) continue;
            if (queryFilterMap.containsKey(skuPropertiesBO.getCommodityPropGrpName()) && ((SeQueryFilterBO)queryFilterMap.get(skuPropertiesBO.getCommodityPropGrpName())).getFilterId().split("\\*~~")[0].equals(skuPropertiesBO.getCommodityPropDefId())) {
                filterBO = (SeQueryFilterBO)queryFilterMap.get(skuPropertiesBO.getCommodityPropGrpName());
                List filterValues = filterBO.getFilterValues();
                filterValues.add(skuPropertiesBO.getPropValue());
                filterBO.setFilterValues(filterValues);
                List filterMaps = filterBO.getFilterMaps();
                SeQueryFilterValueBO seQueryFilterValueBO = new SeQueryFilterValueBO();
                seQueryFilterValueBO.setId(Long.valueOf(skuPropertiesBO.getCommodityPropDefId()));
                seQueryFilterValueBO.setName(skuPropertiesBO.getPropValue());
                filterMaps.add(seQueryFilterValueBO);
                filterBO.setFilterMaps(filterMaps);
                queryFilterMap.put(skuPropertiesBO.getCommodityPropGrpName(), filterBO);
                skuPropertiesSet.add(setKey);
                continue;
            }
            filterBO = new SeQueryFilterBO();
            String propertyId = skuPropertiesBO.getCommodityPropDefId() + "*~~" + skuPropertiesBO.getPropTag() + "*~~" + "1" + "*~~" + skuPropertiesBO.getCommodityPropGrpName();
            filterBO.setFilterId(propertyId);
            filterBO.setFilterName(skuPropertiesBO.getCommodityPropGrpName());
            ArrayList<String> filterValues = new ArrayList<String>();
            filterValues.add(skuPropertiesBO.getPropValue());
            filterBO.setFilterValues(filterValues);
            ArrayList<SeQueryFilterValueBO> filterMaps = new ArrayList<SeQueryFilterValueBO>();
            SeQueryFilterValueBO seQueryFilterValueBO = new SeQueryFilterValueBO();
            seQueryFilterValueBO.setId(Long.valueOf(skuPropertiesBO.getCommodityPropDefId()));
            seQueryFilterValueBO.setName(skuPropertiesBO.getPropValue());
            filterMaps.add(seQueryFilterValueBO);
            filterBO.setFilterMaps(filterMaps);
            Map<String, SeQueryFilterBO> seQueryFilterBOMap = this.getLikeByMap(queryFilterMap, skuPropertiesBO.getCommodityPropGrpName());
            if (!seQueryFilterBOMap.isEmpty()) {
                boolean flag = Boolean.TRUE;
                for (Map.Entry<String, SeQueryFilterBO> entity : seQueryFilterBOMap.entrySet()) {
                    if (!entity.getValue().getFilterId().equals(propertyId)) continue;
                    SeQueryFilterBO history = (SeQueryFilterBO)queryFilterMap.get(entity.getKey());
                    List historyFilterValues = history.getFilterValues();
                    historyFilterValues.add(skuPropertiesBO.getPropValue());
                    history.setFilterValues(filterValues);
                    queryFilterMap.put(entity.getKey(), history);
                    flag = Boolean.FALSE;
                    break;
                }
                if (Boolean.TRUE.equals(flag)) {
                    StringBuilder key = new StringBuilder(skuPropertiesBO.getCommodityPropGrpName());
                    for (int i = 0; i < seQueryFilterBOMap.size(); ++i) {
                        key.append("\\*~~");
                    }
                    queryFilterMap.put(key.toString(), filterBO);
                }
            } else {
                queryFilterMap.put(skuPropertiesBO.getCommodityPropGrpName(), filterBO);
            }
            skuPropertiesSet.add(setKey);
        }
        ArrayList tempQueryFilterBO = new ArrayList(queryFilterMap.values());
        seQueryFilterBO.addAll(tempQueryFilterBO);
        List<SeQueryFilterBO> esObjectFilterBOs = this.parseEsObjectFields(esResultBO, seChannelType);
        seQueryFilterBO.addAll(esObjectFilterBOs);
        return seQueryFilterBO;
    }

    private SeQueryFilterBO parseQueryFilter(SeEsResultBO.Aggregations.Category category, String filterId, String filterName) {
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId(ParseStringUtil.parseFilterId((String)filterId, (boolean)true));
        seQueryFilterBO.setFilterName(filterName);
        HashSet<SeQueryFilterValueBO> filterMaps = new HashSet<SeQueryFilterValueBO>();
        HashSet<String> filterValues = new HashSet<String>();
        if (category != null && !CollectionUtils.isEmpty((Collection)category.getBuckets())) {
            for (SeEsResultBO.Aggregations.Category.Buckets buckets : category.getBuckets()) {
                filterValues.add(this.extractName(buckets.getKey()));
                SeQueryFilterValueBO seQueryFilterValueBO = new SeQueryFilterValueBO();
                String key = buckets.getKey();
                if (key != null) {
                    Object[] keys = null;
                    if (key.getClass().isArray()) {
                        keys = (Object[])key;
                    } else if (key instanceof String) {
                        String keyStr = key.trim();
                        if (keyStr.startsWith("{") && keyStr.endsWith("}")) {
                            try {
                                JSONObject jsonObj = JSON.parseObject((String)keyStr);
                                Object[] idAndName = this.parseJsonKeyToIdAndName(jsonObj);
                                if (idAndName != null) {
                                    keys = idAndName;
                                }
                            }
                            catch (Exception e) {
                                keys = null;
                            }
                        } else if (keyStr.startsWith("[") && keyStr.endsWith("]")) {
                            try {
                                String content = keyStr.substring(1, keyStr.length() - 1);
                                keys = Arrays.stream(content.split(",")).map(String::trim).toArray();
                            }
                            catch (Exception e) {
                                keys = null;
                            }
                        }
                    }
                    if (keys != null && keys.length >= 2) {
                        seQueryFilterValueBO.setId(keys[0] != null ? Long.valueOf(keys[0].toString()) : null);
                        seQueryFilterValueBO.setName(keys[1] != null ? this.cleanString(keys[1].toString()) : null);
                    } else {
                        seQueryFilterValueBO.setName(key.toString());
                    }
                }
                if (seQueryFilterValueBO.getId() == null && seQueryFilterValueBO.getName() == null) continue;
                filterMaps.add(seQueryFilterValueBO);
            }
        } else if (category != null && category.getFilter() != null && category.getFilter().getData() != null && category.getFilter().getData().getBuckets() != null) {
            for (SeEsResultBO.Aggregations.Category.Buckets bucket : category.getFilter().getData().getBuckets()) {
                if (bucket != null && bucket.getKey() != null) {
                    filterValues.add(this.extractName(bucket.getKey()));
                }
                SeQueryFilterValueBO valueBO = new SeQueryFilterValueBO();
                if (bucket == null) continue;
                String key = bucket.getKey();
                if (key != null) {
                    Object[] keys = null;
                    if (key.getClass().isArray()) {
                        keys = (Object[])key;
                    } else if (key instanceof String) {
                        String keyStr = key.trim();
                        if (keyStr.startsWith("{") && keyStr.endsWith("}")) {
                            try {
                                JSONObject jsonObj = JSON.parseObject((String)keyStr);
                                Object[] idAndName = this.parseJsonKeyToIdAndName(jsonObj);
                                if (idAndName != null) {
                                    keys = idAndName;
                                }
                            }
                            catch (Exception e) {
                                keys = null;
                            }
                        } else if (keyStr.startsWith("[") && keyStr.endsWith("]")) {
                            try {
                                String content = keyStr.substring(1, keyStr.length() - 1);
                                keys = Arrays.stream(content.split(",")).map(String::trim).toArray();
                            }
                            catch (Exception e) {
                                keys = null;
                            }
                        }
                    }
                    if (keys != null && keys.length >= 2) {
                        valueBO.setId(keys[0] != null ? Long.valueOf(keys[0].toString()) : null);
                        valueBO.setName(keys[1] != null ? this.cleanString(keys[1].toString()) : null);
                    } else {
                        valueBO.setName(key.toString());
                    }
                }
                if (valueBO.getId() == null && valueBO.getName() == null) continue;
                filterMaps.add(valueBO);
            }
        }
        seQueryFilterBO.setFilterValues(new ArrayList(filterValues));
        seQueryFilterBO.setFilterMaps(new ArrayList(filterMaps));
        return seQueryFilterBO;
    }

    public Map<String, SeQueryFilterBO> getLikeByMap(Map<String, SeQueryFilterBO> map, String keyLike) {
        HashMap<String, SeQueryFilterBO> filterMap = new HashMap<String, SeQueryFilterBO>();
        for (Map.Entry<String, SeQueryFilterBO> entity : map.entrySet()) {
            String key = entity.getKey().replace("\\*~~", "");
            if (!key.equals(keyLike)) continue;
            filterMap.put(entity.getKey(), entity.getValue());
        }
        return filterMap;
    }

    @Override
    public List<SeQuerySkuBO> getSeQuerySkuBoList(ExecuteSearchRspBO executeSearchRspBO, ExecuteSearchReqBO executeSearchReqBO) {
        ArrayList<SeQuerySkuBO> skuList = new ArrayList<SeQuerySkuBO>();
        String properties = SearchSortUtils.parseProperties((Object)executeSearchReqBO, ExecuteSearchReqBO.class);
        SeEsResultBO esResultBo = executeSearchRspBO.getEsResultBO();
        esResultBo = SearchSortUtils.propertyFilter((SeEsResultBO)esResultBo, (String)properties);
        List hitsList = esResultBo.getHits().getHits();
        for (SeEsResultBO.Hits.InHits hits : hitsList) {
            skuList.add(hits.get_source());
        }
        try {
            skuList = this.searchCommodityBaseService.supplierNotSupportCategory(executeSearchReqBO, skuList);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u4f9b\u5e94\u5546\u6570\u636e\u6821\u9a8c\u5f02\u5e38\uff01", e});
        }
        return skuList;
    }

    @Override
    public Map<String, Map<String, Integer>> getQueryFilterList(ExecuteSearchRspBO executeSearchRspBO) {
        HashMap<String, Map<String, Integer>> categoryFilterMap = new HashMap<String, Map<String, Integer>>();
        for (SeQueryFilterBO queryFilterBO : executeSearchRspBO.getQueryFilterList()) {
            HashMap<String, Integer> category = new HashMap<String, Integer>();
            for (String filterValue : queryFilterBO.getFilterValues()) {
                category.put(filterValue, 0);
            }
            categoryFilterMap.put(queryFilterBO.getFilterId(), category);
        }
        return categoryFilterMap;
    }

    private List<SeQueryFilterBO> parseEsObjectFields(SeEsResultBO esResultBO, Long seChannelType) {
        ArrayList<SeQueryFilterBO> resultFilterBOs = new ArrayList<SeQueryFilterBO>();
        try {
            List configList = this.esFiledObjConfigMapper.selectByStatus(Integer.valueOf(0));
            if (CollectionUtils.isEmpty((Collection)configList)) {
                return resultFilterBOs;
            }
            for (EsFiledObjConfigPo config : configList) {
                String searchFilterId = config.getSearchFilterId();
                String searchFilterName = config.getSearchFilterName();
                String queryWhereSql = config.getQueryWhereSql();
                String objName = config.getObjName();
                if (StringUtils.isBlank((CharSequence)queryWhereSql) || StringUtils.isBlank((CharSequence)objName)) continue;
                try {
                    SeQueryFilterBO esObjectFilterBO = this.parseEsObjectField(esResultBO, config);
                    if (esObjectFilterBO == null || CollectionUtils.isEmpty((Collection)esObjectFilterBO.getFilterValues())) continue;
                    resultFilterBOs.add(esObjectFilterBO);
                    this.storeEsObjectFieldMapping(searchFilterName, esObjectFilterBO.getFilterValues(), queryWhereSql, this.extractObjectDataFromEsResult(esResultBO, objName), seChannelType);
                }
                catch (Exception e) {
                    log.error("es\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u7f13\u5b58\u5f02\u5e38 - searchFilterId: {}, objName: {}, queryWhereSql: {}", new Object[]{searchFilterId, objName, queryWhereSql, e});
                }
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790es\u5bf9\u8c61\u5b57\u6bb5\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        return resultFilterBOs;
    }

    private SeQueryFilterBO parseEsObjectField(SeEsResultBO esResultBO, EsFiledObjConfigPo config) {
        String searchFilterId = config.getSearchFilterId();
        String searchFilterName = config.getSearchFilterName();
        String queryWhereSql = config.getQueryWhereSql();
        String objName = config.getObjName();
        Object objectData = this.extractObjectDataFromEsResult(esResultBO, objName);
        if (objectData == null) {
            return null;
        }
        LinkedHashSet uniqueValues = new LinkedHashSet();
        ArrayList<SeQueryFilterValueBO> valueBOs = new ArrayList<SeQueryFilterValueBO>();
        LinkedHashSet<String> uniqueKeys = new LinkedHashSet<String>();
        try {
            if (queryWhereSql.contains(",")) {
                String[] pathExpressions = queryWhereSql.split(",");
                if (pathExpressions.length >= 2) {
                    String idPath = pathExpressions[0].trim();
                    String namePath = pathExpressions[1].trim();
                    List<String> nameResults = JsonPathUtil.extractStringData(objectData, namePath);
                    uniqueValues.addAll(nameResults.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
                    List<Object> idResults = JsonPathUtil.extractData(objectData, idPath);
                    int size = Math.min(idResults.size(), nameResults.size());
                    for (int i = 0; i < size; ++i) {
                        String uniqueKey;
                        SeQueryFilterValueBO seQueryFilterValueBO = this.parseIdNamePair(idResults.get(i), nameResults.get(i));
                        if (seQueryFilterValueBO == null || uniqueKeys.contains(uniqueKey = (seQueryFilterValueBO.getId() != null ? seQueryFilterValueBO.getId().toString() : "null") + "_" + (seQueryFilterValueBO.getName() != null ? seQueryFilterValueBO.getName() : "null"))) continue;
                        uniqueKeys.add(uniqueKey);
                        valueBOs.add(seQueryFilterValueBO);
                    }
                } else {
                    log.warn("es\u5bf9\u8c61\u5b57\u6bb5\u89e3\u6790 - queryWhereSql\u683c\u5f0f\u9519\u8bef\uff0c\u5e94\u5305\u542b\u81f3\u5c11\u4e24\u4e2a\u8def\u5f84\u8868\u8fbe\u5f0f\uff0c\u5f53\u524d: {}", (Object)queryWhereSql);
                }
            } else {
                List<String> vals = JsonPathUtil.extractStringData(objectData, queryWhereSql);
                uniqueValues.addAll(vals.stream().filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
                List<Object> values = JsonPathUtil.extractData(objectData, queryWhereSql);
                for (Object value : values) {
                    String uniqueKey;
                    if (value == null) continue;
                    SeQueryFilterValueBO valueBO = new SeQueryFilterValueBO();
                    if (value instanceof Number) {
                        long id = ((Number)value).longValue();
                        valueBO.setId(Long.valueOf(id));
                        valueBO.setName(String.valueOf(id));
                        uniqueKey = id + "_" + id;
                    } else {
                        String strValue = value.toString().trim();
                        if (StringUtils.isBlank((CharSequence)strValue)) continue;
                        valueBO.setName(strValue);
                        uniqueKey = "null_" + strValue;
                    }
                    if (uniqueKeys.contains(uniqueKey)) continue;
                    uniqueKeys.add(uniqueKey);
                    valueBOs.add(valueBO);
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        if (valueBOs.isEmpty()) {
            return null;
        }
        if (uniqueValues.isEmpty()) {
            return null;
        }
        SeQueryFilterBO filterBO = new SeQueryFilterBO();
        filterBO.setFilterId(ParseStringUtil.parseFilterId((String)searchFilterId, (boolean)true));
        filterBO.setFilterName(searchFilterName);
        filterBO.setFilterValues(new ArrayList(uniqueValues));
        filterBO.setFilterMaps(valueBOs);
        return filterBO;
    }

    private SeQueryFilterValueBO parseIdNamePair(Object idObj, String nameStr) {
        if (idObj == null && StringUtils.isBlank((CharSequence)nameStr)) {
            return null;
        }
        SeQueryFilterValueBO seQueryFilterValueBO = new SeQueryFilterValueBO();
        if (idObj != null) {
            try {
                if (idObj instanceof Number) {
                    seQueryFilterValueBO.setId(Long.valueOf(((Number)idObj).longValue()));
                } else {
                    String idStr = idObj.toString().trim();
                    if (StringUtils.isNotBlank((CharSequence)idStr)) {
                        seQueryFilterValueBO.setId(Long.valueOf(Long.parseLong(idStr)));
                    }
                }
            }
            catch (NumberFormatException e) {
                log.debug("id\u89e3\u6790\u5931\u8d25\uff0c\u975e\u6570\u5b57\u683c\u5f0f: {}", idObj);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)nameStr)) {
            seQueryFilterValueBO.setName(nameStr.trim());
        }
        if (seQueryFilterValueBO.getId() != null || seQueryFilterValueBO.getName() != null) {
            return seQueryFilterValueBO;
        }
        return null;
    }

    private Object extractObjectDataFromEsResult(SeEsResultBO esResultBO, String objName) {
        try {
            if (esResultBO == null || esResultBO.getHits() == null || CollectionUtils.isEmpty((Collection)esResultBO.getHits().getHits())) {
                return null;
            }
            ArrayList<Object> allObjectData = new ArrayList<Object>();
            for (SeEsResultBO.Hits.InHits hit : esResultBO.getHits().getHits()) {
                Object objectData;
                if (hit.get_source() == null || (objectData = this.getFieldValue(hit.get_source(), objName)) == null) continue;
                allObjectData.add(objectData);
            }
            return allObjectData.isEmpty() ? null : allObjectData;
        }
        catch (Exception e) {
            log.error("\u4ecees\u7ed3\u679c\u4e2d\u63d0\u53d6\u5bf9\u8c61\u6570\u636e\u5931\u8d25 - objName: {}", (Object)objName, (Object)e);
            return null;
        }
    }

    private Object getFieldValue(Object source, String fieldName) {
        try {
            if (source == null || StringUtils.isBlank((CharSequence)fieldName)) {
                return null;
            }
            Class<?> clazz = source.getClass();
            String getterMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
                return getterMethod.invoke(source, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field.get(source);
                }
                catch (NoSuchFieldException ex) {
                    log.debug("\u672a\u627e\u5230\u5b57\u6bb5: {}", (Object)fieldName);
                    return null;
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5f02\u5e38 - fieldName: {}", (Object)fieldName, (Object)e);
            return null;
        }
    }

    private void storeEsObjectFieldMapping(String searchFilterName, List<String> filterValues, String queryWhereSql, Object objectData, Long seChannelType) {
        try {
            if (objectData == null || CollectionUtils.isEmpty(filterValues)) {
                return;
            }
            HashMap mapData = new HashMap();
            HashMap<String, String> mappingData = new HashMap<String, String>();
            if (queryWhereSql.contains(",")) {
                String[] pathExpressions = queryWhereSql.split(",");
                if (pathExpressions.length >= 2) {
                    String idPath = pathExpressions[0].trim();
                    String namePath = pathExpressions[1].trim();
                    List<String> ids = JsonPathUtil.extractStringData(objectData, idPath);
                    List<String> names = JsonPathUtil.extractStringData(objectData, namePath);
                    int minSize = Math.min(ids.size(), names.size());
                    for (int i = 0; i < minSize; ++i) {
                        String id = ids.get(i);
                        String name = names.get(i);
                        if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                        mappingData.put(name, id);
                    }
                }
            } else {
                for (String value : filterValues) {
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    mappingData.put(value, value);
                }
            }
            if (!mappingData.isEmpty()) {
                mapData.put(seChannelType, mappingData);
                if (SeEntityCache.getEsObjectFieldMappingCache() != null) {
                    SeEntityCache.getEsObjectFieldMappingCache().put(searchFilterName, mapData);
                    log.debug("es\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u7f13\u5b58\u6210\u529f - searchFilterName: {}, \u6620\u5c04\u6570\u91cf: {}, \u6620\u5c04\u5173\u7cfb: \u663e\u793a\u540d\u79f0->id", (Object)searchFilterName, (Object)mappingData.size());
                }
            }
        }
        catch (Exception e) {
            log.error("\u5b58\u50a8es\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u7f13\u5b58\u5f02\u5e38 - searchFilterName: {}", (Object)searchFilterName, (Object)e);
        }
    }

    private String getLastFiled(String field) {
        if (field == null || field.isEmpty()) {
            return field;
        }
        int lastDotIndex = field.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return field;
        }
        return field.substring(lastDotIndex + 1);
    }

    private String cleanString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String trimmed = input.trim();
        if (trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            trimmed = trimmed.replace("\\\"", "\"");
        } else if (trimmed.startsWith("'") && trimmed.endsWith("'")) {
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            trimmed = trimmed.replace("\\'", "'");
        }
        return trimmed;
    }

    private Object[] parseJsonKeyToIdAndName(JSONObject jsonObj) {
        if (jsonObj == null || jsonObj.isEmpty()) {
            return null;
        }
        Object idValue = null;
        String nameValue = null;
        for (Map.Entry entry : jsonObj.entrySet()) {
            String strValue;
            Object value = entry.getValue();
            if (value == null) continue;
            if (this.isNumericValue(value)) {
                if (idValue == null) {
                    idValue = value;
                }
            } else if (value instanceof String && StringUtils.isNotBlank((CharSequence)(strValue = ((String)value).trim())) && nameValue == null) {
                nameValue = strValue;
            }
            if (idValue == null || nameValue == null) continue;
            break;
        }
        if (idValue != null || nameValue != null) {
            return new Object[]{idValue, nameValue};
        }
        return null;
    }

    private boolean isNumericValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        if (value instanceof String) {
            String strValue = ((String)value).trim();
            if (StringUtils.isBlank((CharSequence)strValue)) {
                return false;
            }
            try {
                Double.parseDouble(strValue);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private String extractName(Object key) {
        if (!(key instanceof String)) {
            return key != null ? key.toString() : null;
        }
        String keyStr = ((String)key).trim();
        if (!keyStr.startsWith("{") || !keyStr.endsWith("}")) {
            return keyStr;
        }
        try {
            JSONObject jsonObj = JSON.parseObject((String)keyStr);
            for (Object value : jsonObj.values()) {
                String strValue;
                if (!(value instanceof String) || (strValue = ((String)value).trim()).isEmpty()) continue;
                return strValue;
            }
        }
        catch (Exception e) {
            return null;
        }
        return keyStr;
    }
}

