/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.UccSearchGuideCatalogRelCatalogInfoBO;
import com.tydic.se.base.ability.bo.UccSearchGuideCatalogRelGroupListBO;
import com.tydic.se.base.dao.EsFiledObjConfigMapper;
import com.tydic.se.base.dao.StandSeEntityCacheMapper;
import com.tydic.se.base.dao.UccBrandMapper;
import com.tydic.se.base.dao.UccCatalogDealMapper;
import com.tydic.se.base.dao.UccCommodityTypeMapper;
import com.tydic.se.base.dao.UccEntityCacheSelectMapper;
import com.tydic.se.base.dao.UccGuideCatalogMapper;
import com.tydic.se.base.dao.UccSearchGuideCatalogRelMapper;
import com.tydic.se.base.dao.UccVendorMapper;
import com.tydic.se.base.dao.po.EsFiledObjConfigPo;
import com.tydic.se.base.dao.po.StandSeEntityCachePo;
import com.tydic.se.base.dao.po.UccBrandPO;
import com.tydic.se.base.dao.po.UccGuideCatalogPO;
import com.tydic.se.behavior.dao.SeCommDetailInLogMapper;
import com.tydic.se.behavior.po.SeCommDetailInLogPO;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.search.sort.enumType.CacheEntitySourceEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Aspect
@Configuration
public class SeEntityCache {
    private static final Logger log = LoggerFactory.getLogger(SeEntityCache.class);
    private static Map<String, Map<Long, Map<String, String>>> entityCacheMap;
    private static List<String> catalogIdList;
    private static Map<String, Object> searchWordCatalogMap;
    private static Map<String, Map<Long, Map<String, String>>> esObjectFieldMappingCache;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    UccGuideCatalogMapper uccGuideCatalogMapper;
    @Autowired
    UccBrandMapper uccBrandMapper;
    @Autowired
    UccEntityCacheSelectMapper uccEntityCacheSelectMapper;
    @Autowired
    StandSeEntityCacheMapper standSeEntityCacheMapper;
    @Autowired
    UccVendorMapper uccVendorMapper;
    @Autowired
    UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    SeCommDetailInLogMapper seCommDetailInLogMapper;
    @Autowired
    UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    UccSearchGuideCatalogRelMapper uccSearchGuideCatalogRelMapper;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverName;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsFiledObjConfigMapper esFiledObjConfigMapper;

    public com.alibaba.fastjson.JSONObject init() {
        entityCacheMap = new HashMap<String, Map<Long, Map<String, String>>>();
        catalogIdList = new ArrayList<String>();
        searchWordCatalogMap = new HashMap<String, Object>();
        esObjectFieldMappingCache = new HashMap<String, Map<Long, Map<String, String>>>();
        List uccSearchGuideCatalogRelGroupListBOS = this.uccSearchGuideCatalogRelMapper.queryRelGroupList();
        if (uccSearchGuideCatalogRelGroupListBOS.size() > 0) {
            searchWordCatalogMap = SeEntityCache.getMap(uccSearchGuideCatalogRelGroupListBOS);
            Set<String> strings = searchWordCatalogMap.keySet();
            for (String string : strings) {
                this.cacheClient.hset("{SEARCH}_GUIDE_CATALOG_CACHE", string, searchWordCatalogMap.get(string).toString());
            }
        }
        com.alibaba.fastjson.JSONObject seEntityCacheBO = new com.alibaba.fastjson.JSONObject();
        log.info("initialization Search frequency max...");
        HashMap<Long, String> map = new HashMap<Long, String>();
        ArrayList<String> skuIds = new ArrayList<String>();
        List seCommDetailInLogPOS = new ArrayList();
        try {
            seCommDetailInLogPOS = this.seCommDetailInLogMapper.selectMonthSkuIdList();
        }
        catch (Exception e) {
            log.error("\u4e0d\u5b58\u5728\u8868stand_se_comm_detail_in_log!");
        }
        if (seCommDetailInLogPOS.size() > 0) {
            if (seCommDetailInLogPOS.size() > 9) {
                for (int i = 0; i < 10; ++i) {
                    skuIds.add(((SeCommDetailInLogPO)seCommDetailInLogPOS.get(i)).getSkuId());
                }
            } else {
                for (int i = 0; i < seCommDetailInLogPOS.size(); ++i) {
                    skuIds.add(((SeCommDetailInLogPO)seCommDetailInLogPOS.get(i)).getSkuId());
                }
            }
        }
        for (String skuId : skuIds) {
            try {
                List uccGuideCatalogPOS = this.uccCatalogDealMapper.selectBySkuId(skuId);
                if (uccGuideCatalogPOS.size() <= 0) continue;
                for (UccGuideCatalogPO uccGuideCatalogPO : uccGuideCatalogPOS) {
                    if (map.containsKey(uccGuideCatalogPO.getGuideCatalogId())) continue;
                    map.put(uccGuideCatalogPO.getGuideCatalogId(), "0");
                    catalogIdList.add(String.valueOf(uccGuideCatalogPO.getGuideCatalogId()));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        log.info("initialization Search frequency max complete");
        this.initLoadEntityCache(null, seEntityCacheBO);
        return seEntityCacheBO;
    }

    private String[] parseName(String name) {
        name = name.replaceAll("\uff09", "");
        name = name.replaceAll("\uff08", "/");
        return name.split("/");
    }

    private List<UccBrandPO> selectBrandListPage(UccBrandPO selectUccBrandPO) {
        Integer pageNo = 1;
        Integer pageSize = 1000;
        ArrayList<UccBrandPO> uccBrandBOList = new ArrayList<UccBrandPO>();
        while (true) {
            List uccBrandPOResult = this.uccBrandMapper.selectBrandListPage(selectUccBrandPO, Integer.valueOf((pageNo - 1) * pageSize), pageSize);
            uccBrandBOList.addAll(uccBrandPOResult);
            if (uccBrandPOResult == null || uccBrandPOResult != null && uccBrandPOResult.size() < pageSize) break;
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        }
        return uccBrandBOList;
    }

    private List<com.alibaba.fastjson.JSONObject> selectEntityListPage(String tableName, String entityCacheValue, String entityCacheKey, String whereSql) {
        try {
            List resultList;
            int pageNo = 1;
            int pageSize = 1000;
            ArrayList<com.alibaba.fastjson.JSONObject> resultListAll = new ArrayList<com.alibaba.fastjson.JSONObject>();
            if (this.driverName.contains("dm")) {
                tableName = "DYC_UCC." + tableName;
            }
            while ((resultList = this.uccEntityCacheSelectMapper.selectEntityListPage(tableName, entityCacheValue, entityCacheKey, whereSql, Integer.valueOf(pageNo), Integer.valueOf(pageSize))) != null) {
                resultListAll.addAll(resultList);
                if (resultList.size() < pageSize) break;
                ++pageNo;
            }
            return resultListAll;
        }
        catch (Exception e) {
            log.error("initialization {} (key:{},value:{}) failure ex:{}", new Object[]{tableName, entityCacheValue, entityCacheKey, e.getMessage()});
            return new ArrayList<com.alibaba.fastjson.JSONObject>();
        }
    }

    private boolean parseIntegerCheck(String str) {
        try {
            Integer.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getEntityCacheMapPenetrate(String searchFilterId, String dataKey, Integer cycle, Long seChannelType) {
        try {
            Map<Long, Map<String, String>> channelCacheMap = entityCacheMap.get(searchFilterId);
            if (ObjectUtils.isEmpty(channelCacheMap)) {
                log.info("{}{}{}\u672a\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\uff01", new Object[]{">>>\u5185\u7f6e\u7f13\u5b58", ">>>TXT>>>", searchFilterId});
                return null;
            }
            Map<String, String> cacheMap = channelCacheMap.get(seChannelType);
            if (ObjectUtils.isEmpty(cacheMap)) {
                log.info("{}{}{}\u6e20\u9053{}\u672a\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\uff01", new Object[]{">>>\u5185\u7f6e\u7f13\u5b58", ">>>TXT>>>", searchFilterId, seChannelType});
                return null;
            }
            String value = cacheMap.get(dataKey);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                return value;
            }
            if (Objects.equals(cycle, 1)) {
                log.info("{}{}{}\u4e8c\u6b21\u52a0\u8f7d\u7f13\u5b58\u4e5f\u65e0\u6cd5\u83b7\u53d6filterId:{}\u6570\u636e\uff01", new Object[]{">>>\u5185\u7f6e\u7f13\u5b58", ">>>TXT>>>", searchFilterId, dataKey});
                return null;
            }
            Map<Long, Map<String, String>> penetrateChannelMap = entityCacheMap.get("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING");
            if (ObjectUtils.isEmpty(penetrateChannelMap)) {
                log.info("{}{}\u65e0filter\u5f00\u542f\u4e8c\u6b21\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\uff01", (Object)">>>\u5185\u7f6e\u7f13\u5b58", (Object)">>>TXT>>>");
                return null;
            }
            Map<String, String> penetrateMap = penetrateChannelMap.get(seChannelType);
            if (ObjectUtils.isEmpty(penetrateMap) || !penetrateMap.containsKey(searchFilterId)) {
                log.info("{}{}{}\u6e20\u9053{}\u672a\u5f00\u542f\u4e8c\u6b21\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\uff01", new Object[]{">>>\u5185\u7f6e\u7f13\u5b58", ">>>TXT>>>", searchFilterId, seChannelType});
                return null;
            }
            this.initLoadEntityCache(searchFilterId, new com.alibaba.fastjson.JSONObject());
            return this.getEntityCacheMapPenetrate(searchFilterId, dataKey, 1, seChannelType);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5185\u7f6e\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38\uff01", e});
            throw new SearchSortException("9999", "\u5185\u7f6e\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    public static Map<String, Object> getMap(List<UccSearchGuideCatalogRelGroupListBO> uccSearchGuideCatalogRelGroupListBOS) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (uccSearchGuideCatalogRelGroupListBOS.size() > 0) {
            for (UccSearchGuideCatalogRelGroupListBO uccSearchGuideCatalogRelGroupListBO : uccSearchGuideCatalogRelGroupListBOS) {
                HashMap<String, Integer> searchMap = new HashMap<String, Integer>();
                for (UccSearchGuideCatalogRelCatalogInfoBO uccSearchGuideCatalogRelCatalogInfoBO : uccSearchGuideCatalogRelGroupListBO.getCatalogInfoList()) {
                    if (searchMap.containsKey(uccSearchGuideCatalogRelCatalogInfoBO.getCatalogName())) continue;
                    searchMap.put(uccSearchGuideCatalogRelCatalogInfoBO.getCatalogName(), uccSearchGuideCatalogRelCatalogInfoBO.getViewOrder());
                }
                JSONObject json = new JSONObject(searchMap);
                if (map.containsKey(uccSearchGuideCatalogRelGroupListBO.getSearchWord())) continue;
                map.put(uccSearchGuideCatalogRelGroupListBO.getSearchWord(), json);
            }
        }
        return map;
    }

    public synchronized void initLoadEntityCache(String searchFilterId, com.alibaba.fastjson.JSONObject seEntityCacheBO) {
        List standSeEntityCachePoList = this.standSeEntityCacheMapper.selectAll(searchFilterId);
        if (!CollectionUtils.isEmpty((Collection)standSeEntityCachePoList)) {
            for (StandSeEntityCachePo standSeEntityCachePo : standSeEntityCachePoList) {
                log.info("initialization " + standSeEntityCachePo.getEntityCacheKey() + "(" + standSeEntityCachePo.getEntityCacheValue() + ") ......");
                try {
                    Long seChannelType = standSeEntityCachePo.getSeChannelType();
                    if (seChannelType == null) {
                        seChannelType = 2L;
                    }
                    if (!entityCacheMap.containsKey("ENTITY_CACHE_SEARCH_FIELD_MAPPING")) {
                        entityCacheMap.put("ENTITY_CACHE_SEARCH_FIELD_MAPPING", new LinkedHashMap());
                    }
                    if (!entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").containsKey(seChannelType)) {
                        entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").put(seChannelType, new LinkedHashMap());
                    }
                    entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").get(seChannelType).put(standSeEntityCachePo.getSearchFilterId(), standSeEntityCachePo.getSearchFieldName());
                    if (!entityCacheMap.containsKey("ENTITY_CACHE_MATCH_QUERY_MAPPING")) {
                        entityCacheMap.put("ENTITY_CACHE_MATCH_QUERY_MAPPING", new HashMap());
                    }
                    if (!entityCacheMap.get("ENTITY_CACHE_MATCH_QUERY_MAPPING").containsKey(seChannelType)) {
                        entityCacheMap.get("ENTITY_CACHE_MATCH_QUERY_MAPPING").put(seChannelType, new HashMap());
                    }
                    entityCacheMap.get("ENTITY_CACHE_MATCH_QUERY_MAPPING").get(seChannelType).put(standSeEntityCachePo.getSearchFilterId(), String.valueOf(standSeEntityCachePo.getMatchQuery()));
                    if (!entityCacheMap.containsKey("ENTITY_CACHE_EXACT_MATCH_MAPPING")) {
                        entityCacheMap.put("ENTITY_CACHE_EXACT_MATCH_MAPPING", new HashMap());
                    }
                    if (!entityCacheMap.get("ENTITY_CACHE_EXACT_MATCH_MAPPING").containsKey(seChannelType)) {
                        entityCacheMap.get("ENTITY_CACHE_EXACT_MATCH_MAPPING").put(seChannelType, new HashMap());
                    }
                    entityCacheMap.get("ENTITY_CACHE_EXACT_MATCH_MAPPING").get(seChannelType).put(standSeEntityCachePo.getSearchFilterId(), String.valueOf(standSeEntityCachePo.getExactMatch()));
                    if (Objects.equals(standSeEntityCachePo.getSearchFilterStatus(), 0)) {
                        if (!entityCacheMap.containsKey("ENTITY_CACHE_SEARCH_FILTER_MAPPING")) {
                            entityCacheMap.put("ENTITY_CACHE_SEARCH_FILTER_MAPPING", new LinkedHashMap());
                        }
                        if (!entityCacheMap.get("ENTITY_CACHE_SEARCH_FILTER_MAPPING").containsKey(seChannelType)) {
                            entityCacheMap.get("ENTITY_CACHE_SEARCH_FILTER_MAPPING").put(seChannelType, new HashMap());
                        }
                        JSONObject searchFilter = new JSONObject();
                        searchFilter.set("searchFilterName", (Object)standSeEntityCachePo.getSearchFilterName());
                        searchFilter.set("elasticsearhAggsFilter", (Object)standSeEntityCachePo.getElasticsearhAggsFilter());
                        entityCacheMap.get("ENTITY_CACHE_SEARCH_FILTER_MAPPING").get(seChannelType).put(standSeEntityCachePo.getSearchFilterId(), JSON.toJSONString((Object)searchFilter));
                    }
                    if (Objects.equals(standSeEntityCachePo.getPenetrate(), 0)) {
                        if (!entityCacheMap.containsKey("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING")) {
                            entityCacheMap.put("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING", new HashMap());
                        }
                        if (!entityCacheMap.get("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING").containsKey(seChannelType)) {
                            entityCacheMap.get("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING").put(seChannelType, new HashMap());
                        }
                        entityCacheMap.get("ENTITY_CACHE_SEARCH_PENETRATE_MAPPING").get(seChannelType).put(standSeEntityCachePo.getSearchFilterId(), String.valueOf(standSeEntityCachePo.getPenetrate()));
                    }
                    List<Object> resultListAll = new ArrayList();
                    if (CacheEntitySourceEnum.ELASTICSEARCH.getEntitySource().equals(standSeEntityCachePo.getEntitySource()) && standSeEntityCachePo.getEntityQueryWhereSql() != null) {
                        resultListAll = this.selectEntityListFromES(standSeEntityCachePo.getEntityQueryTableName(), standSeEntityCachePo.getEntityCacheValue(), standSeEntityCachePo.getEntityCacheKey(), standSeEntityCachePo.getEntityQueryWhereSql());
                    } else if (CacheEntitySourceEnum.DATABASE.getEntitySource().equals(standSeEntityCachePo.getEntitySource()) && StringUtils.isNotBlank((CharSequence)standSeEntityCachePo.getEntityQueryTableName())) {
                        resultListAll = this.selectEntityListPage(standSeEntityCachePo.getEntityQueryTableName(), standSeEntityCachePo.getEntityCacheValue(), standSeEntityCachePo.getEntityCacheKey(), standSeEntityCachePo.getEntityQueryWhereSql());
                    }
                    if (!resultListAll.isEmpty()) {
                        HashMap<String, String> cacheAddQueryTempMap = new HashMap<String, String>();
                        for (com.alibaba.fastjson.JSONObject jSONObject : resultListAll) {
                            String tempNameString = jSONObject.getString(standSeEntityCachePo.getEntityCacheKey());
                            String tempId = jSONObject.getString(standSeEntityCachePo.getEntityCacheValue());
                            List<String> tempNames = Objects.equals(standSeEntityCachePo.getEntityCacheKeyDeal(), "0") ? Arrays.asList(this.parseName(tempNameString)) : Collections.singletonList(tempNameString);
                            for (String tempName : tempNames) {
                                if (StringUtils.isBlank((CharSequence)tempName) || this.parseIntegerCheck(tempName)) continue;
                                if (cacheAddQueryTempMap.containsKey(tempName = tempName.trim())) {
                                    cacheAddQueryTempMap.put(tempName, (String)cacheAddQueryTempMap.get(tempName) + "," + tempId);
                                    continue;
                                }
                                cacheAddQueryTempMap.put(tempName, String.valueOf(tempId));
                            }
                        }
                        seEntityCacheBO.put(standSeEntityCachePo.getSearchFilterId() + "_" + seChannelType + "_size", (Object)resultListAll.size());
                        seEntityCacheBO.put(standSeEntityCachePo.getSearchFilterId() + "_" + seChannelType + "_map", (Object)cacheAddQueryTempMap.size());
                        if (!entityCacheMap.containsKey(standSeEntityCachePo.getSearchFilterId())) {
                            entityCacheMap.put(standSeEntityCachePo.getSearchFilterId(), new HashMap());
                        }
                        entityCacheMap.get(standSeEntityCachePo.getSearchFilterId()).put(seChannelType, cacheAddQueryTempMap);
                        log.info("initialization {}({}) channel:{} listSize:{} mapSize:{} complete", new Object[]{standSeEntityCachePo.getSearchFilterId(), standSeEntityCachePo.getSearchFieldName(), seChannelType, resultListAll.size(), cacheAddQueryTempMap.size()});
                        continue;
                    }
                    log.info("initialization cache {}({}) channel:{} jump!", new Object[]{standSeEntityCachePo.getSearchFilterId(), standSeEntityCachePo.getSearchFieldName(), seChannelType});
                }
                catch (Exception e) {
                    log.error("initialization " + standSeEntityCachePo.getSearchFilterId() + "(" + standSeEntityCachePo.getSearchFieldName() + ") failure");
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.initEsObjectFieldMappingCache();
    }

    private List<com.alibaba.fastjson.JSONObject> selectEntityListFromES(String indexName, String entityCacheValue, String entityCacheKey, String whereSql) {
        try {
            JSONArray hitsArray;
            com.alibaba.fastjson.JSONObject esResultJson;
            com.alibaba.fastjson.JSONObject hits;
            String esResult = this.elasticsearchUtil.postEsSearch(indexName, whereSql, "entityCache", Integer.valueOf(3));
            ArrayList<com.alibaba.fastjson.JSONObject> resultList = new ArrayList<com.alibaba.fastjson.JSONObject>();
            if (StringUtils.isNotBlank((CharSequence)esResult) && (hits = (esResultJson = JSON.parseObject((String)esResult)).getJSONObject("hits")) != null && (hitsArray = hits.getJSONArray("hits")) != null) {
                for (int i = 0; i < hitsArray.size(); ++i) {
                    String supplierName;
                    com.alibaba.fastjson.JSONObject latestHit;
                    com.alibaba.fastjson.JSONObject latestSource;
                    JSONArray latestHitsArray;
                    com.alibaba.fastjson.JSONObject latestHits;
                    com.alibaba.fastjson.JSONObject latest;
                    com.alibaba.fastjson.JSONObject innerHits;
                    String brandName;
                    com.alibaba.fastjson.JSONObject hit = hitsArray.getJSONObject(i);
                    com.alibaba.fastjson.JSONObject source = hit.getJSONObject("_source");
                    com.alibaba.fastjson.JSONObject resultItem = new com.alibaba.fastjson.JSONObject();
                    if (source != null && Objects.equals(entityCacheKey, "BRAND_NAME") && StringUtils.isNotBlank((CharSequence)(brandName = source.getString("brandName")))) {
                        Object supplierId;
                        resultItem.put(entityCacheKey, (Object)brandName);
                        if (Objects.equals(entityCacheValue, "BRAND_ID")) {
                            Object brandId = source.get((Object)"brandId");
                            if (brandId != null) {
                                resultItem.put(entityCacheValue, (Object)String.valueOf(brandId));
                            }
                        } else if (Objects.equals(entityCacheValue, "VENDOR_ID") && (supplierId = source.get((Object)"supplierId")) != null) {
                            resultItem.put(entityCacheValue, (Object)String.valueOf(supplierId));
                        }
                    }
                    if ((innerHits = hit.getJSONObject("inner_hits")) != null && Objects.equals(entityCacheKey, "VENDOR_NAME") && (latest = innerHits.getJSONObject("latest")) != null && (latestHits = latest.getJSONObject("hits")) != null && (latestHitsArray = latestHits.getJSONArray("hits")) != null && latestHitsArray.size() > 0 && (latestSource = (latestHit = latestHitsArray.getJSONObject(0)).getJSONObject("_source")) != null && StringUtils.isNotBlank((CharSequence)(supplierName = latestSource.getString("supplierName")))) {
                        Object supplierId;
                        resultItem.put(entityCacheKey, (Object)supplierName);
                        if (Objects.equals(entityCacheValue, "VENDOR_ID") && source != null && (supplierId = source.get((Object)"supplierId")) != null) {
                            resultItem.put(entityCacheValue, (Object)String.valueOf(supplierId));
                        }
                    }
                    if (resultItem.isEmpty() || !resultItem.containsKey((Object)entityCacheKey)) continue;
                    if (resultItem.containsKey((Object)entityCacheValue) && resultItem.get((Object)entityCacheValue) == null) {
                        resultItem.put(entityCacheValue, (Object)"");
                    }
                    resultList.add(resultItem);
                    log.debug("\u6dfb\u52a0\u7f13\u5b58\u9879: {}={}, {}={}", new Object[]{entityCacheKey, resultItem.getString(entityCacheKey), entityCacheValue, resultItem.getString(entityCacheValue)});
                }
            }
            return resultList;
        }
        catch (Exception e) {
            log.error("\u4eceElasticSearch\u67e5\u8be2\u5b9e\u4f53\u6570\u636e\u5f02\u5e38 - indexName:{}, entityCacheValue:{}, entityCacheKey:{}, error:{}", new Object[]{indexName, entityCacheValue, entityCacheKey, e.getMessage(), e});
            return new ArrayList<com.alibaba.fastjson.JSONObject>();
        }
    }

    private void initEsObjectFieldMappingCache() {
        try {
            List configList = this.esFiledObjConfigMapper.selectByStatus(Integer.valueOf(0));
            if (CollectionUtils.isEmpty((Collection)configList)) {
                return;
            }
            if (!entityCacheMap.containsKey("ENTITY_CACHE_SEARCH_FIELD_MAPPING")) {
                entityCacheMap.put("ENTITY_CACHE_SEARCH_FIELD_MAPPING", new HashMap());
            }
            for (EsFiledObjConfigPo config : configList) {
                String searchFilterId = config.getSearchFilterId();
                String searchFieldName = config.getSearchFieldName();
                String searchFilterName = config.getSearchFilterName();
                Long seChannelType = config.getSeChannelType();
                if (seChannelType == null) {
                    seChannelType = 2L;
                }
                if (!entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").containsKey(seChannelType)) {
                    entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").put(seChannelType, new HashMap());
                }
                entityCacheMap.get("ENTITY_CACHE_SEARCH_FIELD_MAPPING").get(seChannelType).put(searchFilterId, searchFieldName);
                if (!entityCacheMap.containsKey("ENTITY_CACHE_STANDARD_OPEN")) {
                    entityCacheMap.put("ENTITY_CACHE_STANDARD_OPEN", new HashMap());
                }
                if (!entityCacheMap.get("ENTITY_CACHE_STANDARD_OPEN").containsKey(seChannelType)) {
                    entityCacheMap.get("ENTITY_CACHE_STANDARD_OPEN").put(seChannelType, new HashMap());
                }
                entityCacheMap.get("ENTITY_CACHE_STANDARD_OPEN").get(seChannelType).put("isStandardOpen", String.valueOf(0));
                log.info("\u5df2\u52a0\u8f7des\u5bf9\u8c61\u5b57\u6bb5\u914d\u7f6e - searchFilterId: {}, searchFieldName: {}, searchFilterName: {}, seChannelType: {}", new Object[]{searchFilterId, searchFieldName, searchFilterName, seChannelType});
            }
            log.info("es\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u7f13\u5b58\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u5171\u52a0\u8f7d{}\u4e2a\u914d\u7f6e", (Object)configList.size());
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316es\u5bf9\u8c61\u5b57\u6bb5\u6620\u5c04\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }

    public static String getEsObjectFieldMapping(String searchFilterName, String objectValue, Long seChannelType) {
        Map<Long, Map<String, String>> channelMappingData;
        if (esObjectFieldMappingCache == null || StringUtils.isBlank((CharSequence)searchFilterName) || StringUtils.isBlank((CharSequence)objectValue)) {
            return objectValue;
        }
        if (seChannelType == null) {
            seChannelType = 1L;
        }
        if ((channelMappingData = esObjectFieldMappingCache.get(searchFilterName)) == null) {
            return objectValue;
        }
        Map<String, String> mappingData = channelMappingData.get(seChannelType);
        if (mappingData == null) {
            return objectValue;
        }
        return mappingData.getOrDefault(objectValue, objectValue);
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public UccGuideCatalogMapper getUccGuideCatalogMapper() {
        return this.uccGuideCatalogMapper;
    }

    public UccBrandMapper getUccBrandMapper() {
        return this.uccBrandMapper;
    }

    public UccEntityCacheSelectMapper getUccEntityCacheSelectMapper() {
        return this.uccEntityCacheSelectMapper;
    }

    public StandSeEntityCacheMapper getStandSeEntityCacheMapper() {
        return this.standSeEntityCacheMapper;
    }

    public UccVendorMapper getUccVendorMapper() {
        return this.uccVendorMapper;
    }

    public UccCommodityTypeMapper getUccCommodityTypeMapper() {
        return this.uccCommodityTypeMapper;
    }

    public SeCommDetailInLogMapper getSeCommDetailInLogMapper() {
        return this.seCommDetailInLogMapper;
    }

    public UccCatalogDealMapper getUccCatalogDealMapper() {
        return this.uccCatalogDealMapper;
    }

    public UccSearchGuideCatalogRelMapper getUccSearchGuideCatalogRelMapper() {
        return this.uccSearchGuideCatalogRelMapper;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public ElasticsearchUtil getElasticsearchUtil() {
        return this.elasticsearchUtil;
    }

    public EsFiledObjConfigMapper getEsFiledObjConfigMapper() {
        return this.esFiledObjConfigMapper;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setUccGuideCatalogMapper(UccGuideCatalogMapper uccGuideCatalogMapper) {
        this.uccGuideCatalogMapper = uccGuideCatalogMapper;
    }

    public void setUccBrandMapper(UccBrandMapper uccBrandMapper) {
        this.uccBrandMapper = uccBrandMapper;
    }

    public void setUccEntityCacheSelectMapper(UccEntityCacheSelectMapper uccEntityCacheSelectMapper) {
        this.uccEntityCacheSelectMapper = uccEntityCacheSelectMapper;
    }

    public void setStandSeEntityCacheMapper(StandSeEntityCacheMapper standSeEntityCacheMapper) {
        this.standSeEntityCacheMapper = standSeEntityCacheMapper;
    }

    public void setUccVendorMapper(UccVendorMapper uccVendorMapper) {
        this.uccVendorMapper = uccVendorMapper;
    }

    public void setUccCommodityTypeMapper(UccCommodityTypeMapper uccCommodityTypeMapper) {
        this.uccCommodityTypeMapper = uccCommodityTypeMapper;
    }

    public void setSeCommDetailInLogMapper(SeCommDetailInLogMapper seCommDetailInLogMapper) {
        this.seCommDetailInLogMapper = seCommDetailInLogMapper;
    }

    public void setUccCatalogDealMapper(UccCatalogDealMapper uccCatalogDealMapper) {
        this.uccCatalogDealMapper = uccCatalogDealMapper;
    }

    public void setUccSearchGuideCatalogRelMapper(UccSearchGuideCatalogRelMapper uccSearchGuideCatalogRelMapper) {
        this.uccSearchGuideCatalogRelMapper = uccSearchGuideCatalogRelMapper;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setElasticsearchUtil(ElasticsearchUtil elasticsearchUtil) {
        this.elasticsearchUtil = elasticsearchUtil;
    }

    public void setEsFiledObjConfigMapper(EsFiledObjConfigMapper esFiledObjConfigMapper) {
        this.esFiledObjConfigMapper = esFiledObjConfigMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeEntityCache)) {
            return false;
        }
        SeEntityCache other = (SeEntityCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        UccGuideCatalogMapper this$uccGuideCatalogMapper = this.getUccGuideCatalogMapper();
        UccGuideCatalogMapper other$uccGuideCatalogMapper = other.getUccGuideCatalogMapper();
        if (this$uccGuideCatalogMapper == null ? other$uccGuideCatalogMapper != null : !this$uccGuideCatalogMapper.equals(other$uccGuideCatalogMapper)) {
            return false;
        }
        UccBrandMapper this$uccBrandMapper = this.getUccBrandMapper();
        UccBrandMapper other$uccBrandMapper = other.getUccBrandMapper();
        if (this$uccBrandMapper == null ? other$uccBrandMapper != null : !this$uccBrandMapper.equals(other$uccBrandMapper)) {
            return false;
        }
        UccEntityCacheSelectMapper this$uccEntityCacheSelectMapper = this.getUccEntityCacheSelectMapper();
        UccEntityCacheSelectMapper other$uccEntityCacheSelectMapper = other.getUccEntityCacheSelectMapper();
        if (this$uccEntityCacheSelectMapper == null ? other$uccEntityCacheSelectMapper != null : !this$uccEntityCacheSelectMapper.equals(other$uccEntityCacheSelectMapper)) {
            return false;
        }
        StandSeEntityCacheMapper this$standSeEntityCacheMapper = this.getStandSeEntityCacheMapper();
        StandSeEntityCacheMapper other$standSeEntityCacheMapper = other.getStandSeEntityCacheMapper();
        if (this$standSeEntityCacheMapper == null ? other$standSeEntityCacheMapper != null : !this$standSeEntityCacheMapper.equals(other$standSeEntityCacheMapper)) {
            return false;
        }
        UccVendorMapper this$uccVendorMapper = this.getUccVendorMapper();
        UccVendorMapper other$uccVendorMapper = other.getUccVendorMapper();
        if (this$uccVendorMapper == null ? other$uccVendorMapper != null : !this$uccVendorMapper.equals(other$uccVendorMapper)) {
            return false;
        }
        UccCommodityTypeMapper this$uccCommodityTypeMapper = this.getUccCommodityTypeMapper();
        UccCommodityTypeMapper other$uccCommodityTypeMapper = other.getUccCommodityTypeMapper();
        if (this$uccCommodityTypeMapper == null ? other$uccCommodityTypeMapper != null : !this$uccCommodityTypeMapper.equals(other$uccCommodityTypeMapper)) {
            return false;
        }
        SeCommDetailInLogMapper this$seCommDetailInLogMapper = this.getSeCommDetailInLogMapper();
        SeCommDetailInLogMapper other$seCommDetailInLogMapper = other.getSeCommDetailInLogMapper();
        if (this$seCommDetailInLogMapper == null ? other$seCommDetailInLogMapper != null : !this$seCommDetailInLogMapper.equals(other$seCommDetailInLogMapper)) {
            return false;
        }
        UccCatalogDealMapper this$uccCatalogDealMapper = this.getUccCatalogDealMapper();
        UccCatalogDealMapper other$uccCatalogDealMapper = other.getUccCatalogDealMapper();
        if (this$uccCatalogDealMapper == null ? other$uccCatalogDealMapper != null : !this$uccCatalogDealMapper.equals(other$uccCatalogDealMapper)) {
            return false;
        }
        UccSearchGuideCatalogRelMapper this$uccSearchGuideCatalogRelMapper = this.getUccSearchGuideCatalogRelMapper();
        UccSearchGuideCatalogRelMapper other$uccSearchGuideCatalogRelMapper = other.getUccSearchGuideCatalogRelMapper();
        if (this$uccSearchGuideCatalogRelMapper == null ? other$uccSearchGuideCatalogRelMapper != null : !this$uccSearchGuideCatalogRelMapper.equals(other$uccSearchGuideCatalogRelMapper)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        ElasticsearchUtil this$elasticsearchUtil = this.getElasticsearchUtil();
        ElasticsearchUtil other$elasticsearchUtil = other.getElasticsearchUtil();
        if (this$elasticsearchUtil == null ? other$elasticsearchUtil != null : !this$elasticsearchUtil.equals(other$elasticsearchUtil)) {
            return false;
        }
        EsFiledObjConfigMapper this$esFiledObjConfigMapper = this.getEsFiledObjConfigMapper();
        EsFiledObjConfigMapper other$esFiledObjConfigMapper = other.getEsFiledObjConfigMapper();
        return !(this$esFiledObjConfigMapper == null ? other$esFiledObjConfigMapper != null : !this$esFiledObjConfigMapper.equals(other$esFiledObjConfigMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeEntityCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        UccGuideCatalogMapper $uccGuideCatalogMapper = this.getUccGuideCatalogMapper();
        result = result * 59 + ($uccGuideCatalogMapper == null ? 43 : $uccGuideCatalogMapper.hashCode());
        UccBrandMapper $uccBrandMapper = this.getUccBrandMapper();
        result = result * 59 + ($uccBrandMapper == null ? 43 : $uccBrandMapper.hashCode());
        UccEntityCacheSelectMapper $uccEntityCacheSelectMapper = this.getUccEntityCacheSelectMapper();
        result = result * 59 + ($uccEntityCacheSelectMapper == null ? 43 : $uccEntityCacheSelectMapper.hashCode());
        StandSeEntityCacheMapper $standSeEntityCacheMapper = this.getStandSeEntityCacheMapper();
        result = result * 59 + ($standSeEntityCacheMapper == null ? 43 : $standSeEntityCacheMapper.hashCode());
        UccVendorMapper $uccVendorMapper = this.getUccVendorMapper();
        result = result * 59 + ($uccVendorMapper == null ? 43 : $uccVendorMapper.hashCode());
        UccCommodityTypeMapper $uccCommodityTypeMapper = this.getUccCommodityTypeMapper();
        result = result * 59 + ($uccCommodityTypeMapper == null ? 43 : $uccCommodityTypeMapper.hashCode());
        SeCommDetailInLogMapper $seCommDetailInLogMapper = this.getSeCommDetailInLogMapper();
        result = result * 59 + ($seCommDetailInLogMapper == null ? 43 : $seCommDetailInLogMapper.hashCode());
        UccCatalogDealMapper $uccCatalogDealMapper = this.getUccCatalogDealMapper();
        result = result * 59 + ($uccCatalogDealMapper == null ? 43 : $uccCatalogDealMapper.hashCode());
        UccSearchGuideCatalogRelMapper $uccSearchGuideCatalogRelMapper = this.getUccSearchGuideCatalogRelMapper();
        result = result * 59 + ($uccSearchGuideCatalogRelMapper == null ? 43 : $uccSearchGuideCatalogRelMapper.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        ElasticsearchUtil $elasticsearchUtil = this.getElasticsearchUtil();
        result = result * 59 + ($elasticsearchUtil == null ? 43 : $elasticsearchUtil.hashCode());
        EsFiledObjConfigMapper $esFiledObjConfigMapper = this.getEsFiledObjConfigMapper();
        result = result * 59 + ($esFiledObjConfigMapper == null ? 43 : $esFiledObjConfigMapper.hashCode());
        return result;
    }

    public String toString() {
        return "SeEntityCache(cacheClient=" + this.getCacheClient() + ", uccGuideCatalogMapper=" + this.getUccGuideCatalogMapper() + ", uccBrandMapper=" + this.getUccBrandMapper() + ", uccEntityCacheSelectMapper=" + this.getUccEntityCacheSelectMapper() + ", standSeEntityCacheMapper=" + this.getStandSeEntityCacheMapper() + ", uccVendorMapper=" + this.getUccVendorMapper() + ", uccCommodityTypeMapper=" + this.getUccCommodityTypeMapper() + ", seCommDetailInLogMapper=" + this.getSeCommDetailInLogMapper() + ", uccCatalogDealMapper=" + this.getUccCatalogDealMapper() + ", uccSearchGuideCatalogRelMapper=" + this.getUccSearchGuideCatalogRelMapper() + ", driverName=" + this.getDriverName() + ", elasticsearchUtil=" + this.getElasticsearchUtil() + ", esFiledObjConfigMapper=" + this.getEsFiledObjConfigMapper() + ")";
    }

    public static Map<String, Map<Long, Map<String, String>>> getEntityCacheMap() {
        return entityCacheMap;
    }

    public static List<String> getCatalogIdList() {
        return catalogIdList;
    }

    public static void setSearchWordCatalogMap(Map<String, Object> searchWordCatalogMap) {
        SeEntityCache.searchWordCatalogMap = searchWordCatalogMap;
    }

    public static Map<String, Object> getSearchWordCatalogMap() {
        return searchWordCatalogMap;
    }

    public static Map<String, Map<Long, Map<String, String>>> getEsObjectFieldMappingCache() {
        return esObjectFieldMappingCache;
    }
}

