/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.DarticipleQueryBO;
import com.tydic.se.base.ability.bo.DarticipleQueryReader;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeEsAnalyzerBO;
import com.tydic.se.base.ability.bo.SeEsOldResultBO;
import com.tydic.se.base.ability.bo.SeEsResultBO;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeShouldBO;
import com.tydic.se.base.ability.bo.SeTermsBO;
import com.tydic.se.base.constant.SeSearchConstants;
import com.tydic.se.base.constant.ToOdpsCommConstant;
import com.tydic.se.base.dao.EsIndexMapper;
import com.tydic.se.base.dao.po.EsIndex;
import com.tydic.se.es.util.ElasticsearchUtil;
import com.tydic.se.nlp.alu.intfs.EntityRecognitionService;
import com.tydic.se.nlp.alu.req.EntityRecognitionReqBo;
import com.tydic.se.nlp.alu.rsp.EntityRecognitionRspBo;
import com.tydic.se.nlp.alu.rsp.NerDataRspBo;
import com.tydic.se.nlp.api.SearchAnalysisService;
import com.tydic.se.nlp.bo.AnalysisEsAnalyzeQueryBO;
import com.tydic.se.nlp.req.QueryRewriteResultBO;
import com.tydic.se.search.ability.bo.ExecuteSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.AnyTrustStrategy;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.job.bo.AccurateQueryBO;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class SeQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(SeQueryBuilder.class);
    @Value(value="${es.config.addresses}")
    private String ADDRESSES;
    @Value(value="${es.config.username}")
    private String USERNAME;
    @Value(value="${es.config.password}")
    private String PASSWORD;
    @Value(value="${es.config.addresses}")
    private String addresses;
    @Value(value="${es.config.maxRetries:5}")
    private int maxRetries;
    private String chineseReg = "[\u4e00-\u9fcc]+";
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private EntityRecognitionService entityRecognitionService;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private SearchAnalysisService searchAnalysisService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EsIndexMapper esIndexMapper;

    public ExecuteSearchRspBO simpleSearch(ExecuteSearchReqBO executeSearchReqBO) {
        if (executeSearchReqBO.getQueryStr() == null) {
            executeSearchReqBO.setQueryStr("");
        }
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        darticipleQueryReader.setQuery(executeSearchReqBO.getQueryStr());
        darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        darticipleQueryReader.setZero_terms_query("NONE");
        darticipleQueryReader.setMinimum_should_match("55%");
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        darticipleQueryBO.init(darticipleQueryReader);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String INDEX_NAME = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
        List esIndices = this.esIndexMapper.queryBySeChannelType(executeSearchReqBO.getSeChannelType());
        for (EsIndex esIndex : esIndices) {
            if (esIndex.getFlag() != 0 || esIndex.getiType() != ToOdpsCommConstant.esType.TYPE_2) continue;
            INDEX_NAME = esIndex.getIndexSName();
        }
        String esResult = this.elasticsearchUtil.postEsSearch(INDEX_NAME, esQueryBody, "SimpleSearch", Integer.valueOf(this.maxRetries));
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setResult(esResult);
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    public ExecuteSearchRspBO executeSearch(ExecuteSearchReqBO executeSearchReqBO) {
        executeSearchReqBO.setQueryStr(executeSearchReqBO.getQueryStr().trim());
        if (StringUtils.isNumeric((CharSequence)executeSearchReqBO.getQueryStr())) {
            String maxLong = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esMaxLong;
            if (new BigInteger(executeSearchReqBO.getQueryStr()).compareTo(new BigInteger(maxLong)) > 0) {
                executeSearchReqBO.setQueryStr(executeSearchReqBO.getQueryStr() + ".");
            }
        }
        Pattern p = Pattern.compile(this.chineseReg);
        Matcher m = p.matcher(executeSearchReqBO.getQueryStr());
        String LONG_ACCURATE_FIELDS_SIZE = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateSize;
        if (StringUtils.isBlank((CharSequence)executeSearchReqBO.getQueryStr())) {
            executeSearchReqBO.setSearchType("L3");
        } else if (m.find() && executeSearchReqBO.getQueryStr().length() == 1) {
            executeSearchReqBO.setSearchType("L0");
        } else if (m.find() && executeSearchReqBO.getQueryStr().length() > Integer.parseInt(LONG_ACCURATE_FIELDS_SIZE)) {
            executeSearchReqBO.setSearchType("L3");
        } else if (executeSearchReqBO.getQueryStr().contains(" ")) {
            executeSearchReqBO.setSearchType("L3");
        } else {
            executeSearchReqBO.setSearchType("L0");
        }
        String minMustTermsListSize = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esMinMustTermsListSize;
        if (!Objects.equals("-1", minMustTermsListSize) && executeSearchReqBO.getMustTermsList().size() < Integer.parseInt(minMustTermsListSize)) {
            executeSearchReqBO.setCheckBlankCatalog(Boolean.valueOf(true));
        }
        return this.search(executeSearchReqBO);
    }

    private ExecuteSearchRspBO search(ExecuteSearchReqBO executeSearchReqBO) {
        if (StringUtils.isEmpty((CharSequence)executeSearchReqBO.getQueryStr())) {
            executeSearchReqBO.setQueryStr("");
        }
        if (StringUtils.isBlank((CharSequence)executeSearchReqBO.getSearchType())) {
            executeSearchReqBO.setSearchType("L3");
        }
        String INDEX_NAME = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
        List esIndices = this.esIndexMapper.queryBySeChannelType(executeSearchReqBO.getSeChannelType());
        for (EsIndex esIndex : esIndices) {
            if (esIndex.getFlag() != 0 || esIndex.getiType() != ToOdpsCommConstant.esType.TYPE_2) continue;
            INDEX_NAME = esIndex.getIndexSName();
        }
        String indexName = StringUtils.isBlank((CharSequence)executeSearchReqBO.getIndexName()) ? INDEX_NAME : executeSearchReqBO.getIndexName();
        String isParticiple = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).isParticiple;
        if (Objects.equals(executeSearchReqBO.getSearchType(), "L3") && Objects.equals(isParticiple, "1") && executeSearchReqBO.getQueryStr() != null) {
            String searchUseRaner = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)executeSearchReqBO.getSeChannelType())).searchUseRaner;
            if (Objects.equals(searchUseRaner, "1")) {
                try {
                    QueryRewriteResultBO queryRewriteResult = this.searchAnalysisService.queryRewrite(executeSearchReqBO.getQueryStr(), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), executeSearchReqBO.getSeChannelType());
                    if (queryRewriteResult != null && queryRewriteResult.getIsRewritten().booleanValue()) {
                        log.info("{}{}\u67e5\u8be2\u6539\u5199\u6210\u529f\uff1a\u539f\u67e5\u8be2\u3010{}\u3011\uff0c\u6539\u5199\u540e\u3010{}\u3011", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", queryRewriteResult.getOriginalQuery(), queryRewriteResult.getRewrittenQuery()});
                        executeSearchReqBO.setRewriteQueryStr(queryRewriteResult.getRewrittenQuery());
                        if (queryRewriteResult.getNerEntities() != null && !queryRewriteResult.getNerEntities().isEmpty()) {
                            log.info("{}{}NER\u5b9e\u4f53\u8bc6\u522b\u7ed3\u679c{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)queryRewriteResult.getNerEntities())});
                        }
                        if (queryRewriteResult.getBrandList() != null) {
                            log.info("{}{}\u8bc6\u522b\u5230\u54c1\u724c{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)queryRewriteResult.getBrandList())});
                        }
                        if (queryRewriteResult.getCategoryList() != null) {
                            log.info("{}{}\u8bc6\u522b\u5230\u7c7b\u76ee{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)queryRewriteResult.getCategoryList())});
                        }
                        if (queryRewriteResult.getModelList() != null) {
                            log.info("{}{}\u8bc6\u522b\u5230\u578b\u53f7{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)queryRewriteResult.getModelList())});
                        }
                    }
                }
                catch (Exception e) {
                    log.error("{}{}\u67e5\u8be2\u6539\u5199\u5931\u8d25\uff0c\u4f7f\u7528\u57fa\u7840\u641c\u7d22\u6539\u5199\uff1a{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", e.getMessage(), e});
                }
            }
            if (executeSearchReqBO.getRewriteQueryStr() == null) {
                AnalysisEsAnalyzeQueryBO esAnalyzeQueryBO = new AnalysisEsAnalyzeQueryBO();
                esAnalyzeQueryBO.setText(executeSearchReqBO.getQueryStr());
                String esAnalyzer = ((SearchProcessConfig.VectorConfig)this.searchProcessConfig.getVector().get((Object)executeSearchReqBO.getSeChannelType())).esAnalyzer;
                String isSynonymRewrite = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).isSynonymRewrite;
                esAnalyzeQueryBO.setAnalyzer(esAnalyzer != null ? esAnalyzer : "ik_smart");
                String esAnalyze = this.elasticsearchUtil.postEsAnalyze(indexName, JSONObject.toJSONString((Object)esAnalyzeQueryBO));
                SeEsAnalyzerBO seEsAnalyzerBO = (SeEsAnalyzerBO)JSONObject.parseObject((String)esAnalyze, SeEsAnalyzerBO.class);
                if (seEsAnalyzerBO != null && seEsAnalyzerBO.getTokens() != null) {
                    List tokens = seEsAnalyzerBO.getTokens();
                    if (Objects.equals(isSynonymRewrite, "1")) {
                        for (SeEsAnalyzerBO.Tokens token : tokens) {
                            String synonymWord = this.cacheClient.hget("{SEARCH}_SYNONYM_WORD", token.getToken());
                            if (synonymWord == null) continue;
                            token.setToken(token.getToken() + " " + synonymWord);
                        }
                    }
                    String rewriteQueryStr = tokens.stream().map(SeEsAnalyzerBO.Tokens::getToken).collect(Collectors.joining(" "));
                    executeSearchReqBO.setRewriteQueryStr(rewriteQueryStr);
                }
            }
        }
        DarticipleQueryBO darticipleQueryBO = this.initDarticipleQueryBO(executeSearchReqBO);
        String esQueryBody = this.parseContent(darticipleQueryBO);
        String esResult = "{}";
        String openEsClients = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esOpenClients;
        if (Objects.equals(openEsClients, "1") && this.addresses.contains(",") && StringUtils.isNotBlank((CharSequence)executeSearchReqBO.getQueryStr()) && Objects.equals(executeSearchReqBO.getSearchType(), "L3")) {
            String PREFERENCE = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esIndexPreference;
            String ES_SEARCH_SIZE = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esConfigSearchSize;
            Integer size = Integer.parseInt(ES_SEARCH_SIZE);
            esResult = this.elasticsearchUtil.postSearchClients(indexName, PREFERENCE, esQueryBody, size, executeSearchReqBO.getSearchType());
            if (ObjectUtils.isEmpty((Object)esResult)) {
                log.warn("{}{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", "\u5546\u54c1\u67e5\u8be2\u7ed3\u679c\u8d85\u51fa\u4e0a\u9650\uff0c\u5207\u6362\u67e5\u8be2\u65b9\u6848\uff01"});
                esResult = this.elasticsearchUtil.postEsSearch(indexName, esQueryBody, executeSearchReqBO.getSearchType(), Integer.valueOf(this.maxRetries));
            }
        } else {
            esResult = this.elasticsearchUtil.postEsSearch(indexName, esQueryBody, executeSearchReqBO.getSearchType(), Integer.valueOf(this.maxRetries));
        }
        SeEsResultBO esResultBO = new SeEsResultBO();
        try {
            esResultBO = (SeEsResultBO)JSON.parseObject((String)esResult, SeEsResultBO.class);
        }
        catch (Exception e) {
            SeEsOldResultBO seEsOldResultBO = (SeEsOldResultBO)JSON.parseObject((String)esResult, SeEsOldResultBO.class);
            Integer totalValue = seEsOldResultBO.getHits().getTotal();
            seEsOldResultBO.getHits().setTotal(null);
            String newEsResult = JSON.toJSONString((Object)seEsOldResultBO);
            esResultBO = (SeEsResultBO)JSON.parseObject((String)newEsResult, SeEsResultBO.class);
            SeEsResultBO.Hits.Total total = new SeEsResultBO.Hits.Total();
            total.setValue(totalValue);
            esResultBO.getHits().setTotal(total);
        }
        if (esResultBO.getHits().getTotal().getValue() == 0 && "L0".equals(executeSearchReqBO.getSearchType())) {
            executeSearchReqBO.setSearchType("L1");
            return this.search(executeSearchReqBO);
        }
        if (esResultBO.getHits().getTotal().getValue() == 0 && "L1".equals(executeSearchReqBO.getSearchType())) {
            String shelvesFilter = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esShelvesFilter;
            if (Objects.equals(shelvesFilter, "1")) {
                Pattern p = Pattern.compile(this.chineseReg);
                Matcher m = p.matcher(executeSearchReqBO.getQueryStr());
                if (Boolean.TRUE.equals(m.find())) {
                    executeSearchReqBO.setSearchType("L3");
                    return this.search(executeSearchReqBO);
                }
                log.info("{}{}\u67e5\u8be2\u77ed\u8bed\uff1a{}\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\u8df3\u8fc7L3", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>TXT>>>", executeSearchReqBO.getQueryStr()});
            } else {
                executeSearchReqBO.setSearchType("L3");
                return this.search(executeSearchReqBO);
            }
        }
        ExecuteSearchRspBO rspBO = new ExecuteSearchRspBO();
        rspBO.setEsResultBO(esResultBO);
        rspBO.setResult(esResult);
        rspBO.setSearchType(executeSearchReqBO.getSearchType());
        rspBO.setQueryBody(esQueryBody);
        rspBO.setMessage("\u6210\u529f");
        rspBO.setCode("0");
        return rspBO;
    }

    private Map<String, String> parseEntityMap(String queryStr, List<SeTermsBO> mustTermsList) {
        EntityRecognitionReqBo entityRecognitionReqBo = new EntityRecognitionReqBo();
        entityRecognitionReqBo.setQueryStr(queryStr);
        EntityRecognitionRspBo entityRecognitionRspBo = this.entityRecognitionService.doNer(entityRecognitionReqBo);
        HashMap<String, String> entityMap = new HashMap<String, String>();
        String common = "common";
        entityMap.put(common, queryStr);
        if (entityRecognitionRspBo != null && entityRecognitionRspBo.getNerList() != null) {
            for (NerDataRspBo nerDataRspBo : entityRecognitionRspBo.getNerList()) {
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.CATEGORY_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String lv2Category = "l2_category";
                    if (entityMap.containsKey(lv2Category)) {
                        entityMap.put(lv2Category, (String)entityMap.get(lv2Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv2Category, nerDataRspBo.getWord());
                    }
                    String lv3Category = "l3_category";
                    if (entityMap.containsKey(lv3Category)) {
                        entityMap.put(lv3Category, (String)entityMap.get(lv3Category) + "," + nerDataRspBo.getWord());
                    } else {
                        entityMap.put(lv3Category, nerDataRspBo.getWord());
                    }
                    String lv4Category = "l4mg_category";
                    if (entityMap.containsKey(lv4Category)) {
                        entityMap.put(lv4Category, (String)entityMap.get(lv4Category) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(lv4Category, nerDataRspBo.getWord());
                    continue;
                }
                if (this.verifyEffectEntity(SeSearchConstants.EntityRecognition.BRAND_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) {
                    String brand = "brand";
                    if (entityMap.containsKey(brand)) {
                        entityMap.put(brand, (String)entityMap.get(brand) + "," + nerDataRspBo.getWord());
                        continue;
                    }
                    entityMap.put(brand, nerDataRspBo.getWord());
                    continue;
                }
                if (!this.verifyEffectEntity(SeSearchConstants.EntityRecognition.VENDOR_DESC_LIST, nerDataRspBo.getTag(), mustTermsList).booleanValue()) continue;
                String vendor = "vendor";
                if (entityMap.containsKey(vendor)) {
                    entityMap.put(vendor, (String)entityMap.get(vendor) + "," + nerDataRspBo.getWord());
                    continue;
                }
                entityMap.put(vendor, nerDataRspBo.getWord());
            }
        }
        return entityMap;
    }

    private Boolean verifyEffectEntity(List<String> list, String tag, List<SeTermsBO> mustTermsList) {
        if (list.contains(tag)) {
            if (mustTermsList != null && this.containsName(mustTermsList, tag)) {
                return false;
            }
            return true;
        }
        return false;
    }

    private List<SeTermsBO> parseTempTermsList(Map<String, String> entityMap, Long seChannelType) {
        if (seChannelType == null) {
            seChannelType = 1L;
        }
        HashMap<String, SeTermsBO> termsBOMap = new HashMap<String, SeTermsBO>();
        for (String key : entityMap.keySet()) {
            SeTermsBO termsBO;
            Map<String, String> singleMap;
            String[] categoryArr = entityMap.get(key).split(",");
            Map<Long, Map<String, String>> channelCacheMap = SeEntityCache.getEntityCacheMap().get(key);
            Map<String, String> map = singleMap = channelCacheMap != null ? channelCacheMap.get(seChannelType) : null;
            if (categoryArr == null || singleMap == null || (termsBO = this.parseTerms(key, categoryArr, singleMap)) == null) continue;
            termsBOMap.put(key, termsBO);
        }
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        if (termsBOMap.containsKey(lv4Category)) {
            termsBOMap.remove(lv2Category);
            termsBOMap.remove(lv3Category);
        } else if (termsBOMap.containsKey(lv3Category)) {
            termsBOMap.remove(lv2Category);
        }
        ArrayList<SeTermsBO> termsBOList = new ArrayList<SeTermsBO>();
        for (SeTermsBO termsBO : termsBOMap.values()) {
            termsBOList.add(termsBO);
        }
        return termsBOList;
    }

    private SeTermsBO parseTerms(String key, String[] categoryArr, Map<String, String> cacheMap) {
        ArrayList<String> valueList = new ArrayList<String>();
        String valueStr = "";
        for (String category : categoryArr) {
            if (!cacheMap.containsKey(category)) continue;
            valueStr = StringUtils.isNotBlank((CharSequence)valueStr) ? valueStr + "," + cacheMap.get(category) : cacheMap.get(category);
        }
        valueList.add(valueStr);
        if (StringUtils.isNotBlank((CharSequence)valueStr)) {
            SeTermsBO termsBO = new SeTermsBO(key + "_id", valueList);
            return termsBO;
        }
        return null;
    }

    private Map<String, String> matchTerms(Map<String, String> entityMap, List<SeTermsBO> tempTermsList) {
        String value;
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(lv3Category) && !this.containsName(tempTermsList, lv2Category) && !this.containsName(tempTermsList, lv3Category) && !this.containsName(tempTermsList, lv4Category)) {
            value = entityMap.get(lv3Category);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(brand) && !this.containsName(tempTermsList, brand)) {
            value = entityMap.get(brand);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        if (entityMap.containsKey(vendor) && !this.containsName(tempTermsList, vendor)) {
            value = entityMap.get(vendor);
            value = value.replaceAll(",", "");
            entityMap.put(common, entityMap.get(common) + value);
        }
        return entityMap;
    }

    /*
     * WARNING - void declaration
     */
    private DarticipleQueryBO initDarticipleQueryBO(ExecuteSearchReqBO executeSearchReqBO) {
        String isOpenBansRule;
        String propertiesUnion;
        String channelPriorityRecallEnable;
        String queryFilterListNeedEmpty;
        Object map;
        boolean isStandardOpen;
        DarticipleQueryBO darticipleQueryBO = new DarticipleQueryBO();
        DarticipleQueryReader darticipleQueryReader = new DarticipleQueryReader();
        String analyzer = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAnalyzer;
        darticipleQueryReader.setAnalyzer(analyzer);
        if (executeSearchReqBO.getFrom() != null) {
            darticipleQueryReader.setFrom(executeSearchReqBO.getFrom());
        }
        if (executeSearchReqBO.getSize() != null) {
            darticipleQueryReader.setSize(executeSearchReqBO.getSize());
        }
        String accurateFieldsStr = executeSearchReqBO.getAccurateFieldsStr();
        String fieldsStr = executeSearchReqBO.getFieldsStr();
        String longAccurateFieldsStr = executeSearchReqBO.getLongAccurateFieldsStr();
        List<String> catalogIdList = SeEntityCache.getCatalogIdList();
        List termsList1 = darticipleQueryReader.getTermsList();
        ArrayList<String> list = new ArrayList<String>();
        List mustTermsList = executeSearchReqBO.getMustTermsList();
        List termsList = null;
        String isOpenHotSearch = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).isOpenHotSearch;
        if (mustTermsList != null) {
            termsList = mustTermsList;
            for (SeTermsBO seTermsBO2 : mustTermsList) {
                list.add(seTermsBO2.getName());
            }
            if (Objects.equals(isOpenHotSearch, "1") && StringUtils.isEmpty((CharSequence)executeSearchReqBO.getQueryStr()) && !CollectionUtils.isEmpty(catalogIdList) && executeSearchReqBO.getCheckBlankQueryStr().booleanValue() && executeSearchReqBO.getCheckBlankCatalog().booleanValue()) {
                termsList.add(new SeTermsBO("l3_category_id", catalogIdList));
                log.info("{}{}\u6700\u8fd1\u70ed\u641c\u4e09\u7ea7\u7c7b\u76ee{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString(catalogIdList)});
            }
        } else {
            termsList = termsList1;
        }
        darticipleQueryReader.setTermsList(termsList);
        List notTermsList = null;
        notTermsList = executeSearchReqBO.getMustNotTermsList() != null ? executeSearchReqBO.getMustNotTermsList() : darticipleQueryReader.getNotTermsList();
        darticipleQueryReader.setNotTermsList(notTermsList);
        darticipleQueryReader.setIsAggregation(executeSearchReqBO.getIsAggregation());
        Long seChannelType = executeSearchReqBO.getSeChannelType();
        String size = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).filterMostImpressions;
        if (Boolean.TRUE.equals(executeSearchReqBO.getIsAggregation())) {
            darticipleQueryReader.setAggSize(Integer.valueOf(size));
            Map<Long, Map<String, String>> entityCacheSearchFilterChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_SEARCH_FILTER_MAPPING");
            Map<String, String> entityCacheSearchFilter = entityCacheSearchFilterChannelMap != null ? entityCacheSearchFilterChannelMap.get(seChannelType) : null;
            darticipleQueryReader.setEntityCacheSearchFilter(entityCacheSearchFilter);
        }
        String commodityStandardAggDsl = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)seChannelType)).commodityStandardAggDsl;
        Map<Long, Map<String, String>> matchQueryChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_STANDARD_OPEN");
        Map<String, String> matchQueryMap = matchQueryChannelMap != null ? matchQueryChannelMap.get(seChannelType) : null;
        boolean bl = isStandardOpen = matchQueryMap != null && "1".equals(matchQueryMap.get("isStandardOpen"));
        if (isStandardOpen) {
            darticipleQueryReader.setIsStandardProductAggregation(Boolean.valueOf(true));
            darticipleQueryReader.setCommodityStandardAggDsl(commodityStandardAggDsl);
        }
        String queryStr = executeSearchReqBO.getQueryStr();
        String[] fieldArr = null;
        ArrayList<String> fields = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)accurateFieldsStr)) {
            accurateFieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateTextFields;
        }
        if (StringUtils.isBlank((CharSequence)longAccurateFieldsStr)) {
            longAccurateFieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateFields;
        }
        if (StringUtils.isBlank((CharSequence)fieldsStr)) {
            fieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esFields;
        }
        ArrayList<String> queryFields = new ArrayList<String>();
        if (!CollectionUtils.isEmpty((Collection)executeSearchReqBO.getQueryFilterList())) {
            for (SeQueryFilterBO filterBO : executeSearchReqBO.getQueryFilterList()) {
                if ("brandName".equals(filterBO.getFilterId())) {
                    queryFields.add("brandName");
                    queryFields.add("brandName.keyword");
                    continue;
                }
                if (!"category".equals(filterBO.getFilterId())) continue;
                queryFields.add("l3_category_name");
                queryFields.add("l3_category_name.keyword");
            }
        }
        if ("L0".equals(executeSearchReqBO.getSearchType()) && StringUtils.isNotBlank((CharSequence)queryStr)) {
            block63: {
                map = new HashMap();
                Pattern p = Pattern.compile(this.chineseReg);
                Matcher m = p.matcher(executeSearchReqBO.getQueryStr());
                if (m.find() && executeSearchReqBO.getQueryStr().length() == 1) {
                    String rewriteQueryStr;
                    List<Object> participleFieldList = new ArrayList();
                    String participleFieldsStr = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateCompleteParticipleFields;
                    if (StringUtils.isNotBlank((CharSequence)participleFieldsStr)) {
                        participleFieldList = Arrays.asList(participleFieldsStr.split("\\|"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(rewriteQueryStr = this.cacheClient.hget("{SEARCH}_REWRITE_WORD", queryStr))) && !CollectionUtils.isEmpty(participleFieldList)) {
                        try {
                            void var32_63;
                            JSONObject rewriteJson = JSON.parseObject((String)rewriteQueryStr);
                            LinkedList linkedList = new LinkedList();
                            String string = rewriteJson.getString("wReName");
                            if (StringUtils.isNotBlank((CharSequence)string)) {
                                String[] completeQueryStrs = string.split("\\|");
                                List<String> list2 = Arrays.asList(completeQueryStrs);
                            }
                            if (CollectionUtils.isEmpty((Collection)var32_63)) {
                                for (String string2 : participleFieldList) {
                                    map.put(string2, "*" + queryStr + "*");
                                }
                                break block63;
                            }
                            if (var32_63.size() == 1) {
                                for (String string3 : participleFieldList) {
                                    map.put(string3, "*" + (String)var32_63.get(0) + "*");
                                }
                            } else {
                                for (String string4 : participleFieldList) {
                                    map.put(string4, "*" + String.join((CharSequence)"#_#^_^#_#", (Iterable<? extends CharSequence>)var32_63) + "*");
                                }
                            }
                            log.info("{}{}\u641c\u7d22\u6539\u5199{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString((Object)var32_63)});
                            log.info("{}{}\u641c\u7d22\u6539\u5199\u5b57\u6bb5{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString(participleFieldList)});
                        }
                        catch (Exception e) {
                            for (String string : participleFieldList) {
                                map.put(string, "*" + queryStr + "*");
                            }
                            log.error("\u81ea\u52a8\u8865\u5168\u5f02\u5e38{}", (Object)e.getMessage(), (Object)e);
                        }
                    } else {
                        for (String string : participleFieldList) {
                            map.put(string, "*" + queryStr + "*");
                        }
                    }
                } else {
                    fieldArr = accurateFieldsStr.split(",");
                    String value = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateTextBlurry;
                    for (String string : fieldArr) {
                        if (Objects.equals(value, "1")) {
                            map.put(string, "*" + queryStr + "*");
                            continue;
                        }
                        map.put(string, queryStr);
                    }
                }
            }
            darticipleQueryReader.setShould((Map)map);
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        } else if ("L1".equals(executeSearchReqBO.getSearchType()) && StringUtils.isNotBlank((CharSequence)queryStr)) {
            if (StringUtils.isNumeric((CharSequence)queryStr)) {
                String[] split;
                HashMap<String, String> longMap = new HashMap<String, String>();
                for (String s : split = longAccurateFieldsStr.split(",")) {
                    longMap.put(s, queryStr);
                }
                darticipleQueryReader.setLongShould(longMap);
                darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
            } else {
                map = new HashMap();
                fieldArr = accurateFieldsStr.split(",");
                String value = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esAccurateTextBlurry;
                for (String field : fieldArr) {
                    if (Objects.equals(value, "1")) {
                        map.put(field, "*" + queryStr + "*");
                        continue;
                    }
                    map.put(field, queryStr);
                }
                darticipleQueryReader.setShould((Map)map);
                darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
            }
        } else if (StringUtils.isNotBlank((CharSequence)fieldsStr)) {
            fieldArr = fieldsStr.split(",");
            for (String field : fieldArr) {
                fields.add(field);
            }
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        } else {
            fields.add(fieldsStr);
            darticipleQueryReader.setSearchType(executeSearchReqBO.getSearchType());
        }
        darticipleQueryReader.setFields(fields);
        if (executeSearchReqBO.getRewriteQueryStr() != null) {
            darticipleQueryReader.setQuery(executeSearchReqBO.getRewriteQueryStr());
        } else {
            darticipleQueryReader.setQuery(queryStr);
        }
        if (StringUtils.isNotBlank((CharSequence)executeSearchReqBO.getMinimumShouldMatch())) {
            darticipleQueryReader.setMinimum_should_match(executeSearchReqBO.getMinimumShouldMatch());
        } else {
            String minimum_should_match = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esMinMumShouldMatch;
            darticipleQueryReader.setMinimum_should_match(minimum_should_match);
        }
        String min_score = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esMinScore;
        darticipleQueryReader.setMin_score(Double.valueOf(min_score));
        darticipleQueryReader.setProperties(executeSearchReqBO.getProperties());
        if (StringUtils.isNotBlank((CharSequence)executeSearchReqBO.getProperties()) && executeSearchReqBO.getProperties().split("\\*~~").length == 2) {
            darticipleQueryReader.setModel(executeSearchReqBO.getProperties().split("\\*~~")[1].split("\n")[0]);
        }
        ArrayList shouldList = null;
        if (executeSearchReqBO.getShouldList() != null && !executeSearchReqBO.getShouldList().isEmpty()) {
            shouldList = new ArrayList(executeSearchReqBO.getShouldList());
            Iterator iterator = shouldList.iterator();
            HashMap shouldMap = new HashMap();
            HashMap termsShouldMap = new HashMap();
            while (iterator.hasNext()) {
                String groupBy;
                SeShouldBO shouldBO = (SeShouldBO)iterator.next();
                if (!Boolean.TRUE.equals(shouldBO.getIsMerge())) continue;
                if (Boolean.TRUE.equals(shouldBO.getIsWildcard())) {
                    String groupBy2;
                    if (CollectionUtils.isEmpty((Collection)shouldBO.getValueList())) continue;
                    String string = groupBy2 = StringUtils.isBlank((CharSequence)shouldBO.getGroupBy()) ? "default" : shouldBO.getGroupBy();
                    if (!shouldMap.containsKey(groupBy2)) {
                        HashMap hashMap = new HashMap();
                        shouldMap.put(groupBy2, hashMap);
                    }
                    ((Map)shouldMap.get(groupBy2)).put(shouldBO.getName(), "*" + (String)shouldBO.getValueList().get(0) + "*");
                    iterator.remove();
                    continue;
                }
                if (CollectionUtils.isEmpty((Collection)shouldBO.getValueList())) continue;
                String string = groupBy = StringUtils.isBlank((CharSequence)shouldBO.getGroupBy()) ? "default" : shouldBO.getGroupBy();
                if (!termsShouldMap.containsKey(groupBy)) {
                    ArrayList arrayList = new ArrayList();
                    termsShouldMap.put(groupBy, arrayList);
                }
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("boost", (Object)darticipleQueryReader.getBoost());
                jSONObject.put(shouldBO.getName(), (Object)shouldBO.getValueList());
                ((List)termsShouldMap.get(groupBy)).add(jSONObject);
                iterator.remove();
            }
            darticipleQueryReader.setShouldMap(shouldMap);
            darticipleQueryReader.setTermsShouldMap(termsShouldMap);
        }
        darticipleQueryReader.setShouldList(shouldList);
        if (executeSearchReqBO.getCheckBlankCollapse().booleanValue()) {
            darticipleQueryReader.setIsCollapse(executeSearchReqBO.getCheckBlankCollapse());
        } else {
            String collapse = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).searchIsAccordingCommodity;
            boolean isCollapse = collapse != null && collapse.equals("1");
            darticipleQueryReader.setIsCollapse(Boolean.valueOf(isCollapse));
        }
        if (StringUtils.isBlank((CharSequence)executeSearchReqBO.getQueryStr()) && Boolean.FALSE.equals(executeSearchReqBO.getCloseNeedQuery()) && (Objects.equals(queryFilterListNeedEmpty = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esSeedQueryFilterListNeedEmpty, "1") || CollectionUtils.isEmpty((Collection)executeSearchReqBO.getQueryFilterList()) && CollectionUtils.isEmpty((Collection)executeSearchReqBO.getQueryPropertyList()))) {
            String seed_score = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esSeedScore;
            String seed_field = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).esSeedField;
            darticipleQueryReader.setBound(Integer.valueOf(seed_score));
            darticipleQueryReader.setField(seed_field);
        }
        if (Objects.equals(channelPriorityRecallEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)executeSearchReqBO.getSeChannelType())).searchChannelPriorityRecallEnable, "1")) {
            List channelNameShardDefaultList = executeSearchReqBO.getMustTermsList().stream().filter(seTermsBO -> "channel_id".equals(seTermsBO.getName())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(channelNameShardDefaultList)) {
                String chanNameShards = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)executeSearchReqBO.getSeChannelType())).searchSortChannelNameSort;
                if (StringUtils.isNotBlank((CharSequence)chanNameShards)) {
                    List channelNameShardList = Arrays.stream(chanNameShards.split(",")).collect(Collectors.toList());
                    darticipleQueryReader.setChannelNameShardList(channelNameShardList);
                    darticipleQueryReader.setChannelNameShardDefaultList(channelNameShardDefaultList);
                    String channelPriorityRecallBoost = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)executeSearchReqBO.getSeChannelType())).searchChannelPriorityRecallBoost;
                    darticipleQueryReader.setChannelNameShardBoost(Double.valueOf(channelPriorityRecallBoost));
                    log.info("{}{}\u5185\u90e8\u9891\u9053\u4f18\u5148\u53ec\u56de:{}{}", new Object[]{">>>\u67e5\u8be2\u53ec\u56de", ">>>LIST>>>", ">>>", JSONArray.toJSONString(channelNameShardList)});
                }
            } else {
                log.info("{}{}\u672a\u6307\u5b9a\u9891\u9053\uff0c\u4e0d\u8fdb\u884c\u5185\u90e8\u9891\u9053\u4f18\u5148\u53ec\u56de\uff01", (Object)">>>\u67e5\u8be2\u53ec\u56de", (Object)">>>TXT>>>");
            }
        }
        if (Objects.equals(propertiesUnion = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).searchEsRecallPropertiesUnion, "1")) {
            darticipleQueryReader.setPropertiesUnion(Boolean.TRUE);
        }
        if (Objects.equals(isOpenBansRule = ((SearchProcessConfig.ReCallConfig)this.searchProcessConfig.getReCall().get((Object)executeSearchReqBO.getSeChannelType())).isOpenBansRule, "1")) {
            darticipleQueryReader.setSeRangeFilterList(executeSearchReqBO.getSeRangeFilterList());
        }
        darticipleQueryBO.init(darticipleQueryReader);
        return darticipleQueryBO;
    }

    private boolean containsName(List<SeTermsBO> tempTermsList, String name) {
        for (SeTermsBO termsBO : tempTermsList) {
            if (!termsBO.getName().contains(name)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> reduceEntityMap(Map<String, String> entityMap) {
        String common = "common";
        String lv2Category = "l2_category";
        String lv3Category = "l3_category";
        String lv4Category = "l4mg_category";
        String brand = "brand";
        String vendor = "vendor";
        if (entityMap.containsKey(brand)) {
            entityMap.remove(brand);
            return entityMap;
        }
        if (entityMap.containsKey(vendor)) {
            entityMap.remove(vendor);
            return entityMap;
        }
        if (entityMap.containsKey(lv4Category)) {
            entityMap.remove(lv4Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv3Category)) {
            entityMap.remove(lv3Category);
            return entityMap;
        }
        if (entityMap.containsKey(lv2Category)) {
            entityMap.remove(lv2Category);
            return entityMap;
        }
        entityMap = new HashMap<String, String>();
        entityMap.put(common, "");
        return entityMap;
    }

    private boolean queryAgain(SeEsResultBO esResultBO, Map<String, String> entityMap) {
        if (esResultBO != null && esResultBO.getHits() != null && esResultBO.getHits().getTotal().getValue() == 0) {
            return entityMap != null && entityMap.size() > 1;
        }
        return false;
    }

    private String parseContent(DarticipleQueryBO darticipleQueryBO) {
        String content = JSON.toJSONString((Object)darticipleQueryBO);
        return content;
    }

    private String parseContentAccurateQueryBO(AccurateQueryBO accurateQueryBO) {
        String content = JSON.toJSONString((Object)accurateQueryBO);
        return content;
    }

    public String sendPost(String esQueryBody) {
        String resultCode = "";
        try {
            Long startTime = System.currentTimeMillis();
            String INDEX_NAME = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
            String url = new StringBuffer().append("http://").append(this.ADDRESSES).append("/").append(INDEX_NAME).append("/_search").toString();
            RegistryBuilder registryBuilder = RegistryBuilder.create();
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContext sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, (TrustStrategy)new AnyTrustStrategy()).build();
            SSLConnectionSocketFactory sslSF = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Registry socketFactoryRegistry = registryBuilder.register("https", (Object)sslSF).register("http", (Object)new PlainConnectionSocketFactory()).build();
            try (PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);){
                HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager);
                CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
                HttpPost httpPost = new HttpPost(url);
                StringEntity uefEntity = new StringEntity(esQueryBody, "UTF-8");
                uefEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)uefEntity);
                CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                if (response != null) {
                    if (200 != response.getStatusLine().getStatusCode()) {
                        resultCode = "";
                    } else {
                        HttpEntity entity = response.getEntity();
                        resultCode = entity != null ? EntityUtils.toString((HttpEntity)entity, (String)"UTF-8") : "";
                        EntityUtils.consume((HttpEntity)entity);
                        response.close();
                    }
                } else {
                    resultCode = "";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Long endTime = System.currentTimeMillis();
            log.info("\u672c\u6b21es\u67e5\u8be2\u82b1\u8d39\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms\uff0cesQueryBody:" + esQueryBody);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return resultCode;
    }

    public String postEsAnalyze(AnalysisEsAnalyzeQueryBO analysisEsAnalyzeQueryBO, Long seChannelType) {
        String esQueryBody = JSON.toJSONString((Object)analysisEsAnalyzeQueryBO);
        String INDEX_NAME = this.cacheClient.hget("{SEARCH}_INDEX", "indexEsSkuName");
        List esIndices = this.esIndexMapper.queryBySeChannelType(seChannelType);
        for (EsIndex esIndex : esIndices) {
            if (esIndex.getFlag() != 0 || esIndex.getiType() != ToOdpsCommConstant.esType.TYPE_2) continue;
            INDEX_NAME = esIndex.getIndexSName();
        }
        String esResult = this.elasticsearchUtil.postEsAnalyze(INDEX_NAME, esQueryBody);
        return esResult;
    }
}

