/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.normalized.impl;

import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.normalized.TokensMatchIndexService;
import com.tydic.se.search.normalized.bo.TokensMatchIndexReqBO;
import com.tydic.se.search.normalized.bo.TokensMatchIndexRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTokensMatchIndexService<T>
implements TokensMatchIndexService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTokensMatchIndexService.class);
    protected String fields = "";

    public TokensMatchIndexRspBO match(TokensMatchIndexReqBO reqBO, Long seChannelType) {
        TokensMatchIndexRspBO rspBO = new TokensMatchIndexRspBO();
        ArrayList matchResultBos = new ArrayList();
        rspBO.setMatchBos(matchResultBos);
        try {
            if (seChannelType == null) {
                seChannelType = 1L;
            }
            Long finalSeChannelType = seChannelType;
            reqBO.getRows().forEach(analyzerTokensBo -> {
                Map<Long, Map<String, String>> channelCacheMap = SeEntityCache.getEntityCacheMap().get(this.fields);
                Map<String, String> cacheMap = channelCacheMap != null ? channelCacheMap.get(finalSeChannelType) : null;
                Map<String, String> maps = AbstractTokensMatchIndexService.parseMapForFilter(cacheMap, analyzerTokensBo.getToken());
                this.constructListBos(maps, matchResultBos);
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static Map<String, String> parseMapForFilter(Map<String, String> map, String filters) {
        if (map == null) {
            return null;
        }
        map = map.entrySet().stream().filter(e -> AbstractTokensMatchIndexService.checkKey((String)e.getKey(), filters)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return map;
    }

    private static boolean checkKey(String key, String filters) {
        return key.contains(filters);
    }

    abstract void constructListBos(Map<String, String> var1, List<T> var2);
}

