/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.ExecuteSearchReqBO;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeEsbVendorBo;
import com.tydic.se.base.ability.bo.SeQueryFilterBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.base.util.ExecutorProcessPool;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.QueryAnalysisSingleAtomService;
import com.tydic.se.search.sort.SearchCommodityBaseService;
import com.tydic.se.search.sort.bo.QueryAnalysisReqBO;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.enumType.SpecifySortFilterEnum;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepCheckAreaLimitRecallService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepGetNewStockByIdRecallService;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SearchCommodityBaseServiceImpl
implements SearchCommodityBaseService {
    private static final Logger log = LoggerFactory.getLogger(SearchCommodityBaseServiceImpl.class);
    @Autowired
    private QueryAnalysisSingleAtomService queryAnalysisSingleService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Qualifier(value="esbSearchExecutorService")
    @Autowired
    private ExecutorService esbSearchExecutorService;
    @Autowired
    private SearchStepCheckAreaLimitRecallService searchStepCheckAreaLimitRecallService;
    @Autowired
    private SearchStepGetNewStockByIdRecallService searchStepGetNewStockByIdRecallService;

    public Boolean judgeRedisUse(SearchSortMsgBo searchSortMsgBo) {
        return null;
    }

    public SearchSortMsgBo initParameter(SeSearchReqBO reqBO) {
        SearchSortMsgBo searchSortMsgBo = new SearchSortMsgBo();
        searchSortMsgBo.setSeChannelType(reqBO.getSeChannelType());
        StringBuilder redisCatalogCache = new StringBuilder();
        try {
            String tmp = this.cacheClient.hget("{SEARCH}_GUIDE_CATALOG_CACHE", reqBO.getQueryStr());
            redisCatalogCache.append(ObjectUtils.isEmpty((Object)tmp) ? "" : tmp.toString());
            searchSortMsgBo.setRedisEnabled(Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("redis\u8fde\u63a5\u5931\u8d25\uff01\uff01\uff01\uff0c\u641c\u7d22\u653e\u5f03\u4f7f\u7528redis!!!  " + e.getMessage());
            searchSortMsgBo.setRedisEnabled(Boolean.FALSE);
        }
        Map catalogAndOrderMap = null;
        if (!StringUtils.isBlank((CharSequence)redisCatalogCache.toString())) {
            catalogAndOrderMap = (Map)JSON.parseObject((String)redisCatalogCache.toString(), (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
        }
        searchSortMsgBo.setCatalogAndOrderMap((Map)(CollectionUtils.isEmpty(catalogAndOrderMap) ? new LinkedHashMap() : catalogAndOrderMap));
        if (reqBO.getProvince() != null) {
            searchSortMsgBo.setProvince(reqBO.getProvince());
        }
        if (reqBO.getCity() != null) {
            searchSortMsgBo.setCity(reqBO.getCity());
        }
        if (reqBO.getCounty() != null) {
            searchSortMsgBo.setCounty(reqBO.getCounty());
        }
        if (reqBO.getTown() != null) {
            searchSortMsgBo.setTown(reqBO.getTown());
        }
        searchSortMsgBo.setQueryStr(reqBO.getQueryStr().trim());
        searchSortMsgBo.setSessionId(StringUtils.isEmpty((CharSequence)reqBO.getQryToken()) ? "null" : reqBO.getQryToken());
        String segLength = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBO.getSeChannelType())).searchSortSegLength;
        searchSortMsgBo.setCutLen(Integer.parseInt(segLength));
        searchSortMsgBo.setPageNo(reqBO.getPageNo());
        searchSortMsgBo.setPageSize(reqBO.getPageSize());
        searchSortMsgBo.setQueryStrParticiple(this.getParticiple(reqBO.getQueryStr(), reqBO.getSeChannelType()));
        searchSortMsgBo.setSessionIdKey(SearchSortUtils.sessionKeyFormat((SearchSortMsgBo)searchSortMsgBo));
        searchSortMsgBo.setSessionIdKeyBlurry(SearchSortUtils.sessionKeyFormatBlurry((SearchSortMsgBo)searchSortMsgBo));
        searchSortMsgBo.setComSortList(CollectionUtils.isEmpty((Collection)reqBO.getComSortList()) ? new LinkedList() : reqBO.getComSortList());
        if (searchSortMsgBo.getComSortList().size() == 1 && Boolean.TRUE.equals(SearchStepRelevanceUtil.doesFieldExist(SeQuerySkuBO.class, ((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn()))) {
            searchSortMsgBo.setSpecifySort(Boolean.TRUE);
        }
        searchSortMsgBo.setQueryFilterList(CollectionUtils.isEmpty((Collection)reqBO.getQueryFilterList()) ? new LinkedList() : reqBO.getQueryFilterList());
        searchSortMsgBo.setQueryPropertyList(CollectionUtils.isEmpty((Collection)reqBO.getQueryPropertyList()) ? new LinkedList() : reqBO.getQueryPropertyList());
        try {
            if (reqBO.getMinSalePrice() != null || reqBO.getMaxSalePrice() != null) {
                BigDecimal min = new BigDecimal(String.valueOf(ObjectUtils.isEmpty((Object)reqBO.getMinSalePrice()) ? "0" : reqBO.getMinSalePrice()));
                BigDecimal max = new BigDecimal(String.valueOf(ObjectUtils.isEmpty((Object)reqBO.getMaxSalePrice()) ? "0" : reqBO.getMaxSalePrice()));
                searchSortMsgBo.setMinSalesPrice(min);
                searchSortMsgBo.setMaxSalesPrice(max);
                if (min.compareTo(max) == 0 && min.compareTo(new BigDecimal(0)) == 0) {
                    searchSortMsgBo.setSalesPriceJudge(Boolean.FALSE.booleanValue());
                } else {
                    searchSortMsgBo.setSalesPriceJudge(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            searchSortMsgBo.setSalesPriceJudge(false);
        }
        searchSortMsgBo.setGuideCatalogCache(CollectionUtils.isEmpty((Collection)reqBO.getGuideCatalogCache()) ? new LinkedList() : reqBO.getGuideCatalogCache());
        searchSortMsgBo.setSessionIdKeySet(new HashSet());
        log.info("{}{}\u6392\u5e8f\u521d\u59cb\u5316\u5165\u53c2{}{}", new Object[]{">>>\u7279\u5f81\u6392\u5e8f", ">>>JSON>>>", ">>>", JSON.toJSONString((Object)searchSortMsgBo)});
        return searchSortMsgBo;
    }

    public SearchSortMsgBo initParameterCategory(ExecuteSearchReqBO executeSearchReqBO) {
        SearchSortMsgBo searchSortMsgBo = new SearchSortMsgBo();
        searchSortMsgBo.setQueryStr(executeSearchReqBO.getQueryStr());
        searchSortMsgBo.setQueryStrParticiple(this.getParticiple(executeSearchReqBO.getQueryStr(), executeSearchReqBO.getSeChannelType()));
        searchSortMsgBo.setSeChannelType(executeSearchReqBO.getSeChannelType());
        return searchSortMsgBo;
    }

    public List<String> getParticiple(String queryStr, Long seChannelType) throws SearchSortException {
        try {
            QueryAnalysisReqBO queryAnalysisReqBO = new QueryAnalysisReqBO();
            queryAnalysisReqBO.setQueryConditions(queryStr);
            return this.queryAnalysisSingleService.getQueryAnalysisParticiple(queryAnalysisReqBO, seChannelType);
        }
        catch (SearchSortException e) {
            log.error("{}{}{}", new Object[]{"9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", e.getMessage()});
            throw new SearchSortException("9999", "\u5206\u8bcd\u83b7\u53d6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public Boolean cacheJudgeExist(SearchSortMsgBo searchSortMsgBo) throws SearchSortException {
        String sessionIdKeyBlurry = searchSortMsgBo.getSessionIdKeyBlurry();
        log.info("\u67e5\u8be2\u7f13\u5b58\u6765\u4e86");
        try {
            if (StringUtils.isEmpty((CharSequence)sessionIdKeyBlurry) || CollectionUtils.isEmpty((Collection)searchSortMsgBo.getSessionIdKeySet())) {
                log.info("\u77ed\u65f6\u95f4\u5185\u67e5\u8be2redis\u65e0\u7f13\u5b58,\u8fdb\u884c\u67e5\u8be2\u5e76\u6392\u5e8f\uff01");
                return true;
            }
            log.info("\u77ed\u65f6\u95f4\u5185\u67e5\u8be2redis\u6709\u7f13\u5b58\uff0c\u76f4\u63a5\u6392\u5e8f\uff01");
            return false;
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58\u62a5\u9519\uff1a" + e.getMessage());
            return true;
        }
    }

    public SeSearchRspBO attributeAggr(SeSearchRspBO searchEsRspBo) throws SearchSortException {
        return searchEsRspBo;
    }

    public SeSearchRspBO propertiesAttributeAggr(SeSearchRspBO searchEsRspBo) throws SearchSortException {
        return searchEsRspBo;
    }

    private SeQueryFilterBO encapsulation(SpecifySortFilterEnum specifySortFilterEnum) {
        SeQueryFilterBO seQueryFilterBO = new SeQueryFilterBO();
        seQueryFilterBO.setFilterId(specifySortFilterEnum.getDesc());
        seQueryFilterBO.setFilterName(specifySortFilterEnum.getFilterName());
        seQueryFilterBO.setFilterValues(new LinkedList());
        return seQueryFilterBO;
    }

    public void supplierNotSupport(SeSearchReqBO reqBo, SeSearchRspBO rspBo) {
        try {
            String supplierNotSupport = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBo.getSeChannelType())).searchRecallSupplierNotSupport;
            if (Objects.equals(supplierNotSupport, "0")) {
                return;
            }
            ArrayList getNewStockByIdSkuIdList = new ArrayList();
            LinkedList checkAreaLimitSkuIdList = new LinkedList();
            AtomicReference<Boolean> getNewStockByIdSkip = new AtomicReference<Boolean>(Boolean.TRUE);
            AtomicReference<Boolean> checkAreaLimitSkip = new AtomicReference<Boolean>(Boolean.TRUE);
            CountDownLatch countDownLatch = new CountDownLatch(2);
            String getNewStockById = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBo.getSeChannelType())).searchRecallGetNewStockById;
            Runnable getNewStockByIdRun = () -> {
                try {
                    List<SeEsbVendorBo> esbVendorBoList = reqBo.getEsbVendorBoList();
                    if (Boolean.FALSE.equals(reqBo.getGetNewStockById()) && !CollectionUtils.isEmpty((Collection)esbVendorBoList)) {
                        esbVendorBoList = esbVendorBoList.stream().filter(seEsbVendorBo -> Boolean.TRUE.equals(seEsbVendorBo.getGetNewStockById())).collect(Collectors.toList());
                    }
                    if (Objects.equals(getNewStockById, "1") && !CollectionUtils.isEmpty((Collection)esbVendorBoList)) {
                        getNewStockByIdSkip.set(Boolean.FALSE);
                        this.searchStepGetNewStockByIdRecallService.getNewStockByIdRecall(reqBo, rspBo, getNewStockByIdSkuIdList, esbVendorBoList);
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThreadNoLog(getNewStockByIdRun, this.esbSearchExecutorService);
            String checkAreaLimit = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)reqBo.getSeChannelType())).searchRecallCheckAreaLimit;
            Runnable checkAreaLimitRun = () -> {
                try {
                    List<SeEsbVendorBo> esbVendorBoList = reqBo.getEsbVendorBoList();
                    if (Boolean.FALSE.equals(reqBo.getCheckAreaLimit()) && !CollectionUtils.isEmpty((Collection)esbVendorBoList)) {
                        esbVendorBoList = esbVendorBoList.stream().filter(seEsbVendorBo -> Boolean.TRUE.equals(seEsbVendorBo.getCheckAreaLimit())).collect(Collectors.toList());
                    }
                    if (Objects.equals(checkAreaLimit, "1") && !CollectionUtils.isEmpty((Collection)esbVendorBoList)) {
                        checkAreaLimitSkip.set(Boolean.FALSE);
                        this.searchStepCheckAreaLimitRecallService.checkAreaLimitRecall(reqBo, rspBo, checkAreaLimitSkuIdList, esbVendorBoList);
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
            };
            ExecutorProcessPool.getInstance().executeByCustomThreadNoLog(checkAreaLimitRun, this.esbSearchExecutorService);
            countDownLatch.await();
            List skuList = rspBo.getSkuList();
            int allSku = skuList.size();
            skuList = skuList.stream().filter(bo -> !(!Boolean.TRUE.equals(getNewStockByIdSkip.get()) && !getNewStockByIdSkuIdList.contains(bo.getExtSkuId()) || !Boolean.TRUE.equals(checkAreaLimitSkip.get()) && !checkAreaLimitSkuIdList.contains(bo.getExtSkuId()))).collect(Collectors.toList());
            if (Boolean.FALSE.equals(getNewStockByIdSkip.get())) {
                log.info("\u5b9e\u65f6\u6570\u636e\u5224\u65ad,\u6709\u8d27/\u65e0\u8d27\u6ee1\u8db3\uff1a{}", (Object)getNewStockByIdSkuIdList.size());
            }
            if (Boolean.FALSE.equals(checkAreaLimitSkip.get())) {
                log.info("\u5b9e\u65f6\u6570\u636e\u5224\u65ad,\u533a\u57df\u9650\u5236\u6ee1\u8db3\uff1a{}", (Object)checkAreaLimitSkuIdList.size());
            }
            log.info("\u5b9e\u65f6\u6570\u636e\u5224\u65ad,\u8fc7\u6ee4\u5546\u54c1\u6570\u91cf\uff1a{}\uff0c\u6ee1\u8db3\u6570\u91cf\uff1a{}", (Object)(allSku - skuList.size()), (Object)skuList.size());
            rspBo.setSkuList(skuList);
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u4f9b\u5e94\u5546\u6570\u636e\u6821\u9a8c\u5f02\u5e38\uff01", e});
        }
    }

    public List<SeQuerySkuBO> supplierNotSupportCategory(ExecuteSearchReqBO executeSearchReqBo, List<SeQuerySkuBO> skuList) {
        SeSearchReqBO reqBo = new SeSearchReqBO();
        SeSearchRspBO rspBo = new SeSearchRspBO();
        reqBo.setEsbVendorBoList(executeSearchReqBo.getEsbVendorBoList());
        reqBo.setQueryStr(executeSearchReqBo.getQueryStr());
        reqBo.setCounty(executeSearchReqBo.getCounty());
        reqBo.setCity(executeSearchReqBo.getCity());
        reqBo.setProvince(executeSearchReqBo.getProvince());
        reqBo.setTown(executeSearchReqBo.getTown());
        reqBo.setGetNewStockById(executeSearchReqBo.getGetNewStockById());
        reqBo.setCheckAreaLimit(executeSearchReqBo.getCheckAreaLimit());
        rspBo.setSkuList(skuList);
        this.supplierNotSupport(reqBo, rspBo);
        return rspBo.getSkuList();
    }
}

