/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.impl.steps.api.SearchStepInternalShardByChannelListService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepPrioritySimilarProductsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchStepInternalShardByChannelListServiceImpl
implements SearchStepInternalShardByChannelListService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepInternalShardByChannelListServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepPrioritySimilarProductsService searchStepPrioritySimilarProductsService;

    @Override
    @SearchLinkLog(desc="\u5185\u90e8\u9891\u9053\u8c03\u6574")
    public List<SeQuerySkuBO> internalShardByChannelList(Map<String, List<SeQuerySkuBO>> scopeSkuListMap, Long seChannelType) {
        LinkedList<SeQuerySkuBO> internal = new LinkedList<SeQuerySkuBO>();
        String channelNameShards = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortChannelNameSort;
        List<String> channelNameShardList = Arrays.stream(channelNameShards.split(",")).collect(Collectors.toList());
        log.info("{}{}\u5185\u90e8\u9891\u9053\u8c03\u6574{}{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>LIST>>>", ">>>", JSONArray.toJSONString(channelNameShardList)});
        for (Map.Entry<String, List<SeQuerySkuBO>> scope : scopeSkuListMap.entrySet()) {
            List<SeQuerySkuBO> scopeSort = scope.getValue().stream().sorted(Comparator.comparing(DycProEsIndexMappingSkuBO::getSalePrice)).collect(Collectors.toList());
            String channelInternal = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortChannelInternal;
            if (Objects.equals(channelInternal, "1") && !CollectionUtils.isEmpty(scopeSort) && !CollectionUtils.isEmpty(channelNameShardList)) {
                scopeSort = this.internalShardByChannel(scopeSort, channelNameShardList, seChannelType);
            }
            internal.addAll(scopeSort);
        }
        return internal;
    }

    private List<SeQuerySkuBO> internalShardByChannel(List<SeQuerySkuBO> scopeSort, List<String> channelNameShardList, Long seChannelType) {
        int cursor = 0;
        LinkedList<SeQuerySkuBO> afterProcessingScopeSort = new LinkedList<SeQuerySkuBO>();
        String channelInternalShard = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortChannelShard;
        int channelShard = scopeSort.size() < Integer.parseInt(channelInternalShard) ? 1 : Integer.parseInt(channelInternalShard);
        for (int index = 1; index <= channelShard; ++index) {
            LinkedHashMap<String, List<SeQuerySkuBO>> preferredChannelMap = new LinkedHashMap<String, List<SeQuerySkuBO>>();
            LinkedList<SeQuerySkuBO> othersChannel = new LinkedList<SeQuerySkuBO>();
            ArrayList<Long> judgePreferredSkuIds = new ArrayList<Long>();
            int cursorEnd = scopeSort.size() / channelShard * index;
            if (cursorEnd != scopeSort.size() && scopeSort.size() / channelShard * (index + 1) > scopeSort.size()) {
                cursorEnd = scopeSort.size();
            } else if (channelShard == index && scopeSort.size() / channelShard * (index + 1) == scopeSort.size()) {
                cursorEnd = scopeSort.size();
            }
            while (cursor < cursorEnd) {
                SeQuerySkuBO cursorSkuBo = scopeSort.get(cursor);
                for (String string : channelNameShardList) {
                    List channelNames = cursorSkuBo.getChannelName();
                    if (!CollectionUtils.isEmpty((Collection)channelNames) && channelNames.contains(string)) {
                        if (!preferredChannelMap.containsKey(string)) {
                            preferredChannelMap.put(string, new LinkedList());
                        }
                        ((List)preferredChannelMap.get(string)).add(cursorSkuBo);
                        judgePreferredSkuIds.add(cursorSkuBo.getSkuId());
                        continue;
                    }
                    if (othersChannel.contains(cursorSkuBo) || judgePreferredSkuIds.contains(cursorSkuBo.getSkuId())) continue;
                    othersChannel.add(cursorSkuBo);
                }
                ++cursor;
            }
            String sameSkuCountInternal = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortSmoothingInternalSameSkuCount;
            if (Objects.equals(sameSkuCountInternal, "1")) {
                this.searchStepPrioritySimilarProductsService.prioritySimilarProducts(preferredChannelMap, othersChannel);
            }
            for (Map.Entry entry : preferredChannelMap.entrySet()) {
                for (SeQuerySkuBO seQuerySkuBO : (List)entry.getValue()) {
                    if (afterProcessingScopeSort.contains(seQuerySkuBO)) continue;
                    afterProcessingScopeSort.add(seQuerySkuBO);
                }
            }
            for (SeQuerySkuBO seQuerySkuBO : othersChannel) {
                if (afterProcessingScopeSort.contains(seQuerySkuBO)) continue;
                afterProcessingScopeSort.add(seQuerySkuBO);
            }
        }
        return afterProcessingScopeSort;
    }
}

