/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceCorrelationDataService;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepRelevanceCorrelationDataServiceImpl
implements SearchStepRelevanceCorrelationDataService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceCorrelationDataServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    public List<Map<String, Map<String, Object>>> correlationData(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        LinkedList<Map<String, Map<String, Object>>> list = new LinkedList<Map<String, Map<String, Object>>>();
        for (String name : searchSortMsgBo.getQueryStrParticiple()) {
            char[] chars;
            LinkedHashMap map = new LinkedHashMap();
            LinkedHashMap<String, Object> detail = new LinkedHashMap<String, Object>();
            detail.put("weight", 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size());
            String synonymEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSynonymEnable;
            if (Objects.equals(synonymEnable, "1")) {
                String synonym = this.cacheClient.hget("{SEARCH}_SYNONYM_WORD", name);
                detail.put("synonym", synonym);
                String synonymDisplay = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSynonymDisplay;
                if (!ObjectUtils.isEmpty((Object)rspBo) && Objects.equals(synonymDisplay, "1") && !ObjectUtils.isEmpty((Object)synonym)) {
                    rspBo.getSynonymMap().put("Synonym{" + name + "}", synonym.toString());
                }
            }
            map.put(name, detail);
            for (char c : chars = name.toCharArray()) {
                String ch = String.valueOf(c);
                LinkedHashMap<String, Object> charDetail = new LinkedHashMap<String, Object>();
                String bitwiseCorrelationWeight = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortBitwiseCorrelationWeight;
                charDetail.put("weight", 1.0 / (double)searchSortMsgBo.getQueryStrParticiple().size() * Double.parseDouble(bitwiseCorrelationWeight) / (double)chars.length);
                if (Objects.equals(synonymEnable, "1")) {
                    String chSynonym = this.cacheClient.hget("{SEARCH}_SYNONYM_WORD", name);
                    charDetail.put("synonym", chSynonym);
                    String synonymDisplay = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSynonymDisplay;
                    if (!ObjectUtils.isEmpty((Object)rspBo) && Objects.equals(synonymDisplay, "1") && !ObjectUtils.isEmpty((Object)chSynonym)) {
                        rspBo.getSynonymMap().put("Synonym[" + ch + "]", chSynonym.toString());
                    }
                }
                map.put(ch, charDetail);
            }
            list.add(map);
        }
        return list;
    }
}

