/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSONArray;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.nlp.api.SearchAnalysisService;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchCategoryRelevanceBo;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceBaseService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceCorrelationDataService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceRelevantWeighService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceWeightService;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import com.tydic.se.search.util.SearchSortUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepRelevanceServiceImpl
implements SearchStepRelevanceService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepRelevanceBaseService searchStepRelevanceBaseService;
    @Autowired
    private SearchStepRelevanceCorrelationDataService searchStepRelevanceCorrelationDataService;
    @Autowired
    private SearchStepRelevanceRelevantWeighService searchStepRelevanceRelevantWeighService;
    @Autowired
    private SearchStepRelevanceWeightService searchStepRelevanceWeightService;
    @Autowired
    private SearchAnalysisService searchAnalysisService;
    public static final String PROP_SEPA = "*~~";

    private void calculationByWeightWay(List<Map<String, Map<String, Object>>> splitData, SeQuerySkuBO seQuerySkuBo, SearchSortMsgBo searchSortMsgBo) {
        if (((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortWeightWay.equals("relevantWeigh")) {
            this.searchStepRelevanceRelevantWeighService.relevantWeigh(splitData, seQuerySkuBo, searchSortMsgBo);
        } else {
            this.searchStepRelevanceWeightService.weigh(splitData, seQuerySkuBo, searchSortMsgBo);
        }
    }

    @Override
    @SearchLinkLog(desc="\u76f8\u5173\u6027\u6392\u5e8f")
    public void relevance(SeSearchRspBO rspBo, SearchSortMsgBo searchSortMsgBo) {
        List<SeQuerySkuBO> relatedPass = new LinkedList<SeQuerySkuBO>();
        List<SeQuerySkuBO> related = new LinkedList<SeQuerySkuBO>();
        LinkedList irrelevant = new LinkedList();
        List<SeQuerySkuBO> seQuerySkuBOList = rspBo.getSkuList();
        TreeMap map = new TreeMap(Comparator.reverseOrder());
        List<Map<String, Map<String, Object>>> splitData = this.searchStepRelevanceCorrelationDataService.correlationData(rspBo, searchSortMsgBo);
        log.info("{}{}\u76f8\u5173\u6027\u5339\u914d\u62c6\u5206\u6570\u636e{}{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>LIST>>>", ">>>", JSONArray.toJSONString(splitData)});
        seQuerySkuBOList.forEach(seQuerySkuBo -> {
            this.calculationByWeightWay(splitData, (SeQuerySkuBO)seQuerySkuBo, searchSortMsgBo);
            double flag = seQuerySkuBo.getWeight();
            if (this.searchStepRelevanceBaseService.getIrrelevantRatioLowest(searchSortMsgBo.getQueryStr(), flag, searchSortMsgBo.getSeChannelType()).booleanValue()) {
                irrelevant.add(seQuerySkuBo);
            } else {
                this.searchStepRelevanceBaseService.manualInterventionWeigh((SeQuerySkuBO)seQuerySkuBo, searchSortMsgBo);
                flag = seQuerySkuBo.getWeight();
                if (!map.containsKey(flag)) {
                    map.put(flag, new LinkedList());
                }
                ((List)map.get(flag)).add(seQuerySkuBo);
                if (searchSortMsgBo.getSkuNumMinLength() > seQuerySkuBo.getSkuName().length()) {
                    searchSortMsgBo.setSkuNumMinLength(Integer.valueOf(seQuerySkuBo.getSkuName().length()));
                }
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            if (this.searchStepRelevanceBaseService.getIrrelevantRatioPass((Double)entry.getKey(), searchSortMsgBo.getSeChannelType()).booleanValue()) {
                relatedPass.addAll((Collection)entry.getValue());
                continue;
            }
            related.addAll((Collection)entry.getValue());
        }
        String followedBySynonyms = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSynonymFollowedBySynonyms;
        if (Objects.equals(followedBySynonyms, "1")) {
            relatedPass = this.searchStepRelevanceBaseService.sameWeightsFollowedBySynonyms(relatedPass, searchSortMsgBo.getSeChannelType());
            related = this.searchStepRelevanceBaseService.sameWeightsFollowedBySynonyms(related, searchSortMsgBo.getSeChannelType());
        } else {
            relatedPass = this.searchStepRelevanceBaseService.weightsSynonymsLater(relatedPass);
            related = this.searchStepRelevanceBaseService.weightsSynonymsLater(related);
        }
        seQuerySkuBOList = relatedPass;
        String giveUp = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortGiveUp;
        if (Objects.equals(giveUp, "0")) {
            seQuerySkuBOList.addAll(related);
        }
        if (relatedPass.size() > 0) {
            rspBo.setQueryResultType("0");
        } else if (related.size() > 0) {
            if (Objects.equals(giveUp, "0")) {
                seQuerySkuBOList.addAll(related);
            }
            rspBo.setQueryResultType("1");
        } else {
            rspBo.setQueryResultType("2");
        }
        log.info("{}{}\u76f8\u5173\u6027\u6392\u5e8f\u5408\u683c\u6570\u636e{}\u6761\u6570\u636e\uff01", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", relatedPass.size()});
        log.info("{}{}\u76f8\u5173\u6027\u6392\u5e8f\u53ef\u80fd\u76f8\u5173\u6570\u636e{}\u6761\u6570\u636e\uff01", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", related.size()});
        log.info("{}{}\u76f8\u5173\u6027\u6392\u5e8f\u8fc7\u6ee4{}\u6761\u6570\u636e\uff01", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", irrelevant.size()});
        log.info("{}{}\u76f8\u5173\u6027\u6392\u5e8f\u67e5\u8be2\u7ed3\u679c\u7c7b\u578b:{}", new Object[]{">>>\u76f8\u5173\u6027\u6392\u5e8f", ">>>TXT>>>", rspBo.getQueryResultType()});
        rspBo.setSkuList(seQuerySkuBOList);
    }

    @Override
    public List<SeQuerySkuBO> categoryRelevanceSort(SearchCategoryRelevanceBo searchCategoryRelevanceBo) {
        if (StringUtils.isBlank((CharSequence)searchCategoryRelevanceBo.getSearchSortMsgBo().getQueryStr())) {
            return searchCategoryRelevanceBo.getSkuList();
        }
        List skuList = searchCategoryRelevanceBo.getSkuList();
        SearchSortMsgBo searchSortMsgBo = searchCategoryRelevanceBo.getSearchSortMsgBo();
        List<Map<String, Map<String, Object>>> splitData = this.searchStepRelevanceCorrelationDataService.correlationData(null, searchSortMsgBo);
        for (SeQuerySkuBO seQuerySkuBo : skuList) {
            this.calculationByWeightWay(splitData, seQuerySkuBo, searchSortMsgBo);
            this.searchStepRelevanceBaseService.manualInterventionWeigh(seQuerySkuBo, searchSortMsgBo);
        }
        return skuList.stream().sorted(Comparator.comparingDouble(SeQuerySkuBO::getWeight).reversed()).collect(Collectors.toList());
    }

    @Override
    public void categoryRelevanceFilter(SearchCategoryRelevanceBo searchCategoryRelevanceBo, Long seChannelType) {
        Map categoryFilterMap = searchCategoryRelevanceBo.getCategoryFilterMap();
        for (SeQuerySkuBO seQuerySkuBo : searchCategoryRelevanceBo.getSkuList()) {
            double skuWeight = seQuerySkuBo.getWeight();
            String giveUp = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortGiveUp;
            if (Objects.equals(giveUp, "0")) {
                String irrelevantRatioLowest = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSortIrrelevantRatioLowest;
                if (!(skuWeight >= Double.parseDouble(irrelevantRatioLowest))) continue;
                this.filterMarker(seQuerySkuBo, categoryFilterMap);
                continue;
            }
            if (!Boolean.TRUE.equals(this.searchStepRelevanceBaseService.getIrrelevantRatioPass(skuWeight, seChannelType))) continue;
            this.filterMarker(seQuerySkuBo, categoryFilterMap);
        }
    }

    private void filterMarker(SeQuerySkuBO seQuerySkuBO, Map<String, Map<String, Integer>> categoryFilterMap) {
        try {
            for (Map.Entry<String, Map<String, Integer>> entry : categoryFilterMap.entrySet()) {
                Field field;
                if (entry.getKey().contains(PROP_SEPA)) {
                    field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(SeQuerySkuBO.class, "properties");
                    String properties = (String)field.get(seQuerySkuBO);
                    if (ObjectUtils.isEmpty((Object)properties)) continue;
                    for (Map.Entry<String, Integer> singleEntry : entry.getValue().entrySet()) {
                        String single = entry.getKey() + PROP_SEPA + singleEntry.getKey();
                        if (!properties.contains(single)) continue;
                        singleEntry.setValue(1);
                    }
                    continue;
                }
                field = SeQuerySkuBO.class.getDeclaredField(SearchSortUtils.lineToHump((String)entry.getKey()));
                field.setAccessible(true);
                Object generalValue = field.get(seQuerySkuBO);
                if (ObjectUtils.isEmpty((Object)generalValue)) continue;
                block4: for (Map.Entry<String, Integer> singleEntry : entry.getValue().entrySet()) {
                    if (generalValue instanceof List) {
                        List list = SearchSortUtils.castList((Object)generalValue, Object.class);
                        for (Object obj : list) {
                            if (!String.valueOf(obj).equalsIgnoreCase(singleEntry.getKey())) continue;
                            singleEntry.setValue(1);
                            continue block4;
                        }
                        continue;
                    }
                    if (!String.valueOf(generalValue).equalsIgnoreCase(singleEntry.getKey())) continue;
                    singleEntry.setValue(1);
                }
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error("\u5c5e\u6027\u7b5b\u9009\u8fc7\u6ee4\u5f02\u5e38\uff01");
            e.printStackTrace();
        }
    }
}

