/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceSingleWordWeightService;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepRelevanceSingleWordWeightServiceImpl
implements SearchStepRelevanceSingleWordWeightService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceSingleWordWeightServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    public double singleWordWeight(SeQuerySkuBO seQuerySkuBO, String featureString, Map.Entry<String, Map<String, Object>> entry, Long seChannelType) {
        double weight = Double.parseDouble(entry.getValue().get("weight").toString());
        if (featureString.toLowerCase(Locale.ROOT).contains(entry.getKey().toLowerCase(Locale.ROOT))) {
            return weight;
        }
        String synonymEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSynonymEnable;
        if (Objects.equals(synonymEnable, "0")) {
            return 0.0;
        }
        Object synonym = entry.getValue().get("synonym");
        StringBuilder synonymCorrect = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)synonym)) {
            synonymCorrect.append(ObjectUtils.isEmpty((Object)synonym) ? "" : synonym.toString());
        }
        if (StringUtils.isBlank((CharSequence)synonymCorrect.toString())) {
            return 0.0;
        }
        CharSequence[] synonymList = synonymCorrect.toString().split(",");
        for (int i = 0; i < synonymList.length; ++i) {
            boolean exist = featureString.toLowerCase(Locale.ROOT).contains(synonymList[i].toLowerCase(Locale.ROOT));
            if (!exist) continue;
            BigDecimal decimalWeight = new BigDecimal(weight);
            String followedBySynonymsWeight = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)seChannelType)).searchSynonymFollowedBySynonymsWeight;
            BigDecimal decimalFollowedBySynonymsWeight = BigDecimal.valueOf(Double.parseDouble(followedBySynonymsWeight));
            int n = i;
            synonymList[n] = synonymList[n] + "(" + decimalWeight.multiply(decimalFollowedBySynonymsWeight) + ")";
            seQuerySkuBO.setSynonymWeightDesc(seQuerySkuBO.getSynonymWeightDesc() + (ObjectUtils.isEmpty((Object)seQuerySkuBO.getSynonymWeightDesc()) ? "" : ",") + String.join((CharSequence)",", synonymList));
            seQuerySkuBO.setSynonymWeight(Double.valueOf((ObjectUtils.isEmpty((Object)seQuerySkuBO.getSynonymWeight()) ? 0.0 : seQuerySkuBO.getSynonymWeight()) + 1.0));
            return decimalWeight.multiply(decimalFollowedBySynonymsWeight).doubleValue();
        }
        return 0.0;
    }
}

