/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.job.SeEntityCache;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.exception.SearchSortException;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceSingleWordWeightService;
import com.tydic.se.search.sort.impl.steps.api.SearchStepRelevanceWeightService;
import com.tydic.se.search.sort.impl.steps.utils.SearchStepRelevanceUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchStepRelevanceWeightServiceImpl
implements SearchStepRelevanceWeightService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepRelevanceWeightServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;
    @Autowired
    private SearchStepRelevanceSingleWordWeightService searchStepRelevanceSingleWordWeightService;

    @Override
    public void weigh(List<Map<String, Map<String, Object>>> splitData, SeQuerySkuBO seQuerySkuBO, SearchSortMsgBo searchSortMsgBo) {
        try {
            if (!searchSortMsgBo.getQueryStrParticiple().isEmpty()) {
                String chineseFieldsStr;
                AtomicReference<Double> flag = new AtomicReference<Double>(0.0);
                String fieldsStr = StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getLongAccurateFieldsStr()) ? searchSortMsgBo.getLongAccurateFieldsStr() : (String)this.searchProcessConfig.getRelevanceFieldMatching().get(searchSortMsgBo.getSeChannelType());
                String string = chineseFieldsStr = StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getAccurateFieldsStr()) ? searchSortMsgBo.getAccurateFieldsStr() : (String)this.searchProcessConfig.getRelevanceChineseFieldMatching().get(searchSortMsgBo.getSeChannelType());
                if ("null".equals(fieldsStr)) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u5339\u914d\u5b57\u6bb5\uff01");
                }
                if ("null".equals(chineseFieldsStr)) {
                    throw new Exception("\u8bf7\u914d\u7f6e\u76f8\u5173\u5ea6\u4e2d\u6587\u5339\u914d\u5b57\u6bb5\uff01");
                }
                String[] fields = fieldsStr.split(",");
                String[] chineseFields = chineseFieldsStr.split(",");
                Class<SeQuerySkuBO> clazz = SeQuerySkuBO.class;
                StringBuilder stringBuilderChinese = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                SearchStepRelevanceUtil.correlationStringPackaging(seQuerySkuBO, chineseFields, clazz, stringBuilderChinese);
                SearchStepRelevanceUtil.correlationStringPackaging(seQuerySkuBO, fields, clazz, stringBuilder);
                stringBuilder.append((CharSequence)stringBuilderChinese);
                LinkedList<String> weightDesc = new LinkedList<String>();
                seQuerySkuBO.setWeight(Double.valueOf(0.0));
                seQuerySkuBO.setSynonymWeight(Double.valueOf(0.0));
                Long seChannelType = searchSortMsgBo.getSeChannelType();
                Map<Long, Map<String, String>> matchQueryChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_MATCH_QUERY_MAPPING");
                Map<String, String> matchQueryMap = matchQueryChannelMap != null ? matchQueryChannelMap.get(seChannelType) : null;
                boolean isBrandMatchQuery = matchQueryMap != null && "0".equals(matchQueryMap.get("brand_name"));
                boolean isVenderMatchQuery = matchQueryMap != null && "0".equals(matchQueryMap.get("vendor_name"));
                Map<Long, Map<String, String>> exactMatchChannelMap = SeEntityCache.getEntityCacheMap().get("ENTITY_CACHE_EXACT_MATCH_MAPPING");
                Map<String, String> exactMatchMap = exactMatchChannelMap != null ? exactMatchChannelMap.get(seChannelType) : null;
                boolean isBrandExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("brand_name"));
                boolean isVendorExactMatch = exactMatchMap != null && "0".equals(exactMatchMap.get("vendor_name"));
                splitData.forEach(maps -> {
                    boolean judge = Boolean.TRUE;
                    for (Map.Entry<String, Map<String, Object>> entry : maps.entrySet()) {
                        double tmp = SearchStepRelevanceUtil.checkNotExistChinese(searchSortMsgBo.getQueryStr()) ? this.searchStepRelevanceSingleWordWeightService.singleWordWeight(seQuerySkuBO, stringBuilder.toString(), entry, searchSortMsgBo.getSeChannelType()) : this.searchStepRelevanceSingleWordWeightService.singleWordWeight(seQuerySkuBO, stringBuilderChinese.toString(), entry, searchSortMsgBo.getSeChannelType());
                        if (tmp != 0.0 && judge) {
                            flag.updateAndGet(v -> v + tmp);
                            weightDesc.add(entry.getKey() + ":" + entry.getValue());
                            break;
                        }
                        judge = Boolean.FALSE;
                        flag.updateAndGet(v -> v + tmp);
                        if (tmp == 0.0) continue;
                        weightDesc.add(entry.getKey() + ":" + entry.getValue());
                    }
                });
                String searchSortQuerySkuName = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortQuerySkuName;
                if (searchSortQuerySkuName.contains(",")) {
                    String[] configPairs;
                    for (String pair : configPairs = searchSortQuerySkuName.split(",")) {
                        String[] keyValue = pair.split(":");
                        if (keyValue.length != 2) continue;
                        String fieldName = keyValue[0].trim();
                        try {
                            Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(clazz, fieldName);
                            String fieldValue = field.get(seQuerySkuBO).toString().toLowerCase();
                            String queryStr = searchSortMsgBo.getQueryStr().toLowerCase();
                            BigDecimal weight = new BigDecimal(keyValue[1].trim());
                            if (!fieldValue.contains(queryStr)) continue;
                            flag.updateAndGet(v -> v + weight.doubleValue());
                            weightDesc.add("[" + fieldName + "]:" + weight);
                        }
                        catch (Exception e) {
                            weightDesc.add("[" + fieldName + "]:\u4e0d\u5b58\u5728");
                        }
                    }
                } else {
                    String queryStr;
                    Field field = SearchStepRelevanceUtil.getDeclaredFieldRecursively(clazz, ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortQuerySkuName);
                    String fieldValue = field.get(seQuerySkuBO).toString().toLowerCase();
                    if (fieldValue.contains(queryStr = searchSortMsgBo.getQueryStr().toLowerCase())) {
                        flag.updateAndGet(v -> v + 0.1);
                        weightDesc.add("[" + field.getName() + "]:" + 1.0);
                    }
                }
                if (isBrandMatchQuery && !isBrandExactMatch && StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getBrandName()) && seQuerySkuBO.getBrandName().contains(searchSortMsgBo.getQueryStr())) {
                    flag.updateAndGet(v -> v + 0.1);
                    weightDesc.add("[\u54c1\u724c\u6a21\u7cca\u5339\u914d]:1.0");
                }
                if (isVenderMatchQuery && !isVendorExactMatch && StringUtils.isNotBlank((CharSequence)searchSortMsgBo.getQueryStr()) && StringUtils.isNotBlank((CharSequence)seQuerySkuBO.getSupplierName()) && seQuerySkuBO.getSupplierName().contains(searchSortMsgBo.getQueryStr())) {
                    flag.updateAndGet(v -> v + 0.1);
                    weightDesc.add("[\u4f9b\u5e94\u5546\u6a21\u7cca\u5339\u914d]:1.0");
                }
                seQuerySkuBO.setWeightDesc(String.join((CharSequence)" , ", weightDesc));
                seQuerySkuBO.setWeight(flag.get());
            } else {
                seQuerySkuBO.setWeightDesc("\u4e0d\u8ba1\u7b97\u6743\u503c\uff01");
            }
        }
        catch (Exception e) {
            log.error("{}{}{}", new Object[]{"9999", "\u6743\u503c\u8ba1\u7b97\uff01", e});
            throw new SearchSortException("9999", "\u6743\u503c\u8ba1\u7b97\uff01", (Throwable)e);
        }
    }
}

