/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.sort.impl.steps;

import com.alibaba.fastjson.JSON;
import com.tydic.se.base.ability.bo.SeComSortBO;
import com.tydic.se.base.ability.bo.SeQuerySkuBO;
import com.tydic.se.base.ability.bo.SeSearchReqBO;
import com.tydic.se.base.ability.bo.SeSearchRspBO;
import com.tydic.se.search.annotation.SearchLinkLog;
import com.tydic.se.search.config.SearchProcessConfig;
import com.tydic.se.search.sort.bo.SearchSortMsgBo;
import com.tydic.se.search.sort.impl.steps.api.SearchStepSupplierDisruptService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class SearchStepSupplierDisruptServiceImpl
implements SearchStepSupplierDisruptService {
    private static final Logger log = LoggerFactory.getLogger(SearchStepSupplierDisruptServiceImpl.class);
    @Autowired
    private SearchProcessConfig searchProcessConfig;

    @Override
    @SearchLinkLog(desc="\u4f9b\u5e94\u5546\u6253\u4e71")
    public SeSearchRspBO supplierDisruptSorting(SeSearchRspBO baseBo, SeSearchReqBO reqBo, SearchSortMsgBo searchSortMsgBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getQueryFilterList()) && !CollectionUtils.isEmpty((Collection)reqBo.getQueryFilterList().stream().filter(bo -> "vendor_name".equals(bo.getFilterId()) && !CollectionUtils.isEmpty((Collection)bo.getFilterValues())).collect(Collectors.toList()))) {
            log.info("{}{}\u5355\u4e2a\u4f9b\u5e94\u5546\u4e0d\u8fdb\u884c\u4f9b\u5e94\u5546\u6253\u4e71\uff01", (Object)">>>\u7279\u5f81\u6392\u5e8f", (Object)">>>TXT>>>");
            return baseBo;
        }
        if (!CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList()) && searchSortMsgBo.getComSortList().size() == 1 && !"_score".equals(((SeComSortBO)searchSortMsgBo.getComSortList().get(0)).getOrderByColumn())) {
            log.info("{}{}\u6307\u5b9a\u6392\u5e8f\u4e0d\u8fdb\u884c\u4f9b\u5e94\u5546\u6253\u4e71\uff01", (Object)">>>\u7279\u5f81\u6392\u5e8f", (Object)">>>TXT>>>");
            return baseBo;
        }
        String supplierEnable = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSupplierEnable;
        if (Objects.equals(supplierEnable, "0")) {
            log.info("\u8df3\u8fc7\u4f9b\u5e94\u5546\u6253\u6563\uff01");
            return baseBo;
        }
        SeSearchRspBO rspBo = (SeSearchRspBO)JSON.parseObject((String)JSON.toJSONString((Object)baseBo), SeSearchRspBO.class);
        if (StringUtils.isBlank((String)searchSortMsgBo.getQueryStr()) && !CollectionUtils.isEmpty((Collection)searchSortMsgBo.getComSortList())) {
            log.info("\u7a7a\u641c\u5e76\u5e26\u6709\u9ed8\u8ba4\u6392\u5e8f\u5219\u4e0d\u8fdb\u884c\u4f9b\u5e94\u5546\u6253\u4e71\uff01");
            return rspBo;
        }
        try {
            String supplierDisrupt = ((SearchProcessConfig.SortConfig)this.searchProcessConfig.getSort().get((Object)searchSortMsgBo.getSeChannelType())).searchSortSupplierDisrupt;
            String[] disrupt = supplierDisrupt.split(",");
            LinkedHashMap skuWeightMap = new LinkedHashMap();
            for (SeQuerySkuBO seQuerySkuBO : rspBo.getSkuList()) {
                String weightKey = String.valueOf(seQuerySkuBO.getWeight());
                String supplierIdKey = String.valueOf(seQuerySkuBO.getSupplierId());
                Map<String, LinkedList<SeQuerySkuBO>> map = new LinkedHashMap();
                Queue<Object> list = new LinkedList<SeQuerySkuBO>();
                if (skuWeightMap.containsKey(weightKey) && (map = (Map)skuWeightMap.get(weightKey)).containsKey(supplierIdKey)) {
                    list = (Queue)map.get(supplierIdKey);
                }
                list.add(seQuerySkuBO);
                map.put(supplierIdKey, (LinkedList<SeQuerySkuBO>)list);
                skuWeightMap.put(weightKey, map);
            }
            LinkedList<SeQuerySkuBO> newSkuList = new LinkedList<SeQuerySkuBO>();
            int i = 1;
            while (i < disrupt.length) {
                int finalI = i++;
                Map disWeightMap = skuWeightMap.entrySet().stream().filter(entry -> new BigDecimal((String)entry.getKey()).compareTo(new BigDecimal(disrupt[finalI])) >= 0 && new BigDecimal((String)entry.getKey()).compareTo(new BigDecimal(disrupt[finalI - 1])) < 0).sorted(Map.Entry.comparingByKey().reversed()).collect(LinkedHashMap::new, (m, e) -> {
                    Map cfr_ignored_0 = (Map)m.put(e.getKey(), e.getValue());
                }, HashMap::putAll);
                newSkuList.addAll(this.merge(disWeightMap));
            }
            rspBo.setSkuList(newSkuList);
            return rspBo;
        }
        catch (Exception e2) {
            log.warn("Str:{} \u4f9b\u5e94\u5546\u6253\u4e71\u5f02\u5e38! ex:{}", (Object)searchSortMsgBo.getQueryStr(), (Object)e2.getMessage());
            log.error(e2.getMessage(), (Throwable)e2);
            return baseBo;
        }
    }

    private List<SeQuerySkuBO> merge(Map<String, Map<String, Queue<SeQuerySkuBO>>> disWeightMap) {
        LinkedList<SeQuerySkuBO> list = new LinkedList<SeQuerySkuBO>();
        Iterator<Map.Entry<String, Map<String, Queue<SeQuerySkuBO>>>> weightIterator = disWeightMap.entrySet().iterator();
        while (weightIterator.hasNext()) {
            Map.Entry<String, Map<String, Queue<SeQuerySkuBO>>> weightEntry = weightIterator.next();
            Iterator<Map.Entry<String, Queue<SeQuerySkuBO>>> supplierIterator = weightEntry.getValue().entrySet().iterator();
            while (supplierIterator.hasNext()) {
                Map.Entry<String, Queue<SeQuerySkuBO>> supplierEntry = supplierIterator.next();
                SeQuerySkuBO sku = supplierEntry.getValue().poll();
                if (ObjectUtils.isEmpty((Object)sku)) {
                    supplierIterator.remove();
                    continue;
                }
                list.add(sku);
            }
            if (weightEntry.getValue().size() != 0) continue;
            weightIterator.remove();
        }
        if (disWeightMap.size() != 0) {
            list.addAll(this.merge(disWeightMap));
        }
        return list;
    }
}

