/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.se.search.util;

import com.alibaba.fastjson.JSON;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonPathUtil.class);

    public static List<Object> extractData(Object jsonObject, String jsonPath) {
        if (jsonObject == null || StringUtils.isBlank((CharSequence)jsonPath)) {
            return new ArrayList<Object>();
        }
        try {
            String jsonString = JSON.toJSONString((Object)jsonObject);
            Object result = JsonPath.read((String)jsonString, (String)jsonPath, (Predicate[])new Predicate[0]);
            if (result == null) {
                return new ArrayList<Object>();
            }
            if (result instanceof List) {
                return (List)result;
            }
            ArrayList<Object> resultList = new ArrayList<Object>();
            resultList.add(result);
            return resultList;
        }
        catch (PathNotFoundException e) {
            log.debug("JSONPath\u8def\u5f84\u672a\u627e\u5230 - JSONPath: {}, \u9519\u8bef: {}", (Object)jsonPath, (Object)e.getMessage());
            return new ArrayList<Object>();
        }
        catch (Exception e) {
            log.error("JSONPath\u89e3\u6790\u5f02\u5e38 - JSONPath: {}, \u9519\u8bef: {}", new Object[]{jsonPath, e.getMessage(), e});
            return new ArrayList<Object>();
        }
    }

    public static List<String> extractStringData(Object jsonObject, String jsonPath) {
        List<Object> results = JsonPathUtil.extractData(jsonObject, jsonPath);
        ArrayList<String> stringResults = new ArrayList<String>();
        for (Object result : results) {
            if (result == null) continue;
            stringResults.add(String.valueOf(result));
        }
        return stringResults;
    }
}

