/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.client;

import com.alipay.openmeta.client.ClientOption;
import com.alipay.openmeta.client.ClientOptions;
import com.alipay.openmeta.client.OpenMetaClient;
import com.alipay.openmeta.client.RoundRobinServerSelector;
import com.alipay.openmeta.client.ServerAddressing;
import com.alipay.openmeta.client.ServerSelector;
import com.alipay.openmeta.common.SchemaDetail;
import com.alipay.openmeta.common.SchemaSummary;
import com.alipay.openmeta.data.CompatibilityConfig;
import com.alipay.openmeta.data.CompatibilityValidateRequest;
import com.alipay.openmeta.data.CompatibilityValidateResult;
import com.alipay.openmeta.data.CompleteSchemaInfo;
import com.alipay.openmeta.data.SchemaData;
import com.alipay.openmeta.data.SchemaId;
import com.alipay.openmeta.data.SubjectAndVersion;
import com.alipay.openmeta.exception.CompatibilityException;
import com.alipay.openmeta.exception.NoAvailableServerException;
import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.openmeta.exception.SubjectNotExistException;
import com.alipay.openmeta.exception.UnauthorizedException;
import com.alipay.openmeta.utils.Arguments;
import com.alipay.openmeta.utils.Converter;
import com.alipay.openmeta.utils.JsonUtils;
import com.alipay.openmeta.utils.Pair;
import com.alipay.openmeta.utils.RestfulApiPathUtils;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.TypeReference;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.HttpClient;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.methods.DeleteMethod;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.methods.GetMethod;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.methods.PostMethod;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.methods.PutMethod;
import com.alipay.sofa.sofamq.org.shade.apache.commons.httpclient.methods.StringRequestEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenMetaClient
implements OpenMetaClient {
    protected Logger logger;
    protected ClientOptions clientOptions;
    private ServerAddressing serverAddressing;
    private ServerSelector serverSelector;
    private HttpClient httpClient;

    public AbstractOpenMetaClient(ServerAddressing serverAddressing, ClientOption ... options) {
        this.serverAddressing = Arguments.requireNotNull(serverAddressing, "serverAddressing");
        this.applyOptions(options);
        this.httpClient = new HttpClient();
        this.httpClient.getParams().setSoTimeout(5000);
        this.httpClient.getParams().setConnectionManagerTimeout(60000L);
        this.httpClient.getParams().setContentCharset("UTF-8");
    }

    private void applyOptions(ClientOption ... options) {
        this.clientOptions = this.configOptions(options);
        this.logger = this.clientOptions.getLogger() == null ? LoggerFactory.getLogger(AbstractOpenMetaClient.class) : this.clientOptions.getLogger();
        this.serverSelector = this.clientOptions.getServerSelector() == null ? new RoundRobinServerSelector() : this.clientOptions.getServerSelector();
    }

    private ClientOptions configOptions(ClientOption ... options) {
        ClientOptions clientOptions = new ClientOptions();
        if (options != null && options.length > 0) {
            for (ClientOption option : options) {
                option.configOption(clientOptions);
            }
        }
        return clientOptions;
    }

    protected SchemaDetail getSchemaById0(long id) throws SchemaNotExistException {
        String url = RestfulApiPathUtils.urlOfGetSchemaById(this.getServer(), id);
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(getMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SchemaNotExistException(id);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            SchemaData schemaData = JsonUtils.unmarshalFromString(getMethod.getResponseBodyAsString(), SchemaData.class);
            return Converter.toSchemaDetail(schemaData);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected SchemaDetail searchSchema0(String subject, String schema) throws SchemaNotExistException {
        String url = RestfulApiPathUtils.urlOfSearchSchema(this.getServer(), subject);
        PostMethod postMethod = new PostMethod(url);
        try {
            postMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(schema), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(postMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SchemaNotExistException(subject, schema);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            SchemaData schemaData = JsonUtils.unmarshalFromString(postMethod.getResponseBodyAsString(), SchemaData.class);
            return Converter.toSchemaDetail(schemaData);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected Pair<String, Integer> getSubjectAndVersionBySchemaId0(long schemaId) throws SchemaNotExistException {
        String url = RestfulApiPathUtils.urlOfGetSubjectAndVersion(this.getServer(), schemaId);
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(getMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SchemaNotExistException(schemaId);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            SubjectAndVersion subjectAndVersion = JsonUtils.unmarshalFromString(getMethod.getResponseBodyAsString(), SubjectAndVersion.class);
            return new Pair<String, Integer>(subjectAndVersion.getSubject(), subjectAndVersion.getVersion());
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected List<String> getAllSubjects0() {
        String url = RestfulApiPathUtils.urlOfGetAllSubjects(this.getServer());
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(getMethod);
            if (statusCode != 200) {
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(getMethod.getResponseBodyAsString(), new TypeReference<ArrayList<String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected List<Integer> getSchemaVersions0(String subject) throws SubjectNotExistException {
        String url = RestfulApiPathUtils.urlOfGetSchemaVersionsOfSubject(this.getServer(), subject);
        String response = this.executeGetRequest(url, subject);
        return JsonUtils.unmarshalFromString(response, new TypeReference<ArrayList<Integer>>(){});
    }

    protected List<Integer> deleteSubject0(String subject) throws SubjectNotExistException {
        String url = RestfulApiPathUtils.urlOfDeleteSubject(this.getServer(), subject);
        DeleteMethod deleteMethod = new DeleteMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(deleteMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SubjectNotExistException("", "", subject);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(deleteMethod.getResponseBodyAsString(), new TypeReference<ArrayList<Integer>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected SchemaSummary getMetadata0(String subject) throws SubjectNotExistException {
        String url = RestfulApiPathUtils.urlOfGetSubject(this.getServer(), subject);
        String response = this.executeGetRequest(url, subject);
        return JsonUtils.unmarshalFromString(response, SchemaSummary.class);
    }

    private String executeGetRequest(String url, String subject) throws SubjectNotExistException {
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(getMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SubjectNotExistException("", "", subject);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return getMethod.getResponseBodyAsString();
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected SchemaDetail getSchemaBySubjectAndVersion0(String subject, int version) throws SchemaNotExistException {
        String url = RestfulApiPathUtils.urlOfGetSchemaBySubjectAndVersion(this.getServer(), subject, version);
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(getMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SchemaNotExistException(subject, version);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            CompleteSchemaInfo schemaInfo = JsonUtils.unmarshalFromString(getMethod.getResponseBodyAsString(), CompleteSchemaInfo.class);
            return Converter.toSchemaDetail(schemaInfo.getSchema());
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected SchemaId registerSchemaIfNotExist0(String subject, SchemaDetail schemaDetail) throws CompatibilityException {
        String url = RestfulApiPathUtils.urlOfRegisterSchema(this.getServer(), subject);
        PostMethod postMethod = new PostMethod(url);
        try {
            postMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(Converter.toSchemaData(schemaDetail)), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(postMethod);
            if (statusCode != 200) {
                switch (statusCode) {
                    case 401: {
                        throw new UnauthorizedException();
                    }
                    case 409: {
                        throw new CompatibilityException();
                    }
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(postMethod.getResponseBodyAsString(), SchemaId.class);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected SchemaSummary updateOfRegisterSubject0(SchemaSummary schemaBasicRestDO) throws CompatibilityException {
        String url = RestfulApiPathUtils.urlOfUpdateSubject(this.getServer(), schemaBasicRestDO.getSubject());
        PostMethod postMethod = new PostMethod(url);
        try {
            postMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(schemaBasicRestDO), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(postMethod);
            if (statusCode != 200) {
                switch (statusCode) {
                    case 401: {
                        throw new UnauthorizedException();
                    }
                    case 409: {
                        throw new CompatibilityException();
                    }
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(postMethod.getResponseBodyAsString(), SchemaSummary.class);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected int deleteSchemaBySubjectAndVersion0(String subject, int version) {
        String url = RestfulApiPathUtils.urlOfDeleteSchemaBySubjectAndVersion(this.getServer(), subject, version);
        DeleteMethod deleteMethod = new DeleteMethod(url);
        try {
            int statusCode = this.httpClient.executeMethod(deleteMethod);
            if (statusCode != 200) {
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(deleteMethod.getResponseBodyAsString(), new TypeReference<Integer>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected CompatibilityValidateResult checkCompatibility(String subject, int version, CompatibilityValidateRequest schemaInfo) {
        String url = RestfulApiPathUtils.urlOfCheckCompatibilityUrl(this.getServer(), subject, version);
        try {
            PostMethod postMethod = new PostMethod(url);
            postMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(schemaInfo), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(postMethod);
            if (statusCode != 200) {
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(postMethod.getResponseBodyAsString(), CompatibilityValidateResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected CompatibilityValidateResult checkCanReadCompatibility(String subject, CompatibilityValidateRequest schemaInfo) {
        String url = RestfulApiPathUtils.urlOfCheckCanReadCompatibilityUrl(this.getServer(), subject);
        try {
            PostMethod postMethod = new PostMethod(url);
            postMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(schemaInfo), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(postMethod);
            if (statusCode != 200) {
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(postMethod.getResponseBodyAsString(), CompatibilityValidateResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected CompatibilityConfig getCompatibilityStrategy0(String subject) throws SubjectNotExistException {
        String url = RestfulApiPathUtils.urlOfGetCompatibilityUrl(this.getServer(), subject);
        String response = this.executeGetRequest(url, subject);
        return JsonUtils.unmarshalFromString(response, CompatibilityConfig.class);
    }

    protected CompatibilityConfig updateCompatibilityConfig(String subject, CompatibilityConfig compatibilityConfig) throws SubjectNotExistException {
        String url = RestfulApiPathUtils.urlOfUpdateCompatibility(this.getServer(), subject);
        PutMethod putMethod = new PutMethod(url);
        try {
            putMethod.setRequestEntity(new StringRequestEntity(JsonUtils.marshalToString(compatibilityConfig), "application/json", "UTF-8"));
            int statusCode = this.httpClient.executeMethod(putMethod);
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new SubjectNotExistException("", "", subject);
                }
                throw new RuntimeException(String.format("request %s exception, response code: %d", url, statusCode));
            }
            return JsonUtils.unmarshalFromString(putMethod.getResponseBodyAsString(), CompatibilityConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("request " + url + " encountered exception", e);
        }
    }

    protected String getServer() {
        List<String> servers = this.serverAddressing.addresses();
        if (servers == null || servers.size() == 0) {
            throw new NoAvailableServerException("no server return by serverAddressing: " + (this.serverAddressing.config() == null ? this.serverAddressing.getClass().getName() : this.serverAddressing.config()));
        }
        return this.serverSelector.select(this.serverAddressing.addresses());
    }

    @Override
    public void close() {
    }
}

