/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.client;

import com.alipay.openmeta.client.ClientOption;
import com.alipay.openmeta.client.ServerAddressing;
import com.alipay.openmeta.client.ServerSelector;
import org.slf4j.Logger;

public class ClientOptions {
    private Logger logger;
    private ServerAddressing serverAddressing;
    private ServerSelector serverSelector;
    private int schemaCacheCapacity;
    private long cacheExpiredTimeAfterAccess;

    public Logger getLogger() {
        return this.logger;
    }

    public ServerAddressing getServerAddressing() {
        return this.serverAddressing;
    }

    public ServerSelector getServerSelector() {
        return this.serverSelector;
    }

    public int getSchemaCacheCapacity() {
        return this.schemaCacheCapacity;
    }

    public long getCacheExpiredTimeAfterAccess() {
        return this.cacheExpiredTimeAfterAccess;
    }

    public static ClientOption withLogger(final Logger logger) {
        return new ClientOption(){

            @Override
            public void configOption(ClientOptions options) {
                options.logger = logger;
            }
        };
    }

    public static ClientOption withServerAddressing(final ServerAddressing serverAddressing) {
        return new ClientOption(){

            @Override
            public void configOption(ClientOptions options) {
                options.serverAddressing = serverAddressing;
            }
        };
    }

    public static ClientOption withServerSelector(final ServerSelector serverSelector) {
        return new ClientOption(){

            @Override
            public void configOption(ClientOptions options) {
                options.serverSelector = serverSelector;
            }
        };
    }

    public static ClientOption withSchemaCacheCapcity(final int capacity) {
        return new ClientOption(){

            @Override
            public void configOption(ClientOptions options) {
                options.schemaCacheCapacity = capacity;
            }
        };
    }

    public static ClientOption withCacheExpiredTimeAfterAccess(final long expired) {
        return new ClientOption(){

            @Override
            public void configOption(ClientOptions options) {
                options.cacheExpiredTimeAfterAccess = expired;
            }
        };
    }
}

