/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.client;

import com.alipay.openmeta.client.AbstractOpenMetaClient;
import com.alipay.openmeta.client.ClientOption;
import com.alipay.openmeta.client.ServerAddressing;
import com.alipay.openmeta.common.CompatibilityStrategy;
import com.alipay.openmeta.common.SchemaDetail;
import com.alipay.openmeta.common.SchemaSummary;
import com.alipay.openmeta.common.SchemaType;
import com.alipay.openmeta.data.CompatibilityConfig;
import com.alipay.openmeta.data.CompatibilityValidateRequest;
import com.alipay.openmeta.exception.CompatibilityException;
import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.openmeta.exception.SubjectNotExistException;
import com.alipay.openmeta.utils.Arguments;
import com.alipay.openmeta.utils.Pair;
import java.util.List;

public class DefaultOpenMetaClient
extends AbstractOpenMetaClient {
    public DefaultOpenMetaClient(ServerAddressing serverAddressing, ClientOption ... options) {
        super(serverAddressing, options);
    }

    @Override
    public SchemaDetail getSchemaById(long schemaId) throws SchemaNotExistException {
        return this.getSchemaById0(schemaId);
    }

    @Override
    public Pair<String, Integer> getSubjectAndVersionBySchemaId(long schemaId) throws SchemaNotExistException {
        return this.getSubjectAndVersionBySchemaId0(schemaId);
    }

    @Override
    public List<String> getAllSubjects() {
        return this.getAllSubjects0();
    }

    @Override
    public List<Integer> getSchemaVersions(String subject) throws SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return this.getSchemaVersions0(subject);
    }

    @Override
    public List<Integer> deleteSubject(String subject) throws SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return this.deleteSubject0(subject);
    }

    @Override
    public SchemaSummary getSchemaSummary(String subject) throws SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return this.getMetadata0(subject);
    }

    @Override
    public SchemaDetail getSchemaBySubjectAndVersion(String subject, int version) throws SubjectNotExistException, SchemaNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return this.getSchemaBySubjectAndVersion0(subject, version);
    }

    @Override
    public long registerSchemaIfNotExist(String subject, SchemaDetail schemaDetail) throws CompatibilityException {
        Arguments.requireNotEmpty(subject, "subject");
        Arguments.requireNotNull(schemaDetail, "schemaDetail");
        return this.registerSchemaIfNotExist0(subject, schemaDetail).getId();
    }

    @Override
    public SchemaSummary updateOrRegisterMetadata(SchemaSummary schemaBasicRestDO) throws CompatibilityException {
        Arguments.requireNotNull(schemaBasicRestDO, "metadata");
        return this.updateOfRegisterSubject0(schemaBasicRestDO);
    }

    @Override
    public int deleteSchemaBySubjectAndVersion(String subject, int version) throws SchemaNotExistException, SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return this.deleteSchemaBySubjectAndVersion0(subject, version);
    }

    @Override
    public boolean isCompatible(String subject, SchemaType schemaType, String schemaContent) throws SubjectNotExistException, SchemaNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        Arguments.requireNotNull(schemaType, "schemaType");
        Arguments.requireNotEmpty(schemaContent, "schemaContent");
        CompatibilityValidateRequest schemaInfo = new CompatibilityValidateRequest();
        schemaInfo.setSchemaType(schemaType.name());
        schemaInfo.setSchemaDefinition(schemaContent);
        return this.checkCompatibility(subject, -1, schemaInfo).isCompatible();
    }

    @Override
    public boolean checkReadCompatible(String subject, SchemaType schemaType, String schemaContent) throws SubjectNotExistException, SchemaNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        Arguments.requireNotNull(schemaType, "schemaType");
        Arguments.requireNotEmpty(schemaContent, "schemaContent");
        CompatibilityValidateRequest schemaInfo = new CompatibilityValidateRequest();
        schemaInfo.setSchemaType(schemaType.name());
        schemaInfo.setSchemaDefinition(schemaContent);
        return this.checkCanReadCompatibility(subject, schemaInfo).isCompatible();
    }

    @Override
    public CompatibilityStrategy getCompatibilityStrategy(String subject) throws SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        return CompatibilityStrategy.valueOf(this.getCompatibilityStrategy0(subject).getCompatibility());
    }

    @Override
    public CompatibilityStrategy updateCompatibilityStrategy(String subject, CompatibilityStrategy strategy) throws SubjectNotExistException {
        Arguments.requireNotEmpty(subject, "subject");
        Arguments.requireNotNull(strategy, "strategy");
        CompatibilityConfig config = new CompatibilityConfig();
        config.setCompatibility(strategy.name());
        return CompatibilityStrategy.valueOf(this.updateCompatibilityConfig(subject, config).getCompatibility());
    }

    @Override
    public SchemaDetail searchSchema(String subject, String schema) throws SchemaNotExistException {
        return this.searchSchema0(subject, schema);
    }
}

