/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.client;

import com.alipay.openmeta.common.CompatibilityStrategy;
import com.alipay.openmeta.common.SchemaDetail;
import com.alipay.openmeta.common.SchemaSummary;
import com.alipay.openmeta.common.SchemaType;
import com.alipay.openmeta.exception.CompatibilityException;
import com.alipay.openmeta.exception.SchemaNotExistException;
import com.alipay.openmeta.exception.SubjectNotExistException;
import com.alipay.openmeta.utils.Pair;
import java.util.List;

public interface OpenMetaClient {
    public SchemaDetail getSchemaById(long var1) throws SchemaNotExistException;

    public Pair<String, Integer> getSubjectAndVersionBySchemaId(long var1) throws SchemaNotExistException;

    public List<String> getAllSubjects();

    public List<Integer> getSchemaVersions(String var1) throws SubjectNotExistException;

    public List<Integer> deleteSubject(String var1) throws SubjectNotExistException;

    public SchemaSummary getSchemaSummary(String var1) throws SubjectNotExistException;

    public SchemaDetail getSchemaBySubjectAndVersion(String var1, int var2) throws SubjectNotExistException, SchemaNotExistException;

    public long registerSchemaIfNotExist(String var1, SchemaDetail var2) throws SubjectNotExistException, CompatibilityException;

    public SchemaSummary updateOrRegisterMetadata(SchemaSummary var1) throws CompatibilityException;

    public int deleteSchemaBySubjectAndVersion(String var1, int var2) throws SchemaNotExistException, SubjectNotExistException;

    public boolean isCompatible(String var1, SchemaType var2, String var3) throws SubjectNotExistException, SchemaNotExistException;

    public boolean checkReadCompatible(String var1, SchemaType var2, String var3) throws SubjectNotExistException, SchemaNotExistException;

    public CompatibilityStrategy getCompatibilityStrategy(String var1) throws SubjectNotExistException;

    public CompatibilityStrategy updateCompatibilityStrategy(String var1, CompatibilityStrategy var2) throws SubjectNotExistException;

    public SchemaDetail searchSchema(String var1, String var2) throws SchemaNotExistException;

    public void close() throws Exception;
}

