/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.SchemaIdGenerator;

public abstract class AbstractSchemaIdGenerator
implements SchemaIdGenerator {
    public static final int MIN_ID_PREFIX = 1;
    public static final int MAX_ID_PREFIX = 127;
    public static final int PREFIX_OFFSET = 56;
    public static final int SEQUENCE_OFFSET = 32;
    private final long idPrefix;

    public AbstractSchemaIdGenerator(int idPrefix) {
        if (idPrefix < 1 || idPrefix > 127) {
            throw new IllegalArgumentException("Effective range: (0, 127], given: " + idPrefix);
        }
        this.idPrefix = (long)idPrefix << 56;
    }

    @Override
    public long generateId() {
        return this.idPrefix | (long)this.createSequence();
    }

    protected abstract int createSequence();
}

