/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.Decoder;
import com.alipay.openmeta.exception.DecodeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;

public class AvroDecoder<T>
implements Decoder<T> {
    private ReflectDatumReader<T> reader;
    private static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();

    public AvroDecoder(Schema reader) {
        this.reader = new ReflectDatumReader(reader);
    }

    public AvroDecoder(Schema writer, Schema reader) {
        this.reader = new ReflectDatumReader(writer, reader);
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            BinaryDecoder decoderCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, decoderCache);
            if (decoderCache == null) {
                decoders.set(decoder);
            }
            return (T)this.reader.read(null, (org.apache.avro.io.Decoder)decoder);
        }
        catch (Exception e) {
            throw new DecodeException("decode failed", e);
        }
    }
}

