/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.Encoder;
import com.alipay.openmeta.exception.EncodeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectDatumWriter;

public class AvroEncoder<T>
implements Encoder<T> {
    private ReflectDatumWriter<T> writer;
    private static final ThreadLocal<BinaryEncoder> encoders = new ThreadLocal();
    private static final ThreadLocal<ByteArrayOutputStream> outputStreams = new ThreadLocal();

    public AvroEncoder(Schema schema) {
        this.writer = new ReflectDatumWriter(schema);
    }

    @Override
    public byte[] encode(T data) {
        byte[] bytes;
        ByteArrayOutputStream outputStream = this.getOrCreateOutputStream();
        try {
            BinaryEncoder encoder = this.getOrCreateEncoder(outputStream);
            this.writer.write(data, (org.apache.avro.io.Encoder)encoder);
            encoder.flush();
            bytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            throw new EncodeException("encode failed", e);
        }
        finally {
            outputStream.reset();
        }
        return bytes;
    }

    private ByteArrayOutputStream getOrCreateOutputStream() {
        ByteArrayOutputStream outputStreamCache = outputStreams.get();
        if (outputStreamCache == null) {
            outputStreamCache = new ByteArrayOutputStream();
            outputStreams.set(outputStreamCache);
        }
        return outputStreamCache;
    }

    private BinaryEncoder getOrCreateEncoder(ByteArrayOutputStream outputStream) {
        BinaryEncoder encoderCache = encoders.get();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, encoderCache);
        if (encoderCache == null) {
            encoders.set(encoder);
        }
        return encoder;
    }
}

