/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.CompatibilityStrategy;
import com.alipay.openmeta.common.SchemaCompatibilityCheck;
import com.alipay.openmeta.common.SchemaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;

public class AvroSchemaCompatibilityCheck
implements SchemaCompatibilityCheck {
    public static SchemaValidator ALWAYS_PASS = new AlwaysPassSchemaValidator();
    public static SchemaValidator NEVER_PASS = new NeverPassSchemaValidator();

    @Override
    public boolean isCompatible(Schema from, Schema to, CompatibilityStrategy strategy) {
        return this.isCompatible(Collections.singletonList(from), to, strategy);
    }

    @Override
    public boolean isCompatible(List<Schema> from, Schema to, CompatibilityStrategy strategy) {
        try {
            SchemaValidator schemaValidator = AvroSchemaCompatibilityCheck.createSchemaValidator(strategy);
            schemaValidator.validate(to, from);
        }
        catch (SchemaParseException e) {
            return false;
        }
        catch (SchemaValidationException e) {
            return false;
        }
        return true;
    }

    @Override
    public SchemaType schemaType() {
        return SchemaType.AVRO;
    }

    public static SchemaValidator createSchemaValidator(CompatibilityStrategy compatibilityStrategy) {
        switch (compatibilityStrategy) {
            case BACKWARD_TRANSITIVE: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.CAN_READ, false);
            }
            case BACKWARD: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.CAN_READ, true);
            }
            case FORWARD_TRANSITIVE: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.CAN_BE_READ, false);
            }
            case FORWARD: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.CAN_BE_READ, true);
            }
            case FULL_TRANSITIVE: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.MUTUAL_READ, false);
            }
            case FULL: {
                return AvroSchemaCompatibilityCheck.newValidator(Strategy.MUTUAL_READ, true);
            }
            case ALWAYS_COMPATIBLE: {
                return ALWAYS_PASS;
            }
        }
        return NEVER_PASS;
    }

    public static SchemaValidator newValidator(Strategy strategy, boolean onlyLatest) {
        SchemaValidatorBuilder validatorBuilder = new SchemaValidatorBuilder();
        switch (strategy) {
            case CAN_READ: {
                validatorBuilder = validatorBuilder.canReadStrategy();
                break;
            }
            case CAN_BE_READ: {
                validatorBuilder = validatorBuilder.canBeReadStrategy();
                break;
            }
            case MUTUAL_READ: {
                validatorBuilder = validatorBuilder.mutualReadStrategy();
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return onlyLatest ? validatorBuilder.validateLatest() : validatorBuilder.validateAll();
    }

    static class NeverPassSchemaValidator
    implements SchemaValidator {
        NeverPassSchemaValidator() {
        }

        public void validate(Schema toValidate, Iterable<Schema> existing) throws SchemaValidationException {
            Iterator<Schema> iterator = existing.iterator();
            if (iterator.hasNext()) {
                Schema tmp = iterator.next();
                throw new SchemaValidationException(tmp, toValidate);
            }
        }
    }

    static class AlwaysPassSchemaValidator
    implements SchemaValidator {
        AlwaysPassSchemaValidator() {
        }

        public void validate(Schema toValidate, Iterable<Schema> existing) throws SchemaValidationException {
        }
    }

    static enum Strategy {
        CAN_READ,
        CAN_BE_READ,
        MUTUAL_READ;

    }
}

