/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.exception.NoSuchEnumException;

public enum CompatibilityStrategy {
    ALWAYS_COMPATIBLE(0),
    ALWAYS_INCOMPATIBLE(1),
    BACKWARD(2),
    BACKWARD_TRANSITIVE(3),
    FORWARD(4),
    FORWARD_TRANSITIVE(5),
    FULL(6),
    FULL_TRANSITIVE(7);

    private int code;

    private CompatibilityStrategy(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static CompatibilityStrategy valueOf(int value) {
        switch (value) {
            case 0: {
                return ALWAYS_COMPATIBLE;
            }
            case 1: {
                return ALWAYS_INCOMPATIBLE;
            }
            case 2: {
                return BACKWARD;
            }
            case 3: {
                return BACKWARD_TRANSITIVE;
            }
            case 4: {
                return FORWARD;
            }
            case 5: {
                return FORWARD_TRANSITIVE;
            }
            case 6: {
                return FULL;
            }
            case 7: {
                return FULL_TRANSITIVE;
            }
        }
        throw new NoSuchEnumException(String.format("no such schema compatibility strategy, value=[%s]", value));
    }
}

