/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.FieldValidator;
import com.alipay.openmeta.common.FieldValidatorListImpl;
import com.alipay.openmeta.common.GroovyFieldValidator;
import com.alipay.openmeta.common.NoopFieldValidator;
import com.alipay.openmeta.utils.Arguments;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import java.util.List;

public class FieldValidatorFactory {
    public static FieldValidator fromRule(String rules) {
        if (Arguments.isBlank(rules)) {
            return NoopFieldValidator.instance();
        }
        List<GroovyFieldValidator> validators = FieldValidatorFactory.fromJsonString(rules);
        if (validators.size() == 1) {
            return validators.get(0);
        }
        FieldValidatorListImpl fieldValidatorList = new FieldValidatorListImpl();
        if (!Arguments.isBlank(rules)) {
            for (FieldValidator fieldValidator : validators) {
                fieldValidatorList.addValidator(fieldValidator);
            }
        }
        return fieldValidatorList;
    }

    public static List<GroovyFieldValidator> fromJsonString(String validatorRules) {
        return JSON.parseArray(validatorRules, GroovyFieldValidator.class);
    }

    public static String toJsonString(List<GroovyFieldValidator> validators) {
        return JSON.toJSONString(validators);
    }
}

