/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.AbstractSingleFieldValidator;
import com.alipay.openmeta.common.FieldValidator;
import com.alipay.openmeta.common.FieldValidatorList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class FieldValidatorListImpl
implements FieldValidatorList {
    private List<FieldValidator> fieldValidators;

    @Override
    public FieldValidator getFieldValidator(String fieldName) {
        for (FieldValidator validator : this.fieldValidators) {
            AbstractSingleFieldValidator singleFieldValidator = (AbstractSingleFieldValidator)validator;
            if (!singleFieldValidator.match(fieldName)) continue;
            return validator;
        }
        return null;
    }

    @Override
    public synchronized boolean addValidator(FieldValidator fieldValidator) {
        if (this.fieldValidators == null) {
            this.fieldValidators = new ArrayList<FieldValidator>();
        }
        return this.fieldValidators.add(fieldValidator);
    }

    @Override
    public boolean validate(Object data) {
        Class<?> clazz = data.getClass();
        for (Field field : clazz.getFields()) {
            FieldValidator fieldValidator = this.getFieldValidator(field.getName());
            field.setAccessible(true);
            if (fieldValidator == null) continue;
            try {
                boolean success = fieldValidator.validate(field.get(data));
                if (success) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean match(String fieldName) {
        for (FieldValidator fieldValidator : this.fieldValidators) {
            if (!fieldValidator.match(fieldName)) continue;
            return true;
        }
        return false;
    }
}

