/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.FieldValidator;
import com.alipay.openmeta.common.FieldValidatorFactory;
import com.alipay.openmeta.common.SchemaDetail;
import com.alipay.openmeta.common.SchemaInfo;
import com.alipay.openmeta.common.SchemaUtils;
import com.alipay.openmeta.schema.Schema;

public class SchemaAndFieldValidator<T> {
    private Schema<T> schema;
    private FieldValidator validator;

    public SchemaAndFieldValidator(SchemaDetail detail) {
        SchemaInfo schemaInfo = new SchemaInfo();
        schemaInfo.setId(detail.getUniqId());
        schemaInfo.setVersion(detail.getVersion());
        schemaInfo.setSerializationType(detail.getSerialization());
        schemaInfo.setSchemaType(detail.getType());
        schemaInfo.setSchema(detail.getContent());
        this.schema = SchemaUtils.getSchema(schemaInfo);
        this.validator = FieldValidatorFactory.fromRule(detail.getFieldValidateRule());
    }

    public boolean validateSchema(byte[] bytes) {
        return this.schema.validate(bytes);
    }

    public byte[] encode(T data) {
        return this.schema.encode(data);
    }

    public T decode(byte[] bytes) {
        return this.schema.decode(bytes);
    }

    public boolean validateFields(T data) {
        return this.validator.validate(data);
    }
}

