/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.openmeta.common;

import com.alipay.openmeta.common.SchemaInfo;
import com.alipay.openmeta.schema.AvroSchema;
import com.alipay.openmeta.schema.Schema;
import com.alipay.openmeta.utils.Arguments;
import java.io.UnsupportedEncodingException;

public class SchemaUtils {
    public static Schema<?> getSchema(SchemaInfo schemaInfo) {
        return new AvroSchema(schemaInfo);
    }

    public static byte[] toBytes(String schema) {
        Arguments.requireNotEmpty(schema, "schema");
        try {
            return schema.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(String.format("can not happened here, schema=%s", schema));
        }
    }

    public static String fromBytes(byte[] bytes) {
        Arguments.requireNotNull(bytes, "bytes");
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(String.format("can not happened here, bytes=%s", new Object[]{bytes}));
        }
    }
}

